/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tasks;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tasks.requests.AddTaskToGroupReq;
import com.chrt.api.types.TaskClientUpdate1;

public class TasksClient {
    protected final ClientOptions clientOptions;

    private final RawTasksClient rawClient;

    public TasksClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTasksClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTasksClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Adds a new task to a task group at a specific index. | authz_personas=[lig_org_operators] | (AddTaskToGroupReq) -&gt; (PydanticObjectId)
     */
    public String addToTaskGroupV1(String taskGroupId, AddTaskToGroupReq request) {
        return this.rawClient.addToTaskGroupV1(taskGroupId, request).body();
    }

    /**
     * Adds a new task to a task group at a specific index. | authz_personas=[lig_org_operators] | (AddTaskToGroupReq) -&gt; (PydanticObjectId)
     */
    public String addToTaskGroupV1(String taskGroupId, AddTaskToGroupReq request, RequestOptions requestOptions) {
        return this.rawClient
                .addToTaskGroupV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Updates a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | (TaskClientUpdate1) -&gt; (PydanticObjectId)
     */
    public String updateV1(String taskId) {
        return this.rawClient.updateV1(taskId).body();
    }

    /**
     * Updates a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | (TaskClientUpdate1) -&gt; (PydanticObjectId)
     */
    public String updateV1(String taskId, TaskClientUpdate1 request) {
        return this.rawClient.updateV1(taskId, request).body();
    }

    /**
     * Updates a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | (TaskClientUpdate1) -&gt; (PydanticObjectId)
     */
    public String updateV1(String taskId, TaskClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(taskId, request, requestOptions).body();
    }

    /**
     * Marks a task as COMPLETED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public boolean completeV1(String taskId) {
        return this.rawClient.completeV1(taskId).body();
    }

    /**
     * Marks a task as COMPLETED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public boolean completeV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.completeV1(taskId, requestOptions).body();
    }

    /**
     * Marks a task as SKIPPED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public boolean skipV1(String taskId) {
        return this.rawClient.skipV1(taskId).body();
    }

    /**
     * Marks a task as SKIPPED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public boolean skipV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.skipV1(taskId, requestOptions).body();
    }

    /**
     * Deletes a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | () -&gt; (bool)
     */
    public boolean deleteV1(String taskId) {
        return this.rawClient.deleteV1(taskId).body();
    }

    /**
     * Deletes a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | () -&gt; (bool)
     */
    public boolean deleteV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskId, requestOptions).body();
    }
}
