/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.devices.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.TrackingDeviceTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DevicesUpdateRequest1.Builder.class)
public final class DevicesUpdateRequest1 {
    private final Optional<String> deviceId;

    private final Optional<String> deviceMacAddress;

    private final Optional<TrackingDeviceTypeEnum1> type;

    private final Optional<String> comments;

    private final Optional<Boolean> deleteType;

    private final Optional<Boolean> deleteComments;

    private final Map<String, Object> additionalProperties;

    private DevicesUpdateRequest1(
            Optional<String> deviceId,
            Optional<String> deviceMacAddress,
            Optional<TrackingDeviceTypeEnum1> type,
            Optional<String> comments,
            Optional<Boolean> deleteType,
            Optional<Boolean> deleteComments,
            Map<String, Object> additionalProperties) {
        this.deviceId = deviceId;
        this.deviceMacAddress = deviceMacAddress;
        this.type = type;
        this.comments = comments;
        this.deleteType = deleteType;
        this.deleteComments = deleteComments;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getDeviceId() {
        if (deviceId == null) {
            return Optional.empty();
        }
        return deviceId;
    }

    @JsonIgnore
    public Optional<String> getDeviceMacAddress() {
        if (deviceMacAddress == null) {
            return Optional.empty();
        }
        return deviceMacAddress;
    }

    @JsonIgnore
    public Optional<TrackingDeviceTypeEnum1> getType() {
        if (type == null) {
            return Optional.empty();
        }
        return type;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (comments == null) {
            return Optional.empty();
        }
        return comments;
    }

    @JsonProperty("delete_type")
    public Optional<Boolean> getDeleteType() {
        return deleteType;
    }

    @JsonProperty("delete_comments")
    public Optional<Boolean> getDeleteComments() {
        return deleteComments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("device_id")
    private Optional<String> _getDeviceId() {
        return deviceId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("device_mac_address")
    private Optional<String> _getDeviceMacAddress() {
        return deviceMacAddress;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("type")
    private Optional<TrackingDeviceTypeEnum1> _getType() {
        return type;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comments")
    private Optional<String> _getComments() {
        return comments;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DevicesUpdateRequest1 && equalTo((DevicesUpdateRequest1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DevicesUpdateRequest1 other) {
        return deviceId.equals(other.deviceId)
                && deviceMacAddress.equals(other.deviceMacAddress)
                && type.equals(other.type)
                && comments.equals(other.comments)
                && deleteType.equals(other.deleteType)
                && deleteComments.equals(other.deleteComments);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.deviceId, this.deviceMacAddress, this.type, this.comments, this.deleteType, this.deleteComments);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> deviceId = Optional.empty();

        private Optional<String> deviceMacAddress = Optional.empty();

        private Optional<TrackingDeviceTypeEnum1> type = Optional.empty();

        private Optional<String> comments = Optional.empty();

        private Optional<Boolean> deleteType = Optional.empty();

        private Optional<Boolean> deleteComments = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(DevicesUpdateRequest1 other) {
            deviceId(other.getDeviceId());
            deviceMacAddress(other.getDeviceMacAddress());
            type(other.getType());
            comments(other.getComments());
            deleteType(other.getDeleteType());
            deleteComments(other.getDeleteComments());
            return this;
        }

        @JsonSetter(value = "device_id", nulls = Nulls.SKIP)
        public Builder deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = Optional.ofNullable(deviceId);
            return this;
        }

        public Builder deviceId(Nullable<String> deviceId) {
            if (deviceId.isNull()) {
                this.deviceId = null;
            } else if (deviceId.isEmpty()) {
                this.deviceId = Optional.empty();
            } else {
                this.deviceId = Optional.of(deviceId.get());
            }
            return this;
        }

        @JsonSetter(value = "device_mac_address", nulls = Nulls.SKIP)
        public Builder deviceMacAddress(Optional<String> deviceMacAddress) {
            this.deviceMacAddress = deviceMacAddress;
            return this;
        }

        public Builder deviceMacAddress(String deviceMacAddress) {
            this.deviceMacAddress = Optional.ofNullable(deviceMacAddress);
            return this;
        }

        public Builder deviceMacAddress(Nullable<String> deviceMacAddress) {
            if (deviceMacAddress.isNull()) {
                this.deviceMacAddress = null;
            } else if (deviceMacAddress.isEmpty()) {
                this.deviceMacAddress = Optional.empty();
            } else {
                this.deviceMacAddress = Optional.of(deviceMacAddress.get());
            }
            return this;
        }

        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<TrackingDeviceTypeEnum1> type) {
            this.type = type;
            return this;
        }

        public Builder type(TrackingDeviceTypeEnum1 type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        public Builder type(Nullable<TrackingDeviceTypeEnum1> type) {
            if (type.isNull()) {
                this.type = null;
            } else if (type.isEmpty()) {
                this.type = Optional.empty();
            } else {
                this.type = Optional.of(type.get());
            }
            return this;
        }

        @JsonSetter(value = "comments", nulls = Nulls.SKIP)
        public Builder comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        public Builder comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        public Builder comments(Nullable<String> comments) {
            if (comments.isNull()) {
                this.comments = null;
            } else if (comments.isEmpty()) {
                this.comments = Optional.empty();
            } else {
                this.comments = Optional.of(comments.get());
            }
            return this;
        }

        @JsonSetter(value = "delete_type", nulls = Nulls.SKIP)
        public Builder deleteType(Optional<Boolean> deleteType) {
            this.deleteType = deleteType;
            return this;
        }

        public Builder deleteType(Boolean deleteType) {
            this.deleteType = Optional.ofNullable(deleteType);
            return this;
        }

        @JsonSetter(value = "delete_comments", nulls = Nulls.SKIP)
        public Builder deleteComments(Optional<Boolean> deleteComments) {
            this.deleteComments = deleteComments;
            return this;
        }

        public Builder deleteComments(Boolean deleteComments) {
            this.deleteComments = Optional.ofNullable(deleteComments);
            return this;
        }

        public DevicesUpdateRequest1 build() {
            return new DevicesUpdateRequest1(
                    deviceId, deviceMacAddress, type, comments, deleteType, deleteComments, additionalProperties);
        }
    }
}
