/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.driver.requests;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LocationFeature;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DriverUpdateReq.Builder.class)
public final class DriverUpdateReq {
    private final OffsetDateTime timestamp;

    private final LocationFeature location;

    private final Map<String, Object> additionalProperties;

    private DriverUpdateReq(
            OffsetDateTime timestamp, LocationFeature location, Map<String, Object> additionalProperties) {
        this.timestamp = timestamp;
        this.location = location;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("timestamp")
    public OffsetDateTime getTimestamp() {
        return timestamp;
    }

    @JsonProperty("location")
    public LocationFeature getLocation() {
        return location;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DriverUpdateReq && equalTo((DriverUpdateReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DriverUpdateReq other) {
        return timestamp.equals(other.timestamp) && location.equals(other.location);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.timestamp, this.location);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TimestampStage builder() {
        return new Builder();
    }

    public interface TimestampStage {
        LocationStage timestamp(@NotNull OffsetDateTime timestamp);

        Builder from(DriverUpdateReq other);
    }

    public interface LocationStage {
        _FinalStage location(@NotNull LocationFeature location);
    }

    public interface _FinalStage {
        DriverUpdateReq build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TimestampStage, LocationStage, _FinalStage {
        private OffsetDateTime timestamp;

        private LocationFeature location;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DriverUpdateReq other) {
            timestamp(other.getTimestamp());
            location(other.getLocation());
            return this;
        }

        @java.lang.Override
        @JsonSetter("timestamp")
        public LocationStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("location")
        public _FinalStage location(@NotNull LocationFeature location) {
            this.location = Objects.requireNonNull(location, "location must not be null");
            return this;
        }

        @java.lang.Override
        public DriverUpdateReq build() {
            return new DriverUpdateReq(timestamp, location, additionalProperties);
        }
    }
}
