/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.sharing;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.tracking.sharing.requests.CargoByDeviceSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharing.requests.CargoByDriverSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharing.requests.TaskGroupByDriverSharingSettingsUpdateReq;
import com.chrt.api.types.CargoByDeviceSharingSettings1;
import com.chrt.api.types.CargoByDriverSharingSettings1;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.TaskGroupByDriverSharingSettings1;
import com.chrt.api.types.TrackingSharingSettingsRes;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawSharingClient {
    protected final ClientOptions clientOptions;

    public AsyncRawSharingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Get all tracking datasets and their sharing settings for a given order. | authz_personas=[shipper_org_operators, forwarder_org_operators, courier_org_operators] | () -&gt; (list[TrackingSharingSettingsRes])
     */
    public CompletableFuture<ChrtApiHttpResponse<List<TrackingSharingSettingsRes>>> getSettingsV1(
            String orderIdOrShortId) {
        return getSettingsV1(orderIdOrShortId, null);
    }

    /**
     * Get all tracking datasets and their sharing settings for a given order. | authz_personas=[shipper_org_operators, forwarder_org_operators, courier_org_operators] | () -&gt; (list[TrackingSharingSettingsRes])
     */
    public CompletableFuture<ChrtApiHttpResponse<List<TrackingSharingSettingsRes>>> getSettingsV1(
            String orderIdOrShortId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/sharing_settings/by_order/v1")
                .addPathSegment(orderIdOrShortId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<List<TrackingSharingSettingsRes>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, new TypeReference<List<TrackingSharingSettingsRes>>() {}),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Updates the sharing settings for a task group by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (TaskGroupByDriverSharingSettingsUpdateReq) -&gt; (TaskGroupByDriverSharingSettings1)
     */
    public CompletableFuture<ChrtApiHttpResponse<TaskGroupByDriverSharingSettings1>> taskGroupByDriverSharingSettingsV1(
            TaskGroupByDriverSharingSettingsUpdateReq request) {
        return taskGroupByDriverSharingSettingsV1(request, null);
    }

    /**
     * Updates the sharing settings for a task group by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (TaskGroupByDriverSharingSettingsUpdateReq) -&gt; (TaskGroupByDriverSharingSettings1)
     */
    public CompletableFuture<ChrtApiHttpResponse<TaskGroupByDriverSharingSettings1>> taskGroupByDriverSharingSettingsV1(
            TaskGroupByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/task_group_by_driver/sharing_settings/v1")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<TaskGroupByDriverSharingSettings1>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, TaskGroupByDriverSharingSettings1.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Updates the sharing settings for a cargo by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (CargoByDriverSharingSettingsUpdateReq) -&gt; (CargoByDriverSharingSettings1)
     */
    public CompletableFuture<ChrtApiHttpResponse<CargoByDriverSharingSettings1>> cargoByDriverSettingsV1(
            CargoByDriverSharingSettingsUpdateReq request) {
        return cargoByDriverSettingsV1(request, null);
    }

    /**
     * Updates the sharing settings for a cargo by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (CargoByDriverSharingSettingsUpdateReq) -&gt; (CargoByDriverSharingSettings1)
     */
    public CompletableFuture<ChrtApiHttpResponse<CargoByDriverSharingSettings1>> cargoByDriverSettingsV1(
            CargoByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/cargo_by_driver/sharing_settings/v1")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<CargoByDriverSharingSettings1>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, CargoByDriverSharingSettings1.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Updates the sharing settings for a cargo by device tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, order_creator_org_operators] | (CargoByDeviceSharingSettingsUpdateReq) -&gt; (CargoByDeviceSharingSettings1)
     */
    public CompletableFuture<ChrtApiHttpResponse<CargoByDeviceSharingSettings1>> cargoByDeviceSettingsV1(
            CargoByDeviceSharingSettingsUpdateReq request) {
        return cargoByDeviceSettingsV1(request, null);
    }

    /**
     * Updates the sharing settings for a cargo by device tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, order_creator_org_operators] | (CargoByDeviceSharingSettingsUpdateReq) -&gt; (CargoByDeviceSharingSettings1)
     */
    public CompletableFuture<ChrtApiHttpResponse<CargoByDeviceSharingSettings1>> cargoByDeviceSettingsV1(
            CargoByDeviceSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/cargo_by_device/sharing_settings/v1")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<CargoByDeviceSharingSettings1>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, CargoByDeviceSharingSettings1.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
