/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.sharing;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.sharing.requests.CargoByDeviceSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharing.requests.CargoByDriverSharingSettingsUpdateReq;
import com.chrt.api.resources.tracking.sharing.requests.TaskGroupByDriverSharingSettingsUpdateReq;
import com.chrt.api.types.CargoByDeviceSharingSettings1;
import com.chrt.api.types.CargoByDriverSharingSettings1;
import com.chrt.api.types.TaskGroupByDriverSharingSettings1;
import com.chrt.api.types.TrackingSharingSettingsRes;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncSharingClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawSharingClient rawClient;

    public AsyncSharingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSharingClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawSharingClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Get all tracking datasets and their sharing settings for a given order. | authz_personas=[shipper_org_operators, forwarder_org_operators, courier_org_operators] | () -&gt; (list[TrackingSharingSettingsRes])
     */
    public CompletableFuture<List<TrackingSharingSettingsRes>> getSettingsV1(String orderIdOrShortId) {
        return this.rawClient.getSettingsV1(orderIdOrShortId).thenApply(response -> response.body());
    }

    /**
     * Get all tracking datasets and their sharing settings for a given order. | authz_personas=[shipper_org_operators, forwarder_org_operators, courier_org_operators] | () -&gt; (list[TrackingSharingSettingsRes])
     */
    public CompletableFuture<List<TrackingSharingSettingsRes>> getSettingsV1(
            String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient.getSettingsV1(orderIdOrShortId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates the sharing settings for a task group by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (TaskGroupByDriverSharingSettingsUpdateReq) -&gt; (TaskGroupByDriverSharingSettings1)
     */
    public CompletableFuture<TaskGroupByDriverSharingSettings1> taskGroupByDriverSharingSettingsV1(
            TaskGroupByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.taskGroupByDriverSharingSettingsV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates the sharing settings for a task group by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (TaskGroupByDriverSharingSettingsUpdateReq) -&gt; (TaskGroupByDriverSharingSettings1)
     */
    public CompletableFuture<TaskGroupByDriverSharingSettings1> taskGroupByDriverSharingSettingsV1(
            TaskGroupByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient
                .taskGroupByDriverSharingSettingsV1(request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Updates the sharing settings for a cargo by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (CargoByDriverSharingSettingsUpdateReq) -&gt; (CargoByDriverSharingSettings1)
     */
    public CompletableFuture<CargoByDriverSharingSettings1> cargoByDriverSettingsV1(
            CargoByDriverSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDriverSettingsV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates the sharing settings for a cargo by driver tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, courier_org_operators, courier_driver] | (CargoByDriverSharingSettingsUpdateReq) -&gt; (CargoByDriverSharingSettings1)
     */
    public CompletableFuture<CargoByDriverSharingSettings1> cargoByDriverSettingsV1(
            CargoByDriverSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDriverSettingsV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates the sharing settings for a cargo by device tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, order_creator_org_operators] | (CargoByDeviceSharingSettingsUpdateReq) -&gt; (CargoByDeviceSharingSettings1)
     */
    public CompletableFuture<CargoByDeviceSharingSettings1> cargoByDeviceSettingsV1(
            CargoByDeviceSharingSettingsUpdateReq request) {
        return this.rawClient.cargoByDeviceSettingsV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates the sharing settings for a cargo by device tracking dataset. | authz_personas=[forwarder_org_operators, shipper_org_operators, order_creator_org_operators] | (CargoByDeviceSharingSettingsUpdateReq) -&gt; (CargoByDeviceSharingSettings1)
     */
    public CompletableFuture<CargoByDeviceSharingSettings1> cargoByDeviceSettingsV1(
            CargoByDeviceSharingSettingsUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.cargoByDeviceSettingsV1(request, requestOptions).thenApply(response -> response.body());
    }
}
