/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.timeseries.cargobydevice;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceDataPointsPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceDataPointsV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceLastSeenPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceLastSeenV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceMarkOutliersRequest1;
import com.chrt.api.types.CargoByDeviceDataPoint1;
import com.chrt.api.types.CargoByDeviceMarkOutliersResponse1;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncCargoByDeviceClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCargoByDeviceClient rawClient;

    public AsyncCargoByDeviceClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCargoByDeviceClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCargoByDeviceClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns the last seen data point for cargo within a task group. Access granted to courier or shipper organization. | () -&gt; (CargoByDeviceDataPoint1 | None)
     */
    public CompletableFuture<Optional<CargoByDeviceDataPoint1>> lastSeenV1(CargoByDeviceLastSeenV1Request request) {
        return this.rawClient.lastSeenV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the last seen data point for cargo within a task group. Access granted to courier or shipper organization. | () -&gt; (CargoByDeviceDataPoint1 | None)
     */
    public CompletableFuture<Optional<CargoByDeviceDataPoint1>> lastSeenV1(
            CargoByDeviceLastSeenV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a cargo within a task group, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[CargoByDeviceDataPoint1])
     */
    public CompletableFuture<List<CargoByDeviceDataPoint1>> dataPointsV1(CargoByDeviceDataPointsV1Request request) {
        return this.rawClient.dataPointsV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a cargo within a task group, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[CargoByDeviceDataPoint1])
     */
    public CompletableFuture<List<CargoByDeviceDataPoint1>> dataPointsV1(
            CargoByDeviceDataPointsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Marks data points as outliers or non-outliers. Uses atomic delete and reinsert strategy for time-series collection updates. | authz: allowed_org_types=[shipper, forwarder], min_org_role=operator | (CargoByDeviceMarkOutliersRequest1) -&gt; (CargoByDeviceMarkOutliersResponse1)
     */
    public CompletableFuture<CargoByDeviceMarkOutliersResponse1> outlierV1(CargoByDeviceMarkOutliersRequest1 request) {
        return this.rawClient.outlierV1(request).thenApply(response -> response.body());
    }

    /**
     * Marks data points as outliers or non-outliers. Uses atomic delete and reinsert strategy for time-series collection updates. | authz: allowed_org_types=[shipper, forwarder], min_org_role=operator | (CargoByDeviceMarkOutliersRequest1) -&gt; (CargoByDeviceMarkOutliersResponse1)
     */
    public CompletableFuture<CargoByDeviceMarkOutliersResponse1> outlierV1(
            CargoByDeviceMarkOutliersRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.outlierV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent device location data point for a cargo within a public task group. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (CargoByDeviceDataPoint1 | None)
     */
    public CompletableFuture<Optional<CargoByDeviceDataPoint1>> lastSeenPublicV1(
            CargoByDeviceLastSeenPublicV1Request request) {
        return this.rawClient.lastSeenPublicV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent device location data point for a cargo within a public task group. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (CargoByDeviceDataPoint1 | None)
     */
    public CompletableFuture<Optional<CargoByDeviceDataPoint1>> lastSeenPublicV1(
            CargoByDeviceLastSeenPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenPublicV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a cargo within a public task group, intelligently sampled across the time range. Excludes outliers. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (list[CargoByDeviceDataPoint1])
     */
    public CompletableFuture<List<CargoByDeviceDataPoint1>> dataPointsPublicV1(
            CargoByDeviceDataPointsPublicV1Request request) {
        return this.rawClient.dataPointsPublicV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a cargo within a public task group, intelligently sampled across the time range. Excludes outliers. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (list[CargoByDeviceDataPoint1])
     */
    public CompletableFuture<List<CargoByDeviceDataPoint1>> dataPointsPublicV1(
            CargoByDeviceDataPointsPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsPublicV1(request, requestOptions).thenApply(response -> response.body());
    }
}
