/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.timeseries.cargobydevice;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceDataPointsPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceDataPointsV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceLastSeenPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceLastSeenV1Request;
import com.chrt.api.resources.tracking.timeseries.cargobydevice.requests.CargoByDeviceMarkOutliersRequest1;
import com.chrt.api.types.CargoByDeviceDataPoint1;
import com.chrt.api.types.CargoByDeviceMarkOutliersResponse1;
import java.util.List;
import java.util.Optional;

public class CargoByDeviceClient {
    protected final ClientOptions clientOptions;

    private final RawCargoByDeviceClient rawClient;

    public CargoByDeviceClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCargoByDeviceClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawCargoByDeviceClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns the last seen data point for cargo within a task group. Access granted to courier or shipper organization. | () -&gt; (CargoByDeviceDataPoint1 | None)
     */
    public Optional<CargoByDeviceDataPoint1> lastSeenV1(CargoByDeviceLastSeenV1Request request) {
        return this.rawClient.lastSeenV1(request).body();
    }

    /**
     * Returns the last seen data point for cargo within a task group. Access granted to courier or shipper organization. | () -&gt; (CargoByDeviceDataPoint1 | None)
     */
    public Optional<CargoByDeviceDataPoint1> lastSeenV1(
            CargoByDeviceLastSeenV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenV1(request, requestOptions).body();
    }

    /**
     * Returns up to the specified number of data points for a cargo within a task group, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[CargoByDeviceDataPoint1])
     */
    public List<CargoByDeviceDataPoint1> dataPointsV1(CargoByDeviceDataPointsV1Request request) {
        return this.rawClient.dataPointsV1(request).body();
    }

    /**
     * Returns up to the specified number of data points for a cargo within a task group, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[CargoByDeviceDataPoint1])
     */
    public List<CargoByDeviceDataPoint1> dataPointsV1(
            CargoByDeviceDataPointsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsV1(request, requestOptions).body();
    }

    /**
     * Marks data points as outliers or non-outliers. Uses atomic delete and reinsert strategy for time-series collection updates. | authz: allowed_org_types=[shipper, forwarder], min_org_role=operator | (CargoByDeviceMarkOutliersRequest1) -&gt; (CargoByDeviceMarkOutliersResponse1)
     */
    public CargoByDeviceMarkOutliersResponse1 outlierV1(CargoByDeviceMarkOutliersRequest1 request) {
        return this.rawClient.outlierV1(request).body();
    }

    /**
     * Marks data points as outliers or non-outliers. Uses atomic delete and reinsert strategy for time-series collection updates. | authz: allowed_org_types=[shipper, forwarder], min_org_role=operator | (CargoByDeviceMarkOutliersRequest1) -&gt; (CargoByDeviceMarkOutliersResponse1)
     */
    public CargoByDeviceMarkOutliersResponse1 outlierV1(
            CargoByDeviceMarkOutliersRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.outlierV1(request, requestOptions).body();
    }

    /**
     * Returns the most recent device location data point for a cargo within a public task group. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (CargoByDeviceDataPoint1 | None)
     */
    public Optional<CargoByDeviceDataPoint1> lastSeenPublicV1(CargoByDeviceLastSeenPublicV1Request request) {
        return this.rawClient.lastSeenPublicV1(request).body();
    }

    /**
     * Returns the most recent device location data point for a cargo within a public task group. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (CargoByDeviceDataPoint1 | None)
     */
    public Optional<CargoByDeviceDataPoint1> lastSeenPublicV1(
            CargoByDeviceLastSeenPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenPublicV1(request, requestOptions).body();
    }

    /**
     * Returns up to the specified number of data points for a cargo within a public task group, intelligently sampled across the time range. Excludes outliers. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (list[CargoByDeviceDataPoint1])
     */
    public List<CargoByDeviceDataPoint1> dataPointsPublicV1(CargoByDeviceDataPointsPublicV1Request request) {
        return this.rawClient.dataPointsPublicV1(request).body();
    }

    /**
     * Returns up to the specified number of data points for a cargo within a public task group, intelligently sampled across the time range. Excludes outliers. No authentication required if cargo has public visibility enabled via sharing settings. | () -&gt; (list[CargoByDeviceDataPoint1])
     */
    public List<CargoByDeviceDataPoint1> dataPointsPublicV1(
            CargoByDeviceDataPointsPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsPublicV1(request, requestOptions).body();
    }
}
