/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.timeseries.sessionbydevice;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests.SessionByDeviceDataPointsPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests.SessionByDeviceDataPointsV1Request;
import com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests.SessionByDeviceLastSeenPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests.SessionByDeviceLastSeenV1Request;
import com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests.SessionByDeviceMarkOutliersRequest1;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.SessionByDeviceDataPoint1;
import com.chrt.api.types.SessionByDeviceMarkOutliersResponse1;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawSessionByDeviceClient {
    protected final ClientOptions clientOptions;

    public AsyncRawSessionByDeviceClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Returns the most recent data point for a session, excluding outliers. Access restricted to the caller's organization. | authz: min_org_role=operator | () -&gt; (SessionByDeviceDataPoint1 | None)
     */
    public CompletableFuture<ChrtApiHttpResponse<Optional<SessionByDeviceDataPoint1>>> lastSeenV1(
            SessionByDeviceLastSeenV1Request request) {
        return lastSeenV1(request, null);
    }

    /**
     * Returns the most recent data point for a session, excluding outliers. Access restricted to the caller's organization. | authz: min_org_role=operator | () -&gt; (SessionByDeviceDataPoint1 | None)
     */
    public CompletableFuture<ChrtApiHttpResponse<Optional<SessionByDeviceDataPoint1>>> lastSeenV1(
            SessionByDeviceLastSeenV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/session_by_device_timeseries/last_seen/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "session_id", request.getSessionId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Optional<SessionByDeviceDataPoint1>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString,
                                        new TypeReference<Optional<SessionByDeviceDataPoint1>>() {}),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Returns up to the specified number of data points for a session, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[SessionByDeviceDataPoint1])
     */
    public CompletableFuture<ChrtApiHttpResponse<List<SessionByDeviceDataPoint1>>> dataPointsV1(
            SessionByDeviceDataPointsV1Request request) {
        return dataPointsV1(request, null);
    }

    /**
     * Returns up to the specified number of data points for a session, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[SessionByDeviceDataPoint1])
     */
    public CompletableFuture<ChrtApiHttpResponse<List<SessionByDeviceDataPoint1>>> dataPointsV1(
            SessionByDeviceDataPointsV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/session_by_device_timeseries/data_points/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "session_id", request.getSessionId(), false);
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<List<SessionByDeviceDataPoint1>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, new TypeReference<List<SessionByDeviceDataPoint1>>() {}),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Marks data points as outliers or non-outliers. Uses atomic delete and reinsert strategy for time-series collection updates. | (SessionByDeviceMarkOutliersRequest1) -&gt; (SessionByDeviceMarkOutliersResponse1)
     */
    public CompletableFuture<ChrtApiHttpResponse<SessionByDeviceMarkOutliersResponse1>> outlierV1(
            SessionByDeviceMarkOutliersRequest1 request) {
        return outlierV1(request, null);
    }

    /**
     * Marks data points as outliers or non-outliers. Uses atomic delete and reinsert strategy for time-series collection updates. | (SessionByDeviceMarkOutliersRequest1) -&gt; (SessionByDeviceMarkOutliersResponse1)
     */
    public CompletableFuture<ChrtApiHttpResponse<SessionByDeviceMarkOutliersResponse1>> outlierV1(
            SessionByDeviceMarkOutliersRequest1 request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/session_by_device_timeseries/outlier/v1")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<SessionByDeviceMarkOutliersResponse1>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, SessionByDeviceMarkOutliersResponse1.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Returns the most recent data point for a public session, excluding outliers. No authentication required if session has public visibility enabled. | () -&gt; (SessionByDeviceDataPoint1 | None)
     */
    public CompletableFuture<ChrtApiHttpResponse<Optional<SessionByDeviceDataPoint1>>> lastSeenPublicV1(
            SessionByDeviceLastSeenPublicV1Request request) {
        return lastSeenPublicV1(request, null);
    }

    /**
     * Returns the most recent data point for a public session, excluding outliers. No authentication required if session has public visibility enabled. | () -&gt; (SessionByDeviceDataPoint1 | None)
     */
    public CompletableFuture<ChrtApiHttpResponse<Optional<SessionByDeviceDataPoint1>>> lastSeenPublicV1(
            SessionByDeviceLastSeenPublicV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/session_by_device_timeseries/last_seen_public/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "session_id", request.getSessionId(), false);
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Optional<SessionByDeviceDataPoint1>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString,
                                        new TypeReference<Optional<SessionByDeviceDataPoint1>>() {}),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Returns up to the specified number of data points for a public session, intelligently sampled across the time range. Excludes outliers. No authentication required if session has public visibility enabled. | () -&gt; (list[SessionByDeviceDataPoint1])
     */
    public CompletableFuture<ChrtApiHttpResponse<List<SessionByDeviceDataPoint1>>> dataPointsPublicV1(
            SessionByDeviceDataPointsPublicV1Request request) {
        return dataPointsPublicV1(request, null);
    }

    /**
     * Returns up to the specified number of data points for a public session, intelligently sampled across the time range. Excludes outliers. No authentication required if session has public visibility enabled. | () -&gt; (list[SessionByDeviceDataPoint1])
     */
    public CompletableFuture<ChrtApiHttpResponse<List<SessionByDeviceDataPoint1>>> dataPointsPublicV1(
            SessionByDeviceDataPointsPublicV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("tracking/session_by_device_timeseries/data_points_public/v1");
        QueryStringMapper.addQueryParameter(httpUrl, "session_id", request.getSessionId(), false);
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "limit", request.getLimit().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<List<SessionByDeviceDataPoint1>>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, new TypeReference<List<SessionByDeviceDataPoint1>>() {}),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
