/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.timeseries.sessionbydevice;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests.SessionByDeviceDataPointsPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests.SessionByDeviceDataPointsV1Request;
import com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests.SessionByDeviceLastSeenPublicV1Request;
import com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests.SessionByDeviceLastSeenV1Request;
import com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests.SessionByDeviceMarkOutliersRequest1;
import com.chrt.api.types.SessionByDeviceDataPoint1;
import com.chrt.api.types.SessionByDeviceMarkOutliersResponse1;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncSessionByDeviceClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawSessionByDeviceClient rawClient;

    public AsyncSessionByDeviceClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSessionByDeviceClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawSessionByDeviceClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Returns the most recent data point for a session, excluding outliers. Access restricted to the caller's organization. | authz: min_org_role=operator | () -&gt; (SessionByDeviceDataPoint1 | None)
     */
    public CompletableFuture<Optional<SessionByDeviceDataPoint1>> lastSeenV1(SessionByDeviceLastSeenV1Request request) {
        return this.rawClient.lastSeenV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent data point for a session, excluding outliers. Access restricted to the caller's organization. | authz: min_org_role=operator | () -&gt; (SessionByDeviceDataPoint1 | None)
     */
    public CompletableFuture<Optional<SessionByDeviceDataPoint1>> lastSeenV1(
            SessionByDeviceLastSeenV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a session, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[SessionByDeviceDataPoint1])
     */
    public CompletableFuture<List<SessionByDeviceDataPoint1>> dataPointsV1(SessionByDeviceDataPointsV1Request request) {
        return this.rawClient.dataPointsV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a session, intelligently sampled across the time range. Excludes outliers. | () -&gt; (list[SessionByDeviceDataPoint1])
     */
    public CompletableFuture<List<SessionByDeviceDataPoint1>> dataPointsV1(
            SessionByDeviceDataPointsV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Marks data points as outliers or non-outliers. Uses atomic delete and reinsert strategy for time-series collection updates. | (SessionByDeviceMarkOutliersRequest1) -&gt; (SessionByDeviceMarkOutliersResponse1)
     */
    public CompletableFuture<SessionByDeviceMarkOutliersResponse1> outlierV1(
            SessionByDeviceMarkOutliersRequest1 request) {
        return this.rawClient.outlierV1(request).thenApply(response -> response.body());
    }

    /**
     * Marks data points as outliers or non-outliers. Uses atomic delete and reinsert strategy for time-series collection updates. | (SessionByDeviceMarkOutliersRequest1) -&gt; (SessionByDeviceMarkOutliersResponse1)
     */
    public CompletableFuture<SessionByDeviceMarkOutliersResponse1> outlierV1(
            SessionByDeviceMarkOutliersRequest1 request, RequestOptions requestOptions) {
        return this.rawClient.outlierV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent data point for a public session, excluding outliers. No authentication required if session has public visibility enabled. | () -&gt; (SessionByDeviceDataPoint1 | None)
     */
    public CompletableFuture<Optional<SessionByDeviceDataPoint1>> lastSeenPublicV1(
            SessionByDeviceLastSeenPublicV1Request request) {
        return this.rawClient.lastSeenPublicV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns the most recent data point for a public session, excluding outliers. No authentication required if session has public visibility enabled. | () -&gt; (SessionByDeviceDataPoint1 | None)
     */
    public CompletableFuture<Optional<SessionByDeviceDataPoint1>> lastSeenPublicV1(
            SessionByDeviceLastSeenPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenPublicV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a public session, intelligently sampled across the time range. Excludes outliers. No authentication required if session has public visibility enabled. | () -&gt; (list[SessionByDeviceDataPoint1])
     */
    public CompletableFuture<List<SessionByDeviceDataPoint1>> dataPointsPublicV1(
            SessionByDeviceDataPointsPublicV1Request request) {
        return this.rawClient.dataPointsPublicV1(request).thenApply(response -> response.body());
    }

    /**
     * Returns up to the specified number of data points for a public session, intelligently sampled across the time range. Excludes outliers. No authentication required if session has public visibility enabled. | () -&gt; (list[SessionByDeviceDataPoint1])
     */
    public CompletableFuture<List<SessionByDeviceDataPoint1>> dataPointsPublicV1(
            SessionByDeviceDataPointsPublicV1Request request, RequestOptions requestOptions) {
        return this.rawClient.dataPointsPublicV1(request, requestOptions).thenApply(response -> response.body());
    }
}
