/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SessionByDeviceDataPointsPublicV1Request.Builder.class)
public final class SessionByDeviceDataPointsPublicV1Request {
    private final String sessionId;

    private final Optional<Integer> limit;

    private final Map<String, Object> additionalProperties;

    private SessionByDeviceDataPointsPublicV1Request(
            String sessionId, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.sessionId = sessionId;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("session_id")
    public String getSessionId() {
        return sessionId;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (limit == null) {
            return Optional.empty();
        }
        return limit;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("limit")
    private Optional<Integer> _getLimit() {
        return limit;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SessionByDeviceDataPointsPublicV1Request
                && equalTo((SessionByDeviceDataPointsPublicV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SessionByDeviceDataPointsPublicV1Request other) {
        return sessionId.equals(other.sessionId) && limit.equals(other.limit);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.sessionId, this.limit);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SessionIdStage builder() {
        return new Builder();
    }

    public interface SessionIdStage {
        _FinalStage sessionId(@NotNull String sessionId);

        Builder from(SessionByDeviceDataPointsPublicV1Request other);
    }

    public interface _FinalStage {
        SessionByDeviceDataPointsPublicV1Request build();

        _FinalStage limit(Optional<Integer> limit);

        _FinalStage limit(Integer limit);

        _FinalStage limit(Nullable<Integer> limit);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SessionIdStage, _FinalStage {
        private String sessionId;

        private Optional<Integer> limit = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SessionByDeviceDataPointsPublicV1Request other) {
            sessionId(other.getSessionId());
            limit(other.getLimit());
            return this;
        }

        @java.lang.Override
        @JsonSetter("session_id")
        public _FinalStage sessionId(@NotNull String sessionId) {
            this.sessionId = Objects.requireNonNull(sessionId, "sessionId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage limit(Nullable<Integer> limit) {
            if (limit.isNull()) {
                this.limit = null;
            } else if (limit.isEmpty()) {
                this.limit = Optional.empty();
            } else {
                this.limit = Optional.of(limit.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @java.lang.Override
        public SessionByDeviceDataPointsPublicV1Request build() {
            return new SessionByDeviceDataPointsPublicV1Request(sessionId, limit, additionalProperties);
        }
    }
}
