/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tracking.timeseries.taskgroupbydriver.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TaskGroupByDriverDataPointsPublicV1Request.Builder.class)
public final class TaskGroupByDriverDataPointsPublicV1Request {
    private final String taskGroupId;

    private final Optional<Integer> limit;

    private final Map<String, Object> additionalProperties;

    private TaskGroupByDriverDataPointsPublicV1Request(
            String taskGroupId, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.taskGroupId = taskGroupId;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (limit == null) {
            return Optional.empty();
        }
        return limit;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("limit")
    private Optional<Integer> _getLimit() {
        return limit;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TaskGroupByDriverDataPointsPublicV1Request
                && equalTo((TaskGroupByDriverDataPointsPublicV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskGroupByDriverDataPointsPublicV1Request other) {
        return taskGroupId.equals(other.taskGroupId) && limit.equals(other.limit);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.taskGroupId, this.limit);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskGroupIdStage builder() {
        return new Builder();
    }

    public interface TaskGroupIdStage {
        _FinalStage taskGroupId(@NotNull String taskGroupId);

        Builder from(TaskGroupByDriverDataPointsPublicV1Request other);
    }

    public interface _FinalStage {
        TaskGroupByDriverDataPointsPublicV1Request build();

        _FinalStage limit(Optional<Integer> limit);

        _FinalStage limit(Integer limit);

        _FinalStage limit(Nullable<Integer> limit);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TaskGroupIdStage, _FinalStage {
        private String taskGroupId;

        private Optional<Integer> limit = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TaskGroupByDriverDataPointsPublicV1Request other) {
            taskGroupId(other.getTaskGroupId());
            limit(other.getLimit());
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public _FinalStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage limit(Nullable<Integer> limit) {
            if (limit.isNull()) {
                this.limit = null;
            } else if (limit.isEmpty()) {
                this.limit = Optional.empty();
            } else {
                this.limit = Optional.of(limit.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @java.lang.Override
        public TaskGroupByDriverDataPointsPublicV1Request build() {
            return new TaskGroupByDriverDataPointsPublicV1Request(taskGroupId, limit, additionalProperties);
        }
    }
}
