/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.users;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.UserPublicData1;
import java.util.concurrent.CompletableFuture;

public class AsyncUsersClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawUsersClient rawClient;

    public AsyncUsersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawUsersClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawUsersClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves public user data for the caller. | () -&gt; (UserPublicData1)
     */
    public CompletableFuture<UserPublicData1> getUserPublicDataV1() {
        return this.rawClient.getUserPublicDataV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves public user data for the caller. | () -&gt; (UserPublicData1)
     */
    public CompletableFuture<UserPublicData1> getUserPublicDataV1(RequestOptions requestOptions) {
        return this.rawClient.getUserPublicDataV1(requestOptions).thenApply(response -> response.body());
    }
}
