/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Cargo1.Builder.class)
public final class Cargo1 {
    private final int schemaVersion;

    private final CargoTypeEnum1 cargoType;

    private final Optional<Integer> quantity;

    private final Optional<Double> weightPounds;

    private final Optional<Double> lengthInches;

    private final Optional<Double> widthInches;

    private final Optional<Double> heightInches;

    private final Optional<Boolean> turnable;

    private final Optional<Boolean> stackable;

    private final Optional<String> description;

    private final String id;

    private final String orderId;

    private final String orderShortId;

    private final String createdByOrgId;

    private final String createdByUserId;

    private final Optional<List<String>> deviceIds;

    private final Optional<CargoStatusEnum1> status;

    private final OffsetDateTime draftStartedAtTimestamp;

    private final Optional<OffsetDateTime> stagedAtTimestamp;

    private final Optional<OffsetDateTime> inTransitAtTimestamp;

    private final Optional<OffsetDateTime> deliveredAtTimestamp;

    private final Optional<OffsetDateTime> skippedAtTimestamp;

    private final Optional<OffsetDateTime> exceptionAtTimestamp;

    private final Map<String, Object> additionalProperties;

    private Cargo1(
            int schemaVersion,
            CargoTypeEnum1 cargoType,
            Optional<Integer> quantity,
            Optional<Double> weightPounds,
            Optional<Double> lengthInches,
            Optional<Double> widthInches,
            Optional<Double> heightInches,
            Optional<Boolean> turnable,
            Optional<Boolean> stackable,
            Optional<String> description,
            String id,
            String orderId,
            String orderShortId,
            String createdByOrgId,
            String createdByUserId,
            Optional<List<String>> deviceIds,
            Optional<CargoStatusEnum1> status,
            OffsetDateTime draftStartedAtTimestamp,
            Optional<OffsetDateTime> stagedAtTimestamp,
            Optional<OffsetDateTime> inTransitAtTimestamp,
            Optional<OffsetDateTime> deliveredAtTimestamp,
            Optional<OffsetDateTime> skippedAtTimestamp,
            Optional<OffsetDateTime> exceptionAtTimestamp,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.cargoType = cargoType;
        this.quantity = quantity;
        this.weightPounds = weightPounds;
        this.lengthInches = lengthInches;
        this.widthInches = widthInches;
        this.heightInches = heightInches;
        this.turnable = turnable;
        this.stackable = stackable;
        this.description = description;
        this.id = id;
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.deviceIds = deviceIds;
        this.status = status;
        this.draftStartedAtTimestamp = draftStartedAtTimestamp;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.inTransitAtTimestamp = inTransitAtTimestamp;
        this.deliveredAtTimestamp = deliveredAtTimestamp;
        this.skippedAtTimestamp = skippedAtTimestamp;
        this.exceptionAtTimestamp = exceptionAtTimestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("cargo_type")
    public CargoTypeEnum1 getCargoType() {
        return cargoType;
    }

    @JsonIgnore
    public Optional<Integer> getQuantity() {
        if (quantity == null) {
            return Optional.empty();
        }
        return quantity;
    }

    @JsonIgnore
    public Optional<Double> getWeightPounds() {
        if (weightPounds == null) {
            return Optional.empty();
        }
        return weightPounds;
    }

    @JsonIgnore
    public Optional<Double> getLengthInches() {
        if (lengthInches == null) {
            return Optional.empty();
        }
        return lengthInches;
    }

    @JsonIgnore
    public Optional<Double> getWidthInches() {
        if (widthInches == null) {
            return Optional.empty();
        }
        return widthInches;
    }

    @JsonIgnore
    public Optional<Double> getHeightInches() {
        if (heightInches == null) {
            return Optional.empty();
        }
        return heightInches;
    }

    @JsonIgnore
    public Optional<Boolean> getTurnable() {
        if (turnable == null) {
            return Optional.empty();
        }
        return turnable;
    }

    @JsonIgnore
    public Optional<Boolean> getStackable() {
        if (stackable == null) {
            return Optional.empty();
        }
        return stackable;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (description == null) {
            return Optional.empty();
        }
        return description;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonProperty("order_id")
    public String getOrderId() {
        return orderId;
    }

    @JsonProperty("order_short_id")
    public String getOrderShortId() {
        return orderShortId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("created_by_org_id")
    public String getCreatedByOrgId() {
        return createdByOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("created_by_user_id")
    public String getCreatedByUserId() {
        return createdByUserId;
    }

    @JsonProperty("device_ids")
    public Optional<List<String>> getDeviceIds() {
        return deviceIds;
    }

    @JsonProperty("status")
    public Optional<CargoStatusEnum1> getStatus() {
        return status;
    }

    @JsonProperty("draft_started_at_timestamp")
    public OffsetDateTime getDraftStartedAtTimestamp() {
        return draftStartedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getInTransitAtTimestamp() {
        if (inTransitAtTimestamp == null) {
            return Optional.empty();
        }
        return inTransitAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getDeliveredAtTimestamp() {
        if (deliveredAtTimestamp == null) {
            return Optional.empty();
        }
        return deliveredAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getSkippedAtTimestamp() {
        if (skippedAtTimestamp == null) {
            return Optional.empty();
        }
        return skippedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExceptionAtTimestamp() {
        if (exceptionAtTimestamp == null) {
            return Optional.empty();
        }
        return exceptionAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("quantity")
    private Optional<Integer> _getQuantity() {
        return quantity;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("weight_pounds")
    private Optional<Double> _getWeightPounds() {
        return weightPounds;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("length_inches")
    private Optional<Double> _getLengthInches() {
        return lengthInches;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("width_inches")
    private Optional<Double> _getWidthInches() {
        return widthInches;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("height_inches")
    private Optional<Double> _getHeightInches() {
        return heightInches;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("turnable")
    private Optional<Boolean> _getTurnable() {
        return turnable;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("stackable")
    private Optional<Boolean> _getStackable() {
        return stackable;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("description")
    private Optional<String> _getDescription() {
        return description;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return stagedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("in_transit_at_timestamp")
    private Optional<OffsetDateTime> _getInTransitAtTimestamp() {
        return inTransitAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("delivered_at_timestamp")
    private Optional<OffsetDateTime> _getDeliveredAtTimestamp() {
        return deliveredAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("skipped_at_timestamp")
    private Optional<OffsetDateTime> _getSkippedAtTimestamp() {
        return skippedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("exception_at_timestamp")
    private Optional<OffsetDateTime> _getExceptionAtTimestamp() {
        return exceptionAtTimestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Cargo1 && equalTo((Cargo1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Cargo1 other) {
        return schemaVersion == other.schemaVersion
                && cargoType.equals(other.cargoType)
                && quantity.equals(other.quantity)
                && weightPounds.equals(other.weightPounds)
                && lengthInches.equals(other.lengthInches)
                && widthInches.equals(other.widthInches)
                && heightInches.equals(other.heightInches)
                && turnable.equals(other.turnable)
                && stackable.equals(other.stackable)
                && description.equals(other.description)
                && id.equals(other.id)
                && orderId.equals(other.orderId)
                && orderShortId.equals(other.orderShortId)
                && createdByOrgId.equals(other.createdByOrgId)
                && createdByUserId.equals(other.createdByUserId)
                && deviceIds.equals(other.deviceIds)
                && status.equals(other.status)
                && draftStartedAtTimestamp.equals(other.draftStartedAtTimestamp)
                && stagedAtTimestamp.equals(other.stagedAtTimestamp)
                && inTransitAtTimestamp.equals(other.inTransitAtTimestamp)
                && deliveredAtTimestamp.equals(other.deliveredAtTimestamp)
                && skippedAtTimestamp.equals(other.skippedAtTimestamp)
                && exceptionAtTimestamp.equals(other.exceptionAtTimestamp);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.cargoType,
                this.quantity,
                this.weightPounds,
                this.lengthInches,
                this.widthInches,
                this.heightInches,
                this.turnable,
                this.stackable,
                this.description,
                this.id,
                this.orderId,
                this.orderShortId,
                this.createdByOrgId,
                this.createdByUserId,
                this.deviceIds,
                this.status,
                this.draftStartedAtTimestamp,
                this.stagedAtTimestamp,
                this.inTransitAtTimestamp,
                this.deliveredAtTimestamp,
                this.skippedAtTimestamp,
                this.exceptionAtTimestamp);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        CargoTypeStage schemaVersion(int schemaVersion);

        Builder from(Cargo1 other);
    }

    public interface CargoTypeStage {
        IdStage cargoType(@NotNull CargoTypeEnum1 cargoType);
    }

    public interface IdStage {
        OrderIdStage id(@NotNull String id);
    }

    public interface OrderIdStage {
        OrderShortIdStage orderId(@NotNull String orderId);
    }

    public interface OrderShortIdStage {
        CreatedByOrgIdStage orderShortId(@NotNull String orderShortId);
    }

    public interface CreatedByOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId);
    }

    public interface CreatedByUserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId);
    }

    public interface DraftStartedAtTimestampStage {
        _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp);
    }

    public interface _FinalStage {
        Cargo1 build();

        _FinalStage quantity(Optional<Integer> quantity);

        _FinalStage quantity(Integer quantity);

        _FinalStage quantity(Nullable<Integer> quantity);

        _FinalStage weightPounds(Optional<Double> weightPounds);

        _FinalStage weightPounds(Double weightPounds);

        _FinalStage weightPounds(Nullable<Double> weightPounds);

        _FinalStage lengthInches(Optional<Double> lengthInches);

        _FinalStage lengthInches(Double lengthInches);

        _FinalStage lengthInches(Nullable<Double> lengthInches);

        _FinalStage widthInches(Optional<Double> widthInches);

        _FinalStage widthInches(Double widthInches);

        _FinalStage widthInches(Nullable<Double> widthInches);

        _FinalStage heightInches(Optional<Double> heightInches);

        _FinalStage heightInches(Double heightInches);

        _FinalStage heightInches(Nullable<Double> heightInches);

        _FinalStage turnable(Optional<Boolean> turnable);

        _FinalStage turnable(Boolean turnable);

        _FinalStage turnable(Nullable<Boolean> turnable);

        _FinalStage stackable(Optional<Boolean> stackable);

        _FinalStage stackable(Boolean stackable);

        _FinalStage stackable(Nullable<Boolean> stackable);

        _FinalStage description(Optional<String> description);

        _FinalStage description(String description);

        _FinalStage description(Nullable<String> description);

        _FinalStage deviceIds(Optional<List<String>> deviceIds);

        _FinalStage deviceIds(List<String> deviceIds);

        _FinalStage status(Optional<CargoStatusEnum1> status);

        _FinalStage status(CargoStatusEnum1 status);

        _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp);

        _FinalStage inTransitAtTimestamp(Optional<OffsetDateTime> inTransitAtTimestamp);

        _FinalStage inTransitAtTimestamp(OffsetDateTime inTransitAtTimestamp);

        _FinalStage inTransitAtTimestamp(Nullable<OffsetDateTime> inTransitAtTimestamp);

        _FinalStage deliveredAtTimestamp(Optional<OffsetDateTime> deliveredAtTimestamp);

        _FinalStage deliveredAtTimestamp(OffsetDateTime deliveredAtTimestamp);

        _FinalStage deliveredAtTimestamp(Nullable<OffsetDateTime> deliveredAtTimestamp);

        _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> skippedAtTimestamp);

        _FinalStage skippedAtTimestamp(OffsetDateTime skippedAtTimestamp);

        _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> skippedAtTimestamp);

        _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    CargoTypeStage,
                    IdStage,
                    OrderIdStage,
                    OrderShortIdStage,
                    CreatedByOrgIdStage,
                    CreatedByUserIdStage,
                    DraftStartedAtTimestampStage,
                    _FinalStage {
        private int schemaVersion;

        private CargoTypeEnum1 cargoType;

        private String id;

        private String orderId;

        private String orderShortId;

        private String createdByOrgId;

        private String createdByUserId;

        private OffsetDateTime draftStartedAtTimestamp;

        private Optional<OffsetDateTime> exceptionAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> skippedAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> deliveredAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> inTransitAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();

        private Optional<CargoStatusEnum1> status = Optional.empty();

        private Optional<List<String>> deviceIds = Optional.empty();

        private Optional<String> description = Optional.empty();

        private Optional<Boolean> stackable = Optional.empty();

        private Optional<Boolean> turnable = Optional.empty();

        private Optional<Double> heightInches = Optional.empty();

        private Optional<Double> widthInches = Optional.empty();

        private Optional<Double> lengthInches = Optional.empty();

        private Optional<Double> weightPounds = Optional.empty();

        private Optional<Integer> quantity = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Cargo1 other) {
            schemaVersion(other.getSchemaVersion());
            cargoType(other.getCargoType());
            quantity(other.getQuantity());
            weightPounds(other.getWeightPounds());
            lengthInches(other.getLengthInches());
            widthInches(other.getWidthInches());
            heightInches(other.getHeightInches());
            turnable(other.getTurnable());
            stackable(other.getStackable());
            description(other.getDescription());
            id(other.getId());
            orderId(other.getOrderId());
            orderShortId(other.getOrderShortId());
            createdByOrgId(other.getCreatedByOrgId());
            createdByUserId(other.getCreatedByUserId());
            deviceIds(other.getDeviceIds());
            status(other.getStatus());
            draftStartedAtTimestamp(other.getDraftStartedAtTimestamp());
            stagedAtTimestamp(other.getStagedAtTimestamp());
            inTransitAtTimestamp(other.getInTransitAtTimestamp());
            deliveredAtTimestamp(other.getDeliveredAtTimestamp());
            skippedAtTimestamp(other.getSkippedAtTimestamp());
            exceptionAtTimestamp(other.getExceptionAtTimestamp());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public CargoTypeStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("cargo_type")
        public IdStage cargoType(@NotNull CargoTypeEnum1 cargoType) {
            this.cargoType = Objects.requireNonNull(cargoType, "cargoType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public OrderIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_short_id")
        public CreatedByOrgIdStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_user_id")
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("draft_started_at_timestamp")
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp) {
            this.draftStartedAtTimestamp =
                    Objects.requireNonNull(draftStartedAtTimestamp, "draftStartedAtTimestamp must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp) {
            if (exceptionAtTimestamp.isNull()) {
                this.exceptionAtTimestamp = null;
            } else if (exceptionAtTimestamp.isEmpty()) {
                this.exceptionAtTimestamp = Optional.empty();
            } else {
                this.exceptionAtTimestamp = Optional.of(exceptionAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp) {
            this.exceptionAtTimestamp = Optional.ofNullable(exceptionAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "exception_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage skippedAtTimestamp(Nullable<OffsetDateTime> skippedAtTimestamp) {
            if (skippedAtTimestamp.isNull()) {
                this.skippedAtTimestamp = null;
            } else if (skippedAtTimestamp.isEmpty()) {
                this.skippedAtTimestamp = Optional.empty();
            } else {
                this.skippedAtTimestamp = Optional.of(skippedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage skippedAtTimestamp(OffsetDateTime skippedAtTimestamp) {
            this.skippedAtTimestamp = Optional.ofNullable(skippedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "skipped_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage skippedAtTimestamp(Optional<OffsetDateTime> skippedAtTimestamp) {
            this.skippedAtTimestamp = skippedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage deliveredAtTimestamp(Nullable<OffsetDateTime> deliveredAtTimestamp) {
            if (deliveredAtTimestamp.isNull()) {
                this.deliveredAtTimestamp = null;
            } else if (deliveredAtTimestamp.isEmpty()) {
                this.deliveredAtTimestamp = Optional.empty();
            } else {
                this.deliveredAtTimestamp = Optional.of(deliveredAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage deliveredAtTimestamp(OffsetDateTime deliveredAtTimestamp) {
            this.deliveredAtTimestamp = Optional.ofNullable(deliveredAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "delivered_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage deliveredAtTimestamp(Optional<OffsetDateTime> deliveredAtTimestamp) {
            this.deliveredAtTimestamp = deliveredAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage inTransitAtTimestamp(Nullable<OffsetDateTime> inTransitAtTimestamp) {
            if (inTransitAtTimestamp.isNull()) {
                this.inTransitAtTimestamp = null;
            } else if (inTransitAtTimestamp.isEmpty()) {
                this.inTransitAtTimestamp = Optional.empty();
            } else {
                this.inTransitAtTimestamp = Optional.of(inTransitAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage inTransitAtTimestamp(OffsetDateTime inTransitAtTimestamp) {
            this.inTransitAtTimestamp = Optional.ofNullable(inTransitAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "in_transit_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage inTransitAtTimestamp(Optional<OffsetDateTime> inTransitAtTimestamp) {
            this.inTransitAtTimestamp = inTransitAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            if (stagedAtTimestamp.isNull()) {
                this.stagedAtTimestamp = null;
            } else if (stagedAtTimestamp.isEmpty()) {
                this.stagedAtTimestamp = Optional.empty();
            } else {
                this.stagedAtTimestamp = Optional.of(stagedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "staged_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(CargoStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<CargoStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public _FinalStage deviceIds(List<String> deviceIds) {
            this.deviceIds = Optional.ofNullable(deviceIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "device_ids", nulls = Nulls.SKIP)
        public _FinalStage deviceIds(Optional<List<String>> deviceIds) {
            this.deviceIds = deviceIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage description(Nullable<String> description) {
            if (description.isNull()) {
                this.description = null;
            } else if (description.isEmpty()) {
                this.description = Optional.empty();
            } else {
                this.description = Optional.of(description.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @java.lang.Override
        public _FinalStage stackable(Nullable<Boolean> stackable) {
            if (stackable.isNull()) {
                this.stackable = null;
            } else if (stackable.isEmpty()) {
                this.stackable = Optional.empty();
            } else {
                this.stackable = Optional.of(stackable.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stackable(Boolean stackable) {
            this.stackable = Optional.ofNullable(stackable);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "stackable", nulls = Nulls.SKIP)
        public _FinalStage stackable(Optional<Boolean> stackable) {
            this.stackable = stackable;
            return this;
        }

        @java.lang.Override
        public _FinalStage turnable(Nullable<Boolean> turnable) {
            if (turnable.isNull()) {
                this.turnable = null;
            } else if (turnable.isEmpty()) {
                this.turnable = Optional.empty();
            } else {
                this.turnable = Optional.of(turnable.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage turnable(Boolean turnable) {
            this.turnable = Optional.ofNullable(turnable);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "turnable", nulls = Nulls.SKIP)
        public _FinalStage turnable(Optional<Boolean> turnable) {
            this.turnable = turnable;
            return this;
        }

        @java.lang.Override
        public _FinalStage heightInches(Nullable<Double> heightInches) {
            if (heightInches.isNull()) {
                this.heightInches = null;
            } else if (heightInches.isEmpty()) {
                this.heightInches = Optional.empty();
            } else {
                this.heightInches = Optional.of(heightInches.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage heightInches(Double heightInches) {
            this.heightInches = Optional.ofNullable(heightInches);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "height_inches", nulls = Nulls.SKIP)
        public _FinalStage heightInches(Optional<Double> heightInches) {
            this.heightInches = heightInches;
            return this;
        }

        @java.lang.Override
        public _FinalStage widthInches(Nullable<Double> widthInches) {
            if (widthInches.isNull()) {
                this.widthInches = null;
            } else if (widthInches.isEmpty()) {
                this.widthInches = Optional.empty();
            } else {
                this.widthInches = Optional.of(widthInches.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage widthInches(Double widthInches) {
            this.widthInches = Optional.ofNullable(widthInches);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "width_inches", nulls = Nulls.SKIP)
        public _FinalStage widthInches(Optional<Double> widthInches) {
            this.widthInches = widthInches;
            return this;
        }

        @java.lang.Override
        public _FinalStage lengthInches(Nullable<Double> lengthInches) {
            if (lengthInches.isNull()) {
                this.lengthInches = null;
            } else if (lengthInches.isEmpty()) {
                this.lengthInches = Optional.empty();
            } else {
                this.lengthInches = Optional.of(lengthInches.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage lengthInches(Double lengthInches) {
            this.lengthInches = Optional.ofNullable(lengthInches);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "length_inches", nulls = Nulls.SKIP)
        public _FinalStage lengthInches(Optional<Double> lengthInches) {
            this.lengthInches = lengthInches;
            return this;
        }

        @java.lang.Override
        public _FinalStage weightPounds(Nullable<Double> weightPounds) {
            if (weightPounds.isNull()) {
                this.weightPounds = null;
            } else if (weightPounds.isEmpty()) {
                this.weightPounds = Optional.empty();
            } else {
                this.weightPounds = Optional.of(weightPounds.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage weightPounds(Double weightPounds) {
            this.weightPounds = Optional.ofNullable(weightPounds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "weight_pounds", nulls = Nulls.SKIP)
        public _FinalStage weightPounds(Optional<Double> weightPounds) {
            this.weightPounds = weightPounds;
            return this;
        }

        @java.lang.Override
        public _FinalStage quantity(Nullable<Integer> quantity) {
            if (quantity.isNull()) {
                this.quantity = null;
            } else if (quantity.isEmpty()) {
                this.quantity = Optional.empty();
            } else {
                this.quantity = Optional.of(quantity.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage quantity(Integer quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "quantity", nulls = Nulls.SKIP)
        public _FinalStage quantity(Optional<Integer> quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        public Cargo1 build() {
            return new Cargo1(
                    schemaVersion,
                    cargoType,
                    quantity,
                    weightPounds,
                    lengthInches,
                    widthInches,
                    heightInches,
                    turnable,
                    stackable,
                    description,
                    id,
                    orderId,
                    orderShortId,
                    createdByOrgId,
                    createdByUserId,
                    deviceIds,
                    status,
                    draftStartedAtTimestamp,
                    stagedAtTimestamp,
                    inTransitAtTimestamp,
                    deliveredAtTimestamp,
                    skippedAtTimestamp,
                    exceptionAtTimestamp,
                    additionalProperties);
        }
    }
}
