/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CargoByDriverDataPointMetadata1.Builder.class)
public final class CargoByDriverDataPointMetadata1 {
    private final String taskGroupId;

    private final String cargoId;

    private final String driverId;

    private final Optional<Boolean> outlier;

    private final Optional<OutlierLabellerEnum> outlierLabeller;

    private final Optional<Boolean> pytest;

    private final Map<String, Object> additionalProperties;

    private CargoByDriverDataPointMetadata1(
            String taskGroupId,
            String cargoId,
            String driverId,
            Optional<Boolean> outlier,
            Optional<OutlierLabellerEnum> outlierLabeller,
            Optional<Boolean> pytest,
            Map<String, Object> additionalProperties) {
        this.taskGroupId = taskGroupId;
        this.cargoId = cargoId;
        this.driverId = driverId;
        this.outlier = outlier;
        this.outlierLabeller = outlierLabeller;
        this.pytest = pytest;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    @JsonProperty("cargo_id")
    public String getCargoId() {
        return cargoId;
    }

    @JsonProperty("driver_id")
    public String getDriverId() {
        return driverId;
    }

    @JsonIgnore
    public Optional<Boolean> getOutlier() {
        if (outlier == null) {
            return Optional.empty();
        }
        return outlier;
    }

    @JsonIgnore
    public Optional<OutlierLabellerEnum> getOutlierLabeller() {
        if (outlierLabeller == null) {
            return Optional.empty();
        }
        return outlierLabeller;
    }

    @JsonIgnore
    public Optional<Boolean> getPytest() {
        if (pytest == null) {
            return Optional.empty();
        }
        return pytest;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("outlier")
    private Optional<Boolean> _getOutlier() {
        return outlier;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("outlier_labeller")
    private Optional<OutlierLabellerEnum> _getOutlierLabeller() {
        return outlierLabeller;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("pytest")
    private Optional<Boolean> _getPytest() {
        return pytest;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CargoByDriverDataPointMetadata1 && equalTo((CargoByDriverDataPointMetadata1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CargoByDriverDataPointMetadata1 other) {
        return taskGroupId.equals(other.taskGroupId)
                && cargoId.equals(other.cargoId)
                && driverId.equals(other.driverId)
                && outlier.equals(other.outlier)
                && outlierLabeller.equals(other.outlierLabeller)
                && pytest.equals(other.pytest);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.taskGroupId, this.cargoId, this.driverId, this.outlier, this.outlierLabeller, this.pytest);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskGroupIdStage builder() {
        return new Builder();
    }

    public interface TaskGroupIdStage {
        CargoIdStage taskGroupId(@NotNull String taskGroupId);

        Builder from(CargoByDriverDataPointMetadata1 other);
    }

    public interface CargoIdStage {
        DriverIdStage cargoId(@NotNull String cargoId);
    }

    public interface DriverIdStage {
        _FinalStage driverId(@NotNull String driverId);
    }

    public interface _FinalStage {
        CargoByDriverDataPointMetadata1 build();

        _FinalStage outlier(Optional<Boolean> outlier);

        _FinalStage outlier(Boolean outlier);

        _FinalStage outlier(Nullable<Boolean> outlier);

        _FinalStage outlierLabeller(Optional<OutlierLabellerEnum> outlierLabeller);

        _FinalStage outlierLabeller(OutlierLabellerEnum outlierLabeller);

        _FinalStage outlierLabeller(Nullable<OutlierLabellerEnum> outlierLabeller);

        _FinalStage pytest(Optional<Boolean> pytest);

        _FinalStage pytest(Boolean pytest);

        _FinalStage pytest(Nullable<Boolean> pytest);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TaskGroupIdStage, CargoIdStage, DriverIdStage, _FinalStage {
        private String taskGroupId;

        private String cargoId;

        private String driverId;

        private Optional<Boolean> pytest = Optional.empty();

        private Optional<OutlierLabellerEnum> outlierLabeller = Optional.empty();

        private Optional<Boolean> outlier = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CargoByDriverDataPointMetadata1 other) {
            taskGroupId(other.getTaskGroupId());
            cargoId(other.getCargoId());
            driverId(other.getDriverId());
            outlier(other.getOutlier());
            outlierLabeller(other.getOutlierLabeller());
            pytest(other.getPytest());
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public CargoIdStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("cargo_id")
        public DriverIdStage cargoId(@NotNull String cargoId) {
            this.cargoId = Objects.requireNonNull(cargoId, "cargoId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("driver_id")
        public _FinalStage driverId(@NotNull String driverId) {
            this.driverId = Objects.requireNonNull(driverId, "driverId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage pytest(Nullable<Boolean> pytest) {
            if (pytest.isNull()) {
                this.pytest = null;
            } else if (pytest.isEmpty()) {
                this.pytest = Optional.empty();
            } else {
                this.pytest = Optional.of(pytest.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage pytest(Boolean pytest) {
            this.pytest = Optional.ofNullable(pytest);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "pytest", nulls = Nulls.SKIP)
        public _FinalStage pytest(Optional<Boolean> pytest) {
            this.pytest = pytest;
            return this;
        }

        @java.lang.Override
        public _FinalStage outlierLabeller(Nullable<OutlierLabellerEnum> outlierLabeller) {
            if (outlierLabeller.isNull()) {
                this.outlierLabeller = null;
            } else if (outlierLabeller.isEmpty()) {
                this.outlierLabeller = Optional.empty();
            } else {
                this.outlierLabeller = Optional.of(outlierLabeller.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage outlierLabeller(OutlierLabellerEnum outlierLabeller) {
            this.outlierLabeller = Optional.ofNullable(outlierLabeller);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "outlier_labeller", nulls = Nulls.SKIP)
        public _FinalStage outlierLabeller(Optional<OutlierLabellerEnum> outlierLabeller) {
            this.outlierLabeller = outlierLabeller;
            return this;
        }

        @java.lang.Override
        public _FinalStage outlier(Nullable<Boolean> outlier) {
            if (outlier.isNull()) {
                this.outlier = null;
            } else if (outlier.isEmpty()) {
                this.outlier = Optional.empty();
            } else {
                this.outlier = Optional.of(outlier.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage outlier(Boolean outlier) {
            this.outlier = Optional.ofNullable(outlier);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "outlier", nulls = Nulls.SKIP)
        public _FinalStage outlier(Optional<Boolean> outlier) {
            this.outlier = outlier;
            return this;
        }

        @java.lang.Override
        public CargoByDriverDataPointMetadata1 build() {
            return new CargoByDriverDataPointMetadata1(
                    taskGroupId, cargoId, driverId, outlier, outlierLabeller, pytest, additionalProperties);
        }
    }
}
