/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ClerkOrgData.Builder.class)
public final class ClerkOrgData {
    private final Optional<String> id;

    private final Optional<OrgRoleEnum> rol;

    private final Optional<String> slg;

    private final Map<String, Object> additionalProperties;

    private ClerkOrgData(
            Optional<String> id,
            Optional<OrgRoleEnum> rol,
            Optional<String> slg,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.rol = rol;
        this.slg = slg;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getId() {
        if (id == null) {
            return Optional.empty();
        }
        return id;
    }

    @JsonIgnore
    public Optional<OrgRoleEnum> getRol() {
        if (rol == null) {
            return Optional.empty();
        }
        return rol;
    }

    @JsonIgnore
    public Optional<String> getSlg() {
        if (slg == null) {
            return Optional.empty();
        }
        return slg;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("id")
    private Optional<String> _getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("rol")
    private Optional<OrgRoleEnum> _getRol() {
        return rol;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("slg")
    private Optional<String> _getSlg() {
        return slg;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ClerkOrgData && equalTo((ClerkOrgData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ClerkOrgData other) {
        return id.equals(other.id) && rol.equals(other.rol) && slg.equals(other.slg);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.rol, this.slg);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();

        private Optional<OrgRoleEnum> rol = Optional.empty();

        private Optional<String> slg = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ClerkOrgData other) {
            id(other.getId());
            rol(other.getRol());
            slg(other.getSlg());
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Nullable<String> id) {
            if (id.isNull()) {
                this.id = null;
            } else if (id.isEmpty()) {
                this.id = Optional.empty();
            } else {
                this.id = Optional.of(id.get());
            }
            return this;
        }

        @JsonSetter(value = "rol", nulls = Nulls.SKIP)
        public Builder rol(Optional<OrgRoleEnum> rol) {
            this.rol = rol;
            return this;
        }

        public Builder rol(OrgRoleEnum rol) {
            this.rol = Optional.ofNullable(rol);
            return this;
        }

        public Builder rol(Nullable<OrgRoleEnum> rol) {
            if (rol.isNull()) {
                this.rol = null;
            } else if (rol.isEmpty()) {
                this.rol = Optional.empty();
            } else {
                this.rol = Optional.of(rol.get());
            }
            return this;
        }

        @JsonSetter(value = "slg", nulls = Nulls.SKIP)
        public Builder slg(Optional<String> slg) {
            this.slg = slg;
            return this;
        }

        public Builder slg(String slg) {
            this.slg = Optional.ofNullable(slg);
            return this;
        }

        public Builder slg(Nullable<String> slg) {
            if (slg.isNull()) {
                this.slg = null;
            } else if (slg.isEmpty()) {
                this.slg = Optional.empty();
            } else {
                this.slg = Optional.of(slg.get());
            }
            return this;
        }

        public ClerkOrgData build() {
            return new ClerkOrgData(id, rol, slg, additionalProperties);
        }
    }
}
