/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CourierPayDriverStatement1.Builder.class)
public final class CourierPayDriverStatement1 {
    private final int schemaVersion;

    private final List<String> courierPayDriverLineItemGroupIds;

    private final String id;

    private final String driverId;

    private final String courierOrgId;

    private final List<String> taskGroupIds;

    private final double statementAmount;

    private final Optional<StatementStatusEnum> statementStatus;

    private final Optional<OffsetDateTime> statementCompletedAtTimestamp;

    private final Optional<String> statementCompletedByUserId;

    private final OffsetDateTime statementCreatedAtTimestamp;

    private final String statementCreatedByUserId;

    private final Map<String, Object> additionalProperties;

    private CourierPayDriverStatement1(
            int schemaVersion,
            List<String> courierPayDriverLineItemGroupIds,
            String id,
            String driverId,
            String courierOrgId,
            List<String> taskGroupIds,
            double statementAmount,
            Optional<StatementStatusEnum> statementStatus,
            Optional<OffsetDateTime> statementCompletedAtTimestamp,
            Optional<String> statementCompletedByUserId,
            OffsetDateTime statementCreatedAtTimestamp,
            String statementCreatedByUserId,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.courierPayDriverLineItemGroupIds = courierPayDriverLineItemGroupIds;
        this.id = id;
        this.driverId = driverId;
        this.courierOrgId = courierOrgId;
        this.taskGroupIds = taskGroupIds;
        this.statementAmount = statementAmount;
        this.statementStatus = statementStatus;
        this.statementCompletedAtTimestamp = statementCompletedAtTimestamp;
        this.statementCompletedByUserId = statementCompletedByUserId;
        this.statementCreatedAtTimestamp = statementCreatedAtTimestamp;
        this.statementCreatedByUserId = statementCreatedByUserId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("courier_pay_driver_line_item_group_ids")
    public List<String> getCourierPayDriverLineItemGroupIds() {
        return courierPayDriverLineItemGroupIds;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonProperty("driver_id")
    public String getDriverId() {
        return driverId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("courier_org_id")
    public String getCourierOrgId() {
        return courierOrgId;
    }

    @JsonProperty("task_group_ids")
    public List<String> getTaskGroupIds() {
        return taskGroupIds;
    }

    @JsonProperty("statement_amount")
    public double getStatementAmount() {
        return statementAmount;
    }

    @JsonProperty("statement_status")
    public Optional<StatementStatusEnum> getStatementStatus() {
        return statementStatus;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStatementCompletedAtTimestamp() {
        if (statementCompletedAtTimestamp == null) {
            return Optional.empty();
        }
        return statementCompletedAtTimestamp;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getStatementCompletedByUserId() {
        if (statementCompletedByUserId == null) {
            return Optional.empty();
        }
        return statementCompletedByUserId;
    }

    @JsonProperty("statement_created_at_timestamp")
    public OffsetDateTime getStatementCreatedAtTimestamp() {
        return statementCreatedAtTimestamp;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("statement_created_by_user_id")
    public String getStatementCreatedByUserId() {
        return statementCreatedByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("statement_completed_at_timestamp")
    private Optional<OffsetDateTime> _getStatementCompletedAtTimestamp() {
        return statementCompletedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("statement_completed_by_user_id")
    private Optional<String> _getStatementCompletedByUserId() {
        return statementCompletedByUserId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CourierPayDriverStatement1 && equalTo((CourierPayDriverStatement1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CourierPayDriverStatement1 other) {
        return schemaVersion == other.schemaVersion
                && courierPayDriverLineItemGroupIds.equals(other.courierPayDriverLineItemGroupIds)
                && id.equals(other.id)
                && driverId.equals(other.driverId)
                && courierOrgId.equals(other.courierOrgId)
                && taskGroupIds.equals(other.taskGroupIds)
                && statementAmount == other.statementAmount
                && statementStatus.equals(other.statementStatus)
                && statementCompletedAtTimestamp.equals(other.statementCompletedAtTimestamp)
                && statementCompletedByUserId.equals(other.statementCompletedByUserId)
                && statementCreatedAtTimestamp.equals(other.statementCreatedAtTimestamp)
                && statementCreatedByUserId.equals(other.statementCreatedByUserId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.courierPayDriverLineItemGroupIds,
                this.id,
                this.driverId,
                this.courierOrgId,
                this.taskGroupIds,
                this.statementAmount,
                this.statementStatus,
                this.statementCompletedAtTimestamp,
                this.statementCompletedByUserId,
                this.statementCreatedAtTimestamp,
                this.statementCreatedByUserId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        IdStage schemaVersion(int schemaVersion);

        Builder from(CourierPayDriverStatement1 other);
    }

    public interface IdStage {
        DriverIdStage id(@NotNull String id);
    }

    public interface DriverIdStage {
        CourierOrgIdStage driverId(@NotNull String driverId);
    }

    public interface CourierOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        StatementAmountStage courierOrgId(@NotNull String courierOrgId);
    }

    public interface StatementAmountStage {
        StatementCreatedAtTimestampStage statementAmount(double statementAmount);
    }

    public interface StatementCreatedAtTimestampStage {
        StatementCreatedByUserIdStage statementCreatedAtTimestamp(@NotNull OffsetDateTime statementCreatedAtTimestamp);
    }

    public interface StatementCreatedByUserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage statementCreatedByUserId(@NotNull String statementCreatedByUserId);
    }

    public interface _FinalStage {
        CourierPayDriverStatement1 build();

        _FinalStage courierPayDriverLineItemGroupIds(List<String> courierPayDriverLineItemGroupIds);

        _FinalStage addCourierPayDriverLineItemGroupIds(String courierPayDriverLineItemGroupIds);

        _FinalStage addAllCourierPayDriverLineItemGroupIds(List<String> courierPayDriverLineItemGroupIds);

        _FinalStage taskGroupIds(List<String> taskGroupIds);

        _FinalStage addTaskGroupIds(String taskGroupIds);

        _FinalStage addAllTaskGroupIds(List<String> taskGroupIds);

        _FinalStage statementStatus(Optional<StatementStatusEnum> statementStatus);

        _FinalStage statementStatus(StatementStatusEnum statementStatus);

        _FinalStage statementCompletedAtTimestamp(Optional<OffsetDateTime> statementCompletedAtTimestamp);

        _FinalStage statementCompletedAtTimestamp(OffsetDateTime statementCompletedAtTimestamp);

        _FinalStage statementCompletedAtTimestamp(Nullable<OffsetDateTime> statementCompletedAtTimestamp);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage statementCompletedByUserId(Optional<String> statementCompletedByUserId);

        _FinalStage statementCompletedByUserId(String statementCompletedByUserId);

        _FinalStage statementCompletedByUserId(Nullable<String> statementCompletedByUserId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    IdStage,
                    DriverIdStage,
                    CourierOrgIdStage,
                    StatementAmountStage,
                    StatementCreatedAtTimestampStage,
                    StatementCreatedByUserIdStage,
                    _FinalStage {
        private int schemaVersion;

        private String id;

        private String driverId;

        private String courierOrgId;

        private double statementAmount;

        private OffsetDateTime statementCreatedAtTimestamp;

        private String statementCreatedByUserId;

        private Optional<String> statementCompletedByUserId = Optional.empty();

        private Optional<OffsetDateTime> statementCompletedAtTimestamp = Optional.empty();

        private Optional<StatementStatusEnum> statementStatus = Optional.empty();

        private List<String> taskGroupIds = new ArrayList<>();

        private List<String> courierPayDriverLineItemGroupIds = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CourierPayDriverStatement1 other) {
            schemaVersion(other.getSchemaVersion());
            courierPayDriverLineItemGroupIds(other.getCourierPayDriverLineItemGroupIds());
            id(other.getId());
            driverId(other.getDriverId());
            courierOrgId(other.getCourierOrgId());
            taskGroupIds(other.getTaskGroupIds());
            statementAmount(other.getStatementAmount());
            statementStatus(other.getStatementStatus());
            statementCompletedAtTimestamp(other.getStatementCompletedAtTimestamp());
            statementCompletedByUserId(other.getStatementCompletedByUserId());
            statementCreatedAtTimestamp(other.getStatementCreatedAtTimestamp());
            statementCreatedByUserId(other.getStatementCreatedByUserId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public DriverIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("driver_id")
        public CourierOrgIdStage driverId(@NotNull String driverId) {
            this.driverId = Objects.requireNonNull(driverId, "driverId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("courier_org_id")
        public StatementAmountStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("statement_amount")
        public StatementCreatedAtTimestampStage statementAmount(double statementAmount) {
            this.statementAmount = statementAmount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("statement_created_at_timestamp")
        public StatementCreatedByUserIdStage statementCreatedAtTimestamp(
                @NotNull OffsetDateTime statementCreatedAtTimestamp) {
            this.statementCreatedAtTimestamp =
                    Objects.requireNonNull(statementCreatedAtTimestamp, "statementCreatedAtTimestamp must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("statement_created_by_user_id")
        public _FinalStage statementCreatedByUserId(@NotNull String statementCreatedByUserId) {
            this.statementCreatedByUserId =
                    Objects.requireNonNull(statementCreatedByUserId, "statementCreatedByUserId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage statementCompletedByUserId(Nullable<String> statementCompletedByUserId) {
            if (statementCompletedByUserId.isNull()) {
                this.statementCompletedByUserId = null;
            } else if (statementCompletedByUserId.isEmpty()) {
                this.statementCompletedByUserId = Optional.empty();
            } else {
                this.statementCompletedByUserId = Optional.of(statementCompletedByUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage statementCompletedByUserId(String statementCompletedByUserId) {
            this.statementCompletedByUserId = Optional.ofNullable(statementCompletedByUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "statement_completed_by_user_id", nulls = Nulls.SKIP)
        public _FinalStage statementCompletedByUserId(Optional<String> statementCompletedByUserId) {
            this.statementCompletedByUserId = statementCompletedByUserId;
            return this;
        }

        @java.lang.Override
        public _FinalStage statementCompletedAtTimestamp(Nullable<OffsetDateTime> statementCompletedAtTimestamp) {
            if (statementCompletedAtTimestamp.isNull()) {
                this.statementCompletedAtTimestamp = null;
            } else if (statementCompletedAtTimestamp.isEmpty()) {
                this.statementCompletedAtTimestamp = Optional.empty();
            } else {
                this.statementCompletedAtTimestamp = Optional.of(statementCompletedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage statementCompletedAtTimestamp(OffsetDateTime statementCompletedAtTimestamp) {
            this.statementCompletedAtTimestamp = Optional.ofNullable(statementCompletedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "statement_completed_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage statementCompletedAtTimestamp(Optional<OffsetDateTime> statementCompletedAtTimestamp) {
            this.statementCompletedAtTimestamp = statementCompletedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage statementStatus(StatementStatusEnum statementStatus) {
            this.statementStatus = Optional.ofNullable(statementStatus);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "statement_status", nulls = Nulls.SKIP)
        public _FinalStage statementStatus(Optional<StatementStatusEnum> statementStatus) {
            this.statementStatus = statementStatus;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllTaskGroupIds(List<String> taskGroupIds) {
            if (taskGroupIds != null) {
                this.taskGroupIds.addAll(taskGroupIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addTaskGroupIds(String taskGroupIds) {
            this.taskGroupIds.add(taskGroupIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_group_ids", nulls = Nulls.SKIP)
        public _FinalStage taskGroupIds(List<String> taskGroupIds) {
            this.taskGroupIds.clear();
            if (taskGroupIds != null) {
                this.taskGroupIds.addAll(taskGroupIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllCourierPayDriverLineItemGroupIds(List<String> courierPayDriverLineItemGroupIds) {
            if (courierPayDriverLineItemGroupIds != null) {
                this.courierPayDriverLineItemGroupIds.addAll(courierPayDriverLineItemGroupIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addCourierPayDriverLineItemGroupIds(String courierPayDriverLineItemGroupIds) {
            this.courierPayDriverLineItemGroupIds.add(courierPayDriverLineItemGroupIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "courier_pay_driver_line_item_group_ids", nulls = Nulls.SKIP)
        public _FinalStage courierPayDriverLineItemGroupIds(List<String> courierPayDriverLineItemGroupIds) {
            this.courierPayDriverLineItemGroupIds.clear();
            if (courierPayDriverLineItemGroupIds != null) {
                this.courierPayDriverLineItemGroupIds.addAll(courierPayDriverLineItemGroupIds);
            }
            return this;
        }

        @java.lang.Override
        public CourierPayDriverStatement1 build() {
            return new CourierPayDriverStatement1(
                    schemaVersion,
                    courierPayDriverLineItemGroupIds,
                    id,
                    driverId,
                    courierOrgId,
                    taskGroupIds,
                    statementAmount,
                    statementStatus,
                    statementCompletedAtTimestamp,
                    statementCompletedByUserId,
                    statementCreatedAtTimestamp,
                    statementCreatedByUserId,
                    additionalProperties);
        }
    }
}
