/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DecodedJwtWithOrgAndUserId.Builder.class)
public final class DecodedJwtWithOrgAndUserId {
    private final Optional<String> azp;

    private final Optional<Integer> exp;

    private final Optional<List<Integer>> fva;

    private final Optional<Integer> iat;

    private final Optional<String> iss;

    private final Optional<String> jti;

    private final Optional<Integer> nbf;

    private final Optional<String> sid;

    private final Optional<String> sub;

    private final Optional<String> sts;

    private final Optional<Integer> v;

    private final Optional<ClerkOrgData> o;

    private final Optional<Map<String, Object>> orgPublicMetadata;

    private final Optional<String> primaryEmailAddress;

    private final String userId;

    private final String orgId;

    private final Map<String, Object> additionalProperties;

    private DecodedJwtWithOrgAndUserId(
            Optional<String> azp,
            Optional<Integer> exp,
            Optional<List<Integer>> fva,
            Optional<Integer> iat,
            Optional<String> iss,
            Optional<String> jti,
            Optional<Integer> nbf,
            Optional<String> sid,
            Optional<String> sub,
            Optional<String> sts,
            Optional<Integer> v,
            Optional<ClerkOrgData> o,
            Optional<Map<String, Object>> orgPublicMetadata,
            Optional<String> primaryEmailAddress,
            String userId,
            String orgId,
            Map<String, Object> additionalProperties) {
        this.azp = azp;
        this.exp = exp;
        this.fva = fva;
        this.iat = iat;
        this.iss = iss;
        this.jti = jti;
        this.nbf = nbf;
        this.sid = sid;
        this.sub = sub;
        this.sts = sts;
        this.v = v;
        this.o = o;
        this.orgPublicMetadata = orgPublicMetadata;
        this.primaryEmailAddress = primaryEmailAddress;
        this.userId = userId;
        this.orgId = orgId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getAzp() {
        if (azp == null) {
            return Optional.empty();
        }
        return azp;
    }

    @JsonIgnore
    public Optional<Integer> getExp() {
        if (exp == null) {
            return Optional.empty();
        }
        return exp;
    }

    @JsonIgnore
    public Optional<List<Integer>> getFva() {
        if (fva == null) {
            return Optional.empty();
        }
        return fva;
    }

    @JsonIgnore
    public Optional<Integer> getIat() {
        if (iat == null) {
            return Optional.empty();
        }
        return iat;
    }

    @JsonIgnore
    public Optional<String> getIss() {
        if (iss == null) {
            return Optional.empty();
        }
        return iss;
    }

    @JsonIgnore
    public Optional<String> getJti() {
        if (jti == null) {
            return Optional.empty();
        }
        return jti;
    }

    @JsonIgnore
    public Optional<Integer> getNbf() {
        if (nbf == null) {
            return Optional.empty();
        }
        return nbf;
    }

    @JsonIgnore
    public Optional<String> getSid() {
        if (sid == null) {
            return Optional.empty();
        }
        return sid;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getSub() {
        if (sub == null) {
            return Optional.empty();
        }
        return sub;
    }

    @JsonIgnore
    public Optional<String> getSts() {
        if (sts == null) {
            return Optional.empty();
        }
        return sts;
    }

    @JsonIgnore
    public Optional<Integer> getV() {
        if (v == null) {
            return Optional.empty();
        }
        return v;
    }

    @JsonIgnore
    public Optional<ClerkOrgData> getO() {
        if (o == null) {
            return Optional.empty();
        }
        return o;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> getOrgPublicMetadata() {
        if (orgPublicMetadata == null) {
            return Optional.empty();
        }
        return orgPublicMetadata;
    }

    @JsonIgnore
    public Optional<String> getPrimaryEmailAddress() {
        if (primaryEmailAddress == null) {
            return Optional.empty();
        }
        return primaryEmailAddress;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("org_id")
    public String getOrgId() {
        return orgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("azp")
    private Optional<String> _getAzp() {
        return azp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("exp")
    private Optional<Integer> _getExp() {
        return exp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("fva")
    private Optional<List<Integer>> _getFva() {
        return fva;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("iat")
    private Optional<Integer> _getIat() {
        return iat;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("iss")
    private Optional<String> _getIss() {
        return iss;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("jti")
    private Optional<String> _getJti() {
        return jti;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("nbf")
    private Optional<Integer> _getNbf() {
        return nbf;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sid")
    private Optional<String> _getSid() {
        return sid;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sub")
    private Optional<String> _getSub() {
        return sub;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sts")
    private Optional<String> _getSts() {
        return sts;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("v")
    private Optional<Integer> _getV() {
        return v;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("o")
    private Optional<ClerkOrgData> _getO() {
        return o;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("org_public_metadata")
    private Optional<Map<String, Object>> _getOrgPublicMetadata() {
        return orgPublicMetadata;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("primary_email_address")
    private Optional<String> _getPrimaryEmailAddress() {
        return primaryEmailAddress;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DecodedJwtWithOrgAndUserId && equalTo((DecodedJwtWithOrgAndUserId) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DecodedJwtWithOrgAndUserId other) {
        return azp.equals(other.azp)
                && exp.equals(other.exp)
                && fva.equals(other.fva)
                && iat.equals(other.iat)
                && iss.equals(other.iss)
                && jti.equals(other.jti)
                && nbf.equals(other.nbf)
                && sid.equals(other.sid)
                && sub.equals(other.sub)
                && sts.equals(other.sts)
                && v.equals(other.v)
                && o.equals(other.o)
                && orgPublicMetadata.equals(other.orgPublicMetadata)
                && primaryEmailAddress.equals(other.primaryEmailAddress)
                && userId.equals(other.userId)
                && orgId.equals(other.orgId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.azp,
                this.exp,
                this.fva,
                this.iat,
                this.iss,
                this.jti,
                this.nbf,
                this.sid,
                this.sub,
                this.sts,
                this.v,
                this.o,
                this.orgPublicMetadata,
                this.primaryEmailAddress,
                this.userId,
                this.orgId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UserIdStage builder() {
        return new Builder();
    }

    public interface UserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        OrgIdStage userId(@NotNull String userId);

        Builder from(DecodedJwtWithOrgAndUserId other);
    }

    public interface OrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage orgId(@NotNull String orgId);
    }

    public interface _FinalStage {
        DecodedJwtWithOrgAndUserId build();

        _FinalStage azp(Optional<String> azp);

        _FinalStage azp(String azp);

        _FinalStage azp(Nullable<String> azp);

        _FinalStage exp(Optional<Integer> exp);

        _FinalStage exp(Integer exp);

        _FinalStage exp(Nullable<Integer> exp);

        _FinalStage fva(Optional<List<Integer>> fva);

        _FinalStage fva(List<Integer> fva);

        _FinalStage fva(Nullable<List<Integer>> fva);

        _FinalStage iat(Optional<Integer> iat);

        _FinalStage iat(Integer iat);

        _FinalStage iat(Nullable<Integer> iat);

        _FinalStage iss(Optional<String> iss);

        _FinalStage iss(String iss);

        _FinalStage iss(Nullable<String> iss);

        _FinalStage jti(Optional<String> jti);

        _FinalStage jti(String jti);

        _FinalStage jti(Nullable<String> jti);

        _FinalStage nbf(Optional<Integer> nbf);

        _FinalStage nbf(Integer nbf);

        _FinalStage nbf(Nullable<Integer> nbf);

        _FinalStage sid(Optional<String> sid);

        _FinalStage sid(String sid);

        _FinalStage sid(Nullable<String> sid);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage sub(Optional<String> sub);

        _FinalStage sub(String sub);

        _FinalStage sub(Nullable<String> sub);

        _FinalStage sts(Optional<String> sts);

        _FinalStage sts(String sts);

        _FinalStage sts(Nullable<String> sts);

        _FinalStage v(Optional<Integer> v);

        _FinalStage v(Integer v);

        _FinalStage v(Nullable<Integer> v);

        _FinalStage o(Optional<ClerkOrgData> o);

        _FinalStage o(ClerkOrgData o);

        _FinalStage o(Nullable<ClerkOrgData> o);

        _FinalStage orgPublicMetadata(Optional<Map<String, Object>> orgPublicMetadata);

        _FinalStage orgPublicMetadata(Map<String, Object> orgPublicMetadata);

        _FinalStage orgPublicMetadata(Nullable<Map<String, Object>> orgPublicMetadata);

        _FinalStage primaryEmailAddress(Optional<String> primaryEmailAddress);

        _FinalStage primaryEmailAddress(String primaryEmailAddress);

        _FinalStage primaryEmailAddress(Nullable<String> primaryEmailAddress);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements UserIdStage, OrgIdStage, _FinalStage {
        private String userId;

        private String orgId;

        private Optional<String> primaryEmailAddress = Optional.empty();

        private Optional<Map<String, Object>> orgPublicMetadata = Optional.empty();

        private Optional<ClerkOrgData> o = Optional.empty();

        private Optional<Integer> v = Optional.empty();

        private Optional<String> sts = Optional.empty();

        private Optional<String> sub = Optional.empty();

        private Optional<String> sid = Optional.empty();

        private Optional<Integer> nbf = Optional.empty();

        private Optional<String> jti = Optional.empty();

        private Optional<String> iss = Optional.empty();

        private Optional<Integer> iat = Optional.empty();

        private Optional<List<Integer>> fva = Optional.empty();

        private Optional<Integer> exp = Optional.empty();

        private Optional<String> azp = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DecodedJwtWithOrgAndUserId other) {
            azp(other.getAzp());
            exp(other.getExp());
            fva(other.getFva());
            iat(other.getIat());
            iss(other.getIss());
            jti(other.getJti());
            nbf(other.getNbf());
            sid(other.getSid());
            sub(other.getSub());
            sts(other.getSts());
            v(other.getV());
            o(other.getO());
            orgPublicMetadata(other.getOrgPublicMetadata());
            primaryEmailAddress(other.getPrimaryEmailAddress());
            userId(other.getUserId());
            orgId(other.getOrgId());
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user_id")
        public OrgIdStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("org_id")
        public _FinalStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage primaryEmailAddress(Nullable<String> primaryEmailAddress) {
            if (primaryEmailAddress.isNull()) {
                this.primaryEmailAddress = null;
            } else if (primaryEmailAddress.isEmpty()) {
                this.primaryEmailAddress = Optional.empty();
            } else {
                this.primaryEmailAddress = Optional.of(primaryEmailAddress.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage primaryEmailAddress(String primaryEmailAddress) {
            this.primaryEmailAddress = Optional.ofNullable(primaryEmailAddress);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "primary_email_address", nulls = Nulls.SKIP)
        public _FinalStage primaryEmailAddress(Optional<String> primaryEmailAddress) {
            this.primaryEmailAddress = primaryEmailAddress;
            return this;
        }

        @java.lang.Override
        public _FinalStage orgPublicMetadata(Nullable<Map<String, Object>> orgPublicMetadata) {
            if (orgPublicMetadata.isNull()) {
                this.orgPublicMetadata = null;
            } else if (orgPublicMetadata.isEmpty()) {
                this.orgPublicMetadata = Optional.empty();
            } else {
                this.orgPublicMetadata = Optional.of(orgPublicMetadata.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage orgPublicMetadata(Map<String, Object> orgPublicMetadata) {
            this.orgPublicMetadata = Optional.ofNullable(orgPublicMetadata);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "org_public_metadata", nulls = Nulls.SKIP)
        public _FinalStage orgPublicMetadata(Optional<Map<String, Object>> orgPublicMetadata) {
            this.orgPublicMetadata = orgPublicMetadata;
            return this;
        }

        @java.lang.Override
        public _FinalStage o(Nullable<ClerkOrgData> o) {
            if (o.isNull()) {
                this.o = null;
            } else if (o.isEmpty()) {
                this.o = Optional.empty();
            } else {
                this.o = Optional.of(o.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage o(ClerkOrgData o) {
            this.o = Optional.ofNullable(o);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "o", nulls = Nulls.SKIP)
        public _FinalStage o(Optional<ClerkOrgData> o) {
            this.o = o;
            return this;
        }

        @java.lang.Override
        public _FinalStage v(Nullable<Integer> v) {
            if (v.isNull()) {
                this.v = null;
            } else if (v.isEmpty()) {
                this.v = Optional.empty();
            } else {
                this.v = Optional.of(v.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage v(Integer v) {
            this.v = Optional.ofNullable(v);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "v", nulls = Nulls.SKIP)
        public _FinalStage v(Optional<Integer> v) {
            this.v = v;
            return this;
        }

        @java.lang.Override
        public _FinalStage sts(Nullable<String> sts) {
            if (sts.isNull()) {
                this.sts = null;
            } else if (sts.isEmpty()) {
                this.sts = Optional.empty();
            } else {
                this.sts = Optional.of(sts.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sts(String sts) {
            this.sts = Optional.ofNullable(sts);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sts", nulls = Nulls.SKIP)
        public _FinalStage sts(Optional<String> sts) {
            this.sts = sts;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage sub(Nullable<String> sub) {
            if (sub.isNull()) {
                this.sub = null;
            } else if (sub.isEmpty()) {
                this.sub = Optional.empty();
            } else {
                this.sub = Optional.of(sub.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage sub(String sub) {
            this.sub = Optional.ofNullable(sub);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "sub", nulls = Nulls.SKIP)
        public _FinalStage sub(Optional<String> sub) {
            this.sub = sub;
            return this;
        }

        @java.lang.Override
        public _FinalStage sid(Nullable<String> sid) {
            if (sid.isNull()) {
                this.sid = null;
            } else if (sid.isEmpty()) {
                this.sid = Optional.empty();
            } else {
                this.sid = Optional.of(sid.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sid(String sid) {
            this.sid = Optional.ofNullable(sid);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sid", nulls = Nulls.SKIP)
        public _FinalStage sid(Optional<String> sid) {
            this.sid = sid;
            return this;
        }

        @java.lang.Override
        public _FinalStage nbf(Nullable<Integer> nbf) {
            if (nbf.isNull()) {
                this.nbf = null;
            } else if (nbf.isEmpty()) {
                this.nbf = Optional.empty();
            } else {
                this.nbf = Optional.of(nbf.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage nbf(Integer nbf) {
            this.nbf = Optional.ofNullable(nbf);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "nbf", nulls = Nulls.SKIP)
        public _FinalStage nbf(Optional<Integer> nbf) {
            this.nbf = nbf;
            return this;
        }

        @java.lang.Override
        public _FinalStage jti(Nullable<String> jti) {
            if (jti.isNull()) {
                this.jti = null;
            } else if (jti.isEmpty()) {
                this.jti = Optional.empty();
            } else {
                this.jti = Optional.of(jti.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage jti(String jti) {
            this.jti = Optional.ofNullable(jti);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "jti", nulls = Nulls.SKIP)
        public _FinalStage jti(Optional<String> jti) {
            this.jti = jti;
            return this;
        }

        @java.lang.Override
        public _FinalStage iss(Nullable<String> iss) {
            if (iss.isNull()) {
                this.iss = null;
            } else if (iss.isEmpty()) {
                this.iss = Optional.empty();
            } else {
                this.iss = Optional.of(iss.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage iss(String iss) {
            this.iss = Optional.ofNullable(iss);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "iss", nulls = Nulls.SKIP)
        public _FinalStage iss(Optional<String> iss) {
            this.iss = iss;
            return this;
        }

        @java.lang.Override
        public _FinalStage iat(Nullable<Integer> iat) {
            if (iat.isNull()) {
                this.iat = null;
            } else if (iat.isEmpty()) {
                this.iat = Optional.empty();
            } else {
                this.iat = Optional.of(iat.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage iat(Integer iat) {
            this.iat = Optional.ofNullable(iat);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "iat", nulls = Nulls.SKIP)
        public _FinalStage iat(Optional<Integer> iat) {
            this.iat = iat;
            return this;
        }

        @java.lang.Override
        public _FinalStage fva(Nullable<List<Integer>> fva) {
            if (fva.isNull()) {
                this.fva = null;
            } else if (fva.isEmpty()) {
                this.fva = Optional.empty();
            } else {
                this.fva = Optional.of(fva.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage fva(List<Integer> fva) {
            this.fva = Optional.ofNullable(fva);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "fva", nulls = Nulls.SKIP)
        public _FinalStage fva(Optional<List<Integer>> fva) {
            this.fva = fva;
            return this;
        }

        @java.lang.Override
        public _FinalStage exp(Nullable<Integer> exp) {
            if (exp.isNull()) {
                this.exp = null;
            } else if (exp.isEmpty()) {
                this.exp = Optional.empty();
            } else {
                this.exp = Optional.of(exp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage exp(Integer exp) {
            this.exp = Optional.ofNullable(exp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "exp", nulls = Nulls.SKIP)
        public _FinalStage exp(Optional<Integer> exp) {
            this.exp = exp;
            return this;
        }

        @java.lang.Override
        public _FinalStage azp(Nullable<String> azp) {
            if (azp.isNull()) {
                this.azp = null;
            } else if (azp.isEmpty()) {
                this.azp = Optional.empty();
            } else {
                this.azp = Optional.of(azp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage azp(String azp) {
            this.azp = Optional.ofNullable(azp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "azp", nulls = Nulls.SKIP)
        public _FinalStage azp(Optional<String> azp) {
            this.azp = azp;
            return this;
        }

        @java.lang.Override
        public DecodedJwtWithOrgAndUserId build() {
            return new DecodedJwtWithOrgAndUserId(
                    azp,
                    exp,
                    fva,
                    iat,
                    iss,
                    jti,
                    nbf,
                    sid,
                    sub,
                    sts,
                    v,
                    o,
                    orgPublicMetadata,
                    primaryEmailAddress,
                    userId,
                    orgId,
                    additionalProperties);
        }
    }
}
