/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Device1.Builder.class)
public final class Device1 {
    private final int schemaVersion;

    private final String orgId;

    private final String deviceMacAddress;

    private final Optional<String> deviceToken;

    private final Optional<TrackingDeviceTypeEnum1> type;

    private final Optional<OffsetDateTime> registeredAtTimestamp;

    private final Optional<OffsetDateTime> firstSeenAtTimestamp;

    private final Optional<LocationFeature> lastSeenAtLocation;

    private final Optional<OffsetDateTime> lastSeenAtTimestamp;

    private final Optional<String> lastSeenBatteryLevel;

    private final Optional<String> sessionId;

    private final Optional<String> cargoId;

    private final Optional<String> comments;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private Device1(
            int schemaVersion,
            String orgId,
            String deviceMacAddress,
            Optional<String> deviceToken,
            Optional<TrackingDeviceTypeEnum1> type,
            Optional<OffsetDateTime> registeredAtTimestamp,
            Optional<OffsetDateTime> firstSeenAtTimestamp,
            Optional<LocationFeature> lastSeenAtLocation,
            Optional<OffsetDateTime> lastSeenAtTimestamp,
            Optional<String> lastSeenBatteryLevel,
            Optional<String> sessionId,
            Optional<String> cargoId,
            Optional<String> comments,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.orgId = orgId;
        this.deviceMacAddress = deviceMacAddress;
        this.deviceToken = deviceToken;
        this.type = type;
        this.registeredAtTimestamp = registeredAtTimestamp;
        this.firstSeenAtTimestamp = firstSeenAtTimestamp;
        this.lastSeenAtLocation = lastSeenAtLocation;
        this.lastSeenAtTimestamp = lastSeenAtTimestamp;
        this.lastSeenBatteryLevel = lastSeenBatteryLevel;
        this.sessionId = sessionId;
        this.cargoId = cargoId;
        this.comments = comments;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("org_id")
    public String getOrgId() {
        return orgId;
    }

    @JsonProperty("device_mac_address")
    public String getDeviceMacAddress() {
        return deviceMacAddress;
    }

    @JsonIgnore
    public Optional<String> getDeviceToken() {
        if (deviceToken == null) {
            return Optional.empty();
        }
        return deviceToken;
    }

    @JsonIgnore
    public Optional<TrackingDeviceTypeEnum1> getType() {
        if (type == null) {
            return Optional.empty();
        }
        return type;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getRegisteredAtTimestamp() {
        if (registeredAtTimestamp == null) {
            return Optional.empty();
        }
        return registeredAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFirstSeenAtTimestamp() {
        if (firstSeenAtTimestamp == null) {
            return Optional.empty();
        }
        return firstSeenAtTimestamp;
    }

    @JsonIgnore
    public Optional<LocationFeature> getLastSeenAtLocation() {
        if (lastSeenAtLocation == null) {
            return Optional.empty();
        }
        return lastSeenAtLocation;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenAtTimestamp() {
        if (lastSeenAtTimestamp == null) {
            return Optional.empty();
        }
        return lastSeenAtTimestamp;
    }

    @JsonIgnore
    public Optional<String> getLastSeenBatteryLevel() {
        if (lastSeenBatteryLevel == null) {
            return Optional.empty();
        }
        return lastSeenBatteryLevel;
    }

    @JsonIgnore
    public Optional<String> getSessionId() {
        if (sessionId == null) {
            return Optional.empty();
        }
        return sessionId;
    }

    @JsonIgnore
    public Optional<String> getCargoId() {
        if (cargoId == null) {
            return Optional.empty();
        }
        return cargoId;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (comments == null) {
            return Optional.empty();
        }
        return comments;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("device_token")
    private Optional<String> _getDeviceToken() {
        return deviceToken;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("type")
    private Optional<TrackingDeviceTypeEnum1> _getType() {
        return type;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("registered_at_timestamp")
    private Optional<OffsetDateTime> _getRegisteredAtTimestamp() {
        return registeredAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("first_seen_at_timestamp")
    private Optional<OffsetDateTime> _getFirstSeenAtTimestamp() {
        return firstSeenAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("last_seen_at_location")
    private Optional<LocationFeature> _getLastSeenAtLocation() {
        return lastSeenAtLocation;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("last_seen_at_timestamp")
    private Optional<OffsetDateTime> _getLastSeenAtTimestamp() {
        return lastSeenAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("last_seen_battery_level")
    private Optional<String> _getLastSeenBatteryLevel() {
        return lastSeenBatteryLevel;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("session_id")
    private Optional<String> _getSessionId() {
        return sessionId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("cargo_id")
    private Optional<String> _getCargoId() {
        return cargoId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comments")
    private Optional<String> _getComments() {
        return comments;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Device1 && equalTo((Device1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Device1 other) {
        return schemaVersion == other.schemaVersion
                && orgId.equals(other.orgId)
                && deviceMacAddress.equals(other.deviceMacAddress)
                && deviceToken.equals(other.deviceToken)
                && type.equals(other.type)
                && registeredAtTimestamp.equals(other.registeredAtTimestamp)
                && firstSeenAtTimestamp.equals(other.firstSeenAtTimestamp)
                && lastSeenAtLocation.equals(other.lastSeenAtLocation)
                && lastSeenAtTimestamp.equals(other.lastSeenAtTimestamp)
                && lastSeenBatteryLevel.equals(other.lastSeenBatteryLevel)
                && sessionId.equals(other.sessionId)
                && cargoId.equals(other.cargoId)
                && comments.equals(other.comments)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.orgId,
                this.deviceMacAddress,
                this.deviceToken,
                this.type,
                this.registeredAtTimestamp,
                this.firstSeenAtTimestamp,
                this.lastSeenAtLocation,
                this.lastSeenAtTimestamp,
                this.lastSeenBatteryLevel,
                this.sessionId,
                this.cargoId,
                this.comments,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        OrgIdStage schemaVersion(int schemaVersion);

        Builder from(Device1 other);
    }

    public interface OrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        DeviceMacAddressStage orgId(@NotNull String orgId);
    }

    public interface DeviceMacAddressStage {
        IdStage deviceMacAddress(@NotNull String deviceMacAddress);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        Device1 build();

        _FinalStage deviceToken(Optional<String> deviceToken);

        _FinalStage deviceToken(String deviceToken);

        _FinalStage deviceToken(Nullable<String> deviceToken);

        _FinalStage type(Optional<TrackingDeviceTypeEnum1> type);

        _FinalStage type(TrackingDeviceTypeEnum1 type);

        _FinalStage type(Nullable<TrackingDeviceTypeEnum1> type);

        _FinalStage registeredAtTimestamp(Optional<OffsetDateTime> registeredAtTimestamp);

        _FinalStage registeredAtTimestamp(OffsetDateTime registeredAtTimestamp);

        _FinalStage registeredAtTimestamp(Nullable<OffsetDateTime> registeredAtTimestamp);

        _FinalStage firstSeenAtTimestamp(Optional<OffsetDateTime> firstSeenAtTimestamp);

        _FinalStage firstSeenAtTimestamp(OffsetDateTime firstSeenAtTimestamp);

        _FinalStage firstSeenAtTimestamp(Nullable<OffsetDateTime> firstSeenAtTimestamp);

        _FinalStage lastSeenAtLocation(Optional<LocationFeature> lastSeenAtLocation);

        _FinalStage lastSeenAtLocation(LocationFeature lastSeenAtLocation);

        _FinalStage lastSeenAtLocation(Nullable<LocationFeature> lastSeenAtLocation);

        _FinalStage lastSeenAtTimestamp(Optional<OffsetDateTime> lastSeenAtTimestamp);

        _FinalStage lastSeenAtTimestamp(OffsetDateTime lastSeenAtTimestamp);

        _FinalStage lastSeenAtTimestamp(Nullable<OffsetDateTime> lastSeenAtTimestamp);

        _FinalStage lastSeenBatteryLevel(Optional<String> lastSeenBatteryLevel);

        _FinalStage lastSeenBatteryLevel(String lastSeenBatteryLevel);

        _FinalStage lastSeenBatteryLevel(Nullable<String> lastSeenBatteryLevel);

        _FinalStage sessionId(Optional<String> sessionId);

        _FinalStage sessionId(String sessionId);

        _FinalStage sessionId(Nullable<String> sessionId);

        _FinalStage cargoId(Optional<String> cargoId);

        _FinalStage cargoId(String cargoId);

        _FinalStage cargoId(Nullable<String> cargoId);

        _FinalStage comments(Optional<String> comments);

        _FinalStage comments(String comments);

        _FinalStage comments(Nullable<String> comments);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage, OrgIdStage, DeviceMacAddressStage, IdStage, _FinalStage {
        private int schemaVersion;

        private String orgId;

        private String deviceMacAddress;

        private String id;

        private Optional<String> comments = Optional.empty();

        private Optional<String> cargoId = Optional.empty();

        private Optional<String> sessionId = Optional.empty();

        private Optional<String> lastSeenBatteryLevel = Optional.empty();

        private Optional<OffsetDateTime> lastSeenAtTimestamp = Optional.empty();

        private Optional<LocationFeature> lastSeenAtLocation = Optional.empty();

        private Optional<OffsetDateTime> firstSeenAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> registeredAtTimestamp = Optional.empty();

        private Optional<TrackingDeviceTypeEnum1> type = Optional.empty();

        private Optional<String> deviceToken = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Device1 other) {
            schemaVersion(other.getSchemaVersion());
            orgId(other.getOrgId());
            deviceMacAddress(other.getDeviceMacAddress());
            deviceToken(other.getDeviceToken());
            type(other.getType());
            registeredAtTimestamp(other.getRegisteredAtTimestamp());
            firstSeenAtTimestamp(other.getFirstSeenAtTimestamp());
            lastSeenAtLocation(other.getLastSeenAtLocation());
            lastSeenAtTimestamp(other.getLastSeenAtTimestamp());
            lastSeenBatteryLevel(other.getLastSeenBatteryLevel());
            sessionId(other.getSessionId());
            cargoId(other.getCargoId());
            comments(other.getComments());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public OrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("org_id")
        public DeviceMacAddressStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("device_mac_address")
        public IdStage deviceMacAddress(@NotNull String deviceMacAddress) {
            this.deviceMacAddress = Objects.requireNonNull(deviceMacAddress, "deviceMacAddress must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(Nullable<String> comments) {
            if (comments.isNull()) {
                this.comments = null;
            } else if (comments.isEmpty()) {
                this.comments = Optional.empty();
            } else {
                this.comments = Optional.of(comments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "comments", nulls = Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @java.lang.Override
        public _FinalStage cargoId(Nullable<String> cargoId) {
            if (cargoId.isNull()) {
                this.cargoId = null;
            } else if (cargoId.isEmpty()) {
                this.cargoId = Optional.empty();
            } else {
                this.cargoId = Optional.of(cargoId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage cargoId(String cargoId) {
            this.cargoId = Optional.ofNullable(cargoId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "cargo_id", nulls = Nulls.SKIP)
        public _FinalStage cargoId(Optional<String> cargoId) {
            this.cargoId = cargoId;
            return this;
        }

        @java.lang.Override
        public _FinalStage sessionId(Nullable<String> sessionId) {
            if (sessionId.isNull()) {
                this.sessionId = null;
            } else if (sessionId.isEmpty()) {
                this.sessionId = Optional.empty();
            } else {
                this.sessionId = Optional.of(sessionId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sessionId(String sessionId) {
            this.sessionId = Optional.ofNullable(sessionId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "session_id", nulls = Nulls.SKIP)
        public _FinalStage sessionId(Optional<String> sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenBatteryLevel(Nullable<String> lastSeenBatteryLevel) {
            if (lastSeenBatteryLevel.isNull()) {
                this.lastSeenBatteryLevel = null;
            } else if (lastSeenBatteryLevel.isEmpty()) {
                this.lastSeenBatteryLevel = Optional.empty();
            } else {
                this.lastSeenBatteryLevel = Optional.of(lastSeenBatteryLevel.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenBatteryLevel(String lastSeenBatteryLevel) {
            this.lastSeenBatteryLevel = Optional.ofNullable(lastSeenBatteryLevel);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_seen_battery_level", nulls = Nulls.SKIP)
        public _FinalStage lastSeenBatteryLevel(Optional<String> lastSeenBatteryLevel) {
            this.lastSeenBatteryLevel = lastSeenBatteryLevel;
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenAtTimestamp(Nullable<OffsetDateTime> lastSeenAtTimestamp) {
            if (lastSeenAtTimestamp.isNull()) {
                this.lastSeenAtTimestamp = null;
            } else if (lastSeenAtTimestamp.isEmpty()) {
                this.lastSeenAtTimestamp = Optional.empty();
            } else {
                this.lastSeenAtTimestamp = Optional.of(lastSeenAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenAtTimestamp(OffsetDateTime lastSeenAtTimestamp) {
            this.lastSeenAtTimestamp = Optional.ofNullable(lastSeenAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_seen_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage lastSeenAtTimestamp(Optional<OffsetDateTime> lastSeenAtTimestamp) {
            this.lastSeenAtTimestamp = lastSeenAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenAtLocation(Nullable<LocationFeature> lastSeenAtLocation) {
            if (lastSeenAtLocation.isNull()) {
                this.lastSeenAtLocation = null;
            } else if (lastSeenAtLocation.isEmpty()) {
                this.lastSeenAtLocation = Optional.empty();
            } else {
                this.lastSeenAtLocation = Optional.of(lastSeenAtLocation.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage lastSeenAtLocation(LocationFeature lastSeenAtLocation) {
            this.lastSeenAtLocation = Optional.ofNullable(lastSeenAtLocation);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_seen_at_location", nulls = Nulls.SKIP)
        public _FinalStage lastSeenAtLocation(Optional<LocationFeature> lastSeenAtLocation) {
            this.lastSeenAtLocation = lastSeenAtLocation;
            return this;
        }

        @java.lang.Override
        public _FinalStage firstSeenAtTimestamp(Nullable<OffsetDateTime> firstSeenAtTimestamp) {
            if (firstSeenAtTimestamp.isNull()) {
                this.firstSeenAtTimestamp = null;
            } else if (firstSeenAtTimestamp.isEmpty()) {
                this.firstSeenAtTimestamp = Optional.empty();
            } else {
                this.firstSeenAtTimestamp = Optional.of(firstSeenAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage firstSeenAtTimestamp(OffsetDateTime firstSeenAtTimestamp) {
            this.firstSeenAtTimestamp = Optional.ofNullable(firstSeenAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "first_seen_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage firstSeenAtTimestamp(Optional<OffsetDateTime> firstSeenAtTimestamp) {
            this.firstSeenAtTimestamp = firstSeenAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage registeredAtTimestamp(Nullable<OffsetDateTime> registeredAtTimestamp) {
            if (registeredAtTimestamp.isNull()) {
                this.registeredAtTimestamp = null;
            } else if (registeredAtTimestamp.isEmpty()) {
                this.registeredAtTimestamp = Optional.empty();
            } else {
                this.registeredAtTimestamp = Optional.of(registeredAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage registeredAtTimestamp(OffsetDateTime registeredAtTimestamp) {
            this.registeredAtTimestamp = Optional.ofNullable(registeredAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "registered_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage registeredAtTimestamp(Optional<OffsetDateTime> registeredAtTimestamp) {
            this.registeredAtTimestamp = registeredAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage type(Nullable<TrackingDeviceTypeEnum1> type) {
            if (type.isNull()) {
                this.type = null;
            } else if (type.isEmpty()) {
                this.type = Optional.empty();
            } else {
                this.type = Optional.of(type.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage type(TrackingDeviceTypeEnum1 type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public _FinalStage type(Optional<TrackingDeviceTypeEnum1> type) {
            this.type = type;
            return this;
        }

        @java.lang.Override
        public _FinalStage deviceToken(Nullable<String> deviceToken) {
            if (deviceToken.isNull()) {
                this.deviceToken = null;
            } else if (deviceToken.isEmpty()) {
                this.deviceToken = Optional.empty();
            } else {
                this.deviceToken = Optional.of(deviceToken.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage deviceToken(String deviceToken) {
            this.deviceToken = Optional.ofNullable(deviceToken);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "device_token", nulls = Nulls.SKIP)
        public _FinalStage deviceToken(Optional<String> deviceToken) {
            this.deviceToken = deviceToken;
            return this;
        }

        @java.lang.Override
        public Device1 build() {
            return new Device1(
                    schemaVersion,
                    orgId,
                    deviceMacAddress,
                    deviceToken,
                    type,
                    registeredAtTimestamp,
                    firstSeenAtTimestamp,
                    lastSeenAtLocation,
                    lastSeenAtTimestamp,
                    lastSeenBatteryLevel,
                    sessionId,
                    cargoId,
                    comments,
                    id,
                    additionalProperties);
        }
    }
}
