/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DriverUpdateRes.Builder.class)
public final class DriverUpdateRes {
    private final boolean driverUpdated;

    private final int taskGroupTrackingCount;

    private final int cargoTrackingCount;

    private final Map<String, Object> additionalProperties;

    private DriverUpdateRes(
            boolean driverUpdated,
            int taskGroupTrackingCount,
            int cargoTrackingCount,
            Map<String, Object> additionalProperties) {
        this.driverUpdated = driverUpdated;
        this.taskGroupTrackingCount = taskGroupTrackingCount;
        this.cargoTrackingCount = cargoTrackingCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("driver_updated")
    public boolean getDriverUpdated() {
        return driverUpdated;
    }

    @JsonProperty("task_group_tracking_count")
    public int getTaskGroupTrackingCount() {
        return taskGroupTrackingCount;
    }

    @JsonProperty("cargo_tracking_count")
    public int getCargoTrackingCount() {
        return cargoTrackingCount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DriverUpdateRes && equalTo((DriverUpdateRes) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DriverUpdateRes other) {
        return driverUpdated == other.driverUpdated
                && taskGroupTrackingCount == other.taskGroupTrackingCount
                && cargoTrackingCount == other.cargoTrackingCount;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.driverUpdated, this.taskGroupTrackingCount, this.cargoTrackingCount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DriverUpdatedStage builder() {
        return new Builder();
    }

    public interface DriverUpdatedStage {
        TaskGroupTrackingCountStage driverUpdated(boolean driverUpdated);

        Builder from(DriverUpdateRes other);
    }

    public interface TaskGroupTrackingCountStage {
        CargoTrackingCountStage taskGroupTrackingCount(int taskGroupTrackingCount);
    }

    public interface CargoTrackingCountStage {
        _FinalStage cargoTrackingCount(int cargoTrackingCount);
    }

    public interface _FinalStage {
        DriverUpdateRes build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements DriverUpdatedStage, TaskGroupTrackingCountStage, CargoTrackingCountStage, _FinalStage {
        private boolean driverUpdated;

        private int taskGroupTrackingCount;

        private int cargoTrackingCount;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DriverUpdateRes other) {
            driverUpdated(other.getDriverUpdated());
            taskGroupTrackingCount(other.getTaskGroupTrackingCount());
            cargoTrackingCount(other.getCargoTrackingCount());
            return this;
        }

        @java.lang.Override
        @JsonSetter("driver_updated")
        public TaskGroupTrackingCountStage driverUpdated(boolean driverUpdated) {
            this.driverUpdated = driverUpdated;
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_tracking_count")
        public CargoTrackingCountStage taskGroupTrackingCount(int taskGroupTrackingCount) {
            this.taskGroupTrackingCount = taskGroupTrackingCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("cargo_tracking_count")
        public _FinalStage cargoTrackingCount(int cargoTrackingCount) {
            this.cargoTrackingCount = cargoTrackingCount;
            return this;
        }

        @java.lang.Override
        public DriverUpdateRes build() {
            return new DriverUpdateRes(driverUpdated, taskGroupTrackingCount, cargoTrackingCount, additionalProperties);
        }
    }
}
