/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ForwarderCourierConnection1.Builder.class)
public final class ForwarderCourierConnection1 {
    private final int schemaVersion;

    private final String forwarderOrgId;

    private final String courierOrgId;

    private final Optional<Boolean> connected;

    private final Optional<String> forwarderCustomerIdForCourierStripeConnectAccount;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private ForwarderCourierConnection1(
            int schemaVersion,
            String forwarderOrgId,
            String courierOrgId,
            Optional<Boolean> connected,
            Optional<String> forwarderCustomerIdForCourierStripeConnectAccount,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.forwarderOrgId = forwarderOrgId;
        this.courierOrgId = courierOrgId;
        this.connected = connected;
        this.forwarderCustomerIdForCourierStripeConnectAccount = forwarderCustomerIdForCourierStripeConnectAccount;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("forwarder_org_id")
    public String getForwarderOrgId() {
        return forwarderOrgId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("courier_org_id")
    public String getCourierOrgId() {
        return courierOrgId;
    }

    @JsonProperty("connected")
    public Optional<Boolean> getConnected() {
        return connected;
    }

    @JsonIgnore
    public Optional<String> getForwarderCustomerIdForCourierStripeConnectAccount() {
        if (forwarderCustomerIdForCourierStripeConnectAccount == null) {
            return Optional.empty();
        }
        return forwarderCustomerIdForCourierStripeConnectAccount;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("forwarder_customer_id_for_courier_stripe_connect_account")
    private Optional<String> _getForwarderCustomerIdForCourierStripeConnectAccount() {
        return forwarderCustomerIdForCourierStripeConnectAccount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ForwarderCourierConnection1 && equalTo((ForwarderCourierConnection1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ForwarderCourierConnection1 other) {
        return schemaVersion == other.schemaVersion
                && forwarderOrgId.equals(other.forwarderOrgId)
                && courierOrgId.equals(other.courierOrgId)
                && connected.equals(other.connected)
                && forwarderCustomerIdForCourierStripeConnectAccount.equals(
                        other.forwarderCustomerIdForCourierStripeConnectAccount)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.forwarderOrgId,
                this.courierOrgId,
                this.connected,
                this.forwarderCustomerIdForCourierStripeConnectAccount,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        ForwarderOrgIdStage schemaVersion(int schemaVersion);

        Builder from(ForwarderCourierConnection1 other);
    }

    public interface ForwarderOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        CourierOrgIdStage forwarderOrgId(@NotNull String forwarderOrgId);
    }

    public interface CourierOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        IdStage courierOrgId(@NotNull String courierOrgId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        ForwarderCourierConnection1 build();

        _FinalStage connected(Optional<Boolean> connected);

        _FinalStage connected(Boolean connected);

        _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(
                Optional<String> forwarderCustomerIdForCourierStripeConnectAccount);

        _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(
                String forwarderCustomerIdForCourierStripeConnectAccount);

        _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(
                Nullable<String> forwarderCustomerIdForCourierStripeConnectAccount);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage, ForwarderOrgIdStage, CourierOrgIdStage, IdStage, _FinalStage {
        private int schemaVersion;

        private String forwarderOrgId;

        private String courierOrgId;

        private String id;

        private Optional<String> forwarderCustomerIdForCourierStripeConnectAccount = Optional.empty();

        private Optional<Boolean> connected = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ForwarderCourierConnection1 other) {
            schemaVersion(other.getSchemaVersion());
            forwarderOrgId(other.getForwarderOrgId());
            courierOrgId(other.getCourierOrgId());
            connected(other.getConnected());
            forwarderCustomerIdForCourierStripeConnectAccount(
                    other.getForwarderCustomerIdForCourierStripeConnectAccount());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public ForwarderOrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("forwarder_org_id")
        public CourierOrgIdStage forwarderOrgId(@NotNull String forwarderOrgId) {
            this.forwarderOrgId = Objects.requireNonNull(forwarderOrgId, "forwarderOrgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("courier_org_id")
        public IdStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(
                Nullable<String> forwarderCustomerIdForCourierStripeConnectAccount) {
            if (forwarderCustomerIdForCourierStripeConnectAccount.isNull()) {
                this.forwarderCustomerIdForCourierStripeConnectAccount = null;
            } else if (forwarderCustomerIdForCourierStripeConnectAccount.isEmpty()) {
                this.forwarderCustomerIdForCourierStripeConnectAccount = Optional.empty();
            } else {
                this.forwarderCustomerIdForCourierStripeConnectAccount =
                        Optional.of(forwarderCustomerIdForCourierStripeConnectAccount.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(
                String forwarderCustomerIdForCourierStripeConnectAccount) {
            this.forwarderCustomerIdForCourierStripeConnectAccount =
                    Optional.ofNullable(forwarderCustomerIdForCourierStripeConnectAccount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "forwarder_customer_id_for_courier_stripe_connect_account", nulls = Nulls.SKIP)
        public _FinalStage forwarderCustomerIdForCourierStripeConnectAccount(
                Optional<String> forwarderCustomerIdForCourierStripeConnectAccount) {
            this.forwarderCustomerIdForCourierStripeConnectAccount = forwarderCustomerIdForCourierStripeConnectAccount;
            return this;
        }

        @java.lang.Override
        public _FinalStage connected(Boolean connected) {
            this.connected = Optional.ofNullable(connected);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "connected", nulls = Nulls.SKIP)
        public _FinalStage connected(Optional<Boolean> connected) {
            this.connected = connected;
            return this;
        }

        @java.lang.Override
        public ForwarderCourierConnection1 build() {
            return new ForwarderCourierConnection1(
                    schemaVersion,
                    forwarderOrgId,
                    courierOrgId,
                    connected,
                    forwarderCustomerIdForCourierStripeConnectAccount,
                    id,
                    additionalProperties);
        }
    }
}
