/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = GenerateInvoiceRes.Builder.class)
public final class GenerateInvoiceRes {
    private final String invoiceId;

    private final String invoiceUrl;

    private final int amountDue;

    private final int dueDate;

    private final Map<String, Object> additionalProperties;

    private GenerateInvoiceRes(
            String invoiceId, String invoiceUrl, int amountDue, int dueDate, Map<String, Object> additionalProperties) {
        this.invoiceId = invoiceId;
        this.invoiceUrl = invoiceUrl;
        this.amountDue = amountDue;
        this.dueDate = dueDate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("invoice_id")
    public String getInvoiceId() {
        return invoiceId;
    }

    @JsonProperty("invoice_url")
    public String getInvoiceUrl() {
        return invoiceUrl;
    }

    @JsonProperty("amount_due")
    public int getAmountDue() {
        return amountDue;
    }

    @JsonProperty("due_date")
    public int getDueDate() {
        return dueDate;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof GenerateInvoiceRes && equalTo((GenerateInvoiceRes) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GenerateInvoiceRes other) {
        return invoiceId.equals(other.invoiceId)
                && invoiceUrl.equals(other.invoiceUrl)
                && amountDue == other.amountDue
                && dueDate == other.dueDate;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.invoiceId, this.invoiceUrl, this.amountDue, this.dueDate);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InvoiceIdStage builder() {
        return new Builder();
    }

    public interface InvoiceIdStage {
        InvoiceUrlStage invoiceId(@NotNull String invoiceId);

        Builder from(GenerateInvoiceRes other);
    }

    public interface InvoiceUrlStage {
        AmountDueStage invoiceUrl(@NotNull String invoiceUrl);
    }

    public interface AmountDueStage {
        DueDateStage amountDue(int amountDue);
    }

    public interface DueDateStage {
        _FinalStage dueDate(int dueDate);
    }

    public interface _FinalStage {
        GenerateInvoiceRes build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements InvoiceIdStage, InvoiceUrlStage, AmountDueStage, DueDateStage, _FinalStage {
        private String invoiceId;

        private String invoiceUrl;

        private int amountDue;

        private int dueDate;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(GenerateInvoiceRes other) {
            invoiceId(other.getInvoiceId());
            invoiceUrl(other.getInvoiceUrl());
            amountDue(other.getAmountDue());
            dueDate(other.getDueDate());
            return this;
        }

        @java.lang.Override
        @JsonSetter("invoice_id")
        public InvoiceUrlStage invoiceId(@NotNull String invoiceId) {
            this.invoiceId = Objects.requireNonNull(invoiceId, "invoiceId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("invoice_url")
        public AmountDueStage invoiceUrl(@NotNull String invoiceUrl) {
            this.invoiceUrl = Objects.requireNonNull(invoiceUrl, "invoiceUrl must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("amount_due")
        public DueDateStage amountDue(int amountDue) {
            this.amountDue = amountDue;
            return this;
        }

        @java.lang.Override
        @JsonSetter("due_date")
        public _FinalStage dueDate(int dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        @java.lang.Override
        public GenerateInvoiceRes build() {
            return new GenerateInvoiceRes(invoiceId, invoiceUrl, amountDue, dueDate, additionalProperties);
        }
    }
}
