/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LineItem1.Builder.class)
public final class LineItem1 {
    private final int schemaVersion;

    private final LineItemEnum1 item;

    private final double quantity;

    private final double rate;

    private final Optional<String> comment;

    private final OffsetDateTime createdAtTimestamp;

    private final String uuidStr;

    private final Map<String, Object> additionalProperties;

    private LineItem1(
            int schemaVersion,
            LineItemEnum1 item,
            double quantity,
            double rate,
            Optional<String> comment,
            OffsetDateTime createdAtTimestamp,
            String uuidStr,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.item = item;
        this.quantity = quantity;
        this.rate = rate;
        this.comment = comment;
        this.createdAtTimestamp = createdAtTimestamp;
        this.uuidStr = uuidStr;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("item")
    public LineItemEnum1 getItem() {
        return item;
    }

    @JsonProperty("quantity")
    public double getQuantity() {
        return quantity;
    }

    @JsonProperty("rate")
    public double getRate() {
        return rate;
    }

    @JsonIgnore
    public Optional<String> getComment() {
        if (comment == null) {
            return Optional.empty();
        }
        return comment;
    }

    @JsonProperty("created_at_timestamp")
    public OffsetDateTime getCreatedAtTimestamp() {
        return createdAtTimestamp;
    }

    @JsonProperty("uuid_str")
    public String getUuidStr() {
        return uuidStr;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comment")
    private Optional<String> _getComment() {
        return comment;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LineItem1 && equalTo((LineItem1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LineItem1 other) {
        return schemaVersion == other.schemaVersion
                && item.equals(other.item)
                && quantity == other.quantity
                && rate == other.rate
                && comment.equals(other.comment)
                && createdAtTimestamp.equals(other.createdAtTimestamp)
                && uuidStr.equals(other.uuidStr);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.item,
                this.quantity,
                this.rate,
                this.comment,
                this.createdAtTimestamp,
                this.uuidStr);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        ItemStage schemaVersion(int schemaVersion);

        Builder from(LineItem1 other);
    }

    public interface ItemStage {
        QuantityStage item(@NotNull LineItemEnum1 item);
    }

    public interface QuantityStage {
        RateStage quantity(double quantity);
    }

    public interface RateStage {
        CreatedAtTimestampStage rate(double rate);
    }

    public interface CreatedAtTimestampStage {
        UuidStrStage createdAtTimestamp(@NotNull OffsetDateTime createdAtTimestamp);
    }

    public interface UuidStrStage {
        _FinalStage uuidStr(@NotNull String uuidStr);
    }

    public interface _FinalStage {
        LineItem1 build();

        _FinalStage comment(Optional<String> comment);

        _FinalStage comment(String comment);

        _FinalStage comment(Nullable<String> comment);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    ItemStage,
                    QuantityStage,
                    RateStage,
                    CreatedAtTimestampStage,
                    UuidStrStage,
                    _FinalStage {
        private int schemaVersion;

        private LineItemEnum1 item;

        private double quantity;

        private double rate;

        private OffsetDateTime createdAtTimestamp;

        private String uuidStr;

        private Optional<String> comment = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LineItem1 other) {
            schemaVersion(other.getSchemaVersion());
            item(other.getItem());
            quantity(other.getQuantity());
            rate(other.getRate());
            comment(other.getComment());
            createdAtTimestamp(other.getCreatedAtTimestamp());
            uuidStr(other.getUuidStr());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public ItemStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("item")
        public QuantityStage item(@NotNull LineItemEnum1 item) {
            this.item = Objects.requireNonNull(item, "item must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public RateStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("rate")
        public CreatedAtTimestampStage rate(double rate) {
            this.rate = rate;
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at_timestamp")
        public UuidStrStage createdAtTimestamp(@NotNull OffsetDateTime createdAtTimestamp) {
            this.createdAtTimestamp = Objects.requireNonNull(createdAtTimestamp, "createdAtTimestamp must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("uuid_str")
        public _FinalStage uuidStr(@NotNull String uuidStr) {
            this.uuidStr = Objects.requireNonNull(uuidStr, "uuidStr must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage comment(Nullable<String> comment) {
            if (comment.isNull()) {
                this.comment = null;
            } else if (comment.isEmpty()) {
                this.comment = Optional.empty();
            } else {
                this.comment = Optional.of(comment.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage comment(String comment) {
            this.comment = Optional.ofNullable(comment);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "comment", nulls = Nulls.SKIP)
        public _FinalStage comment(Optional<String> comment) {
            this.comment = comment;
            return this;
        }

        @java.lang.Override
        public LineItem1 build() {
            return new LineItem1(
                    schemaVersion, item, quantity, rate, comment, createdAtTimestamp, uuidStr, additionalProperties);
        }
    }
}
