/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LineItemClientCreate1.Builder.class)
public final class LineItemClientCreate1 {
    private final int schemaVersion;

    private final LineItemEnum1 item;

    private final double quantity;

    private final double rate;

    private final Optional<String> comment;

    private final Map<String, Object> additionalProperties;

    private LineItemClientCreate1(
            int schemaVersion,
            LineItemEnum1 item,
            double quantity,
            double rate,
            Optional<String> comment,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.item = item;
        this.quantity = quantity;
        this.rate = rate;
        this.comment = comment;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("item")
    public LineItemEnum1 getItem() {
        return item;
    }

    @JsonProperty("quantity")
    public double getQuantity() {
        return quantity;
    }

    @JsonProperty("rate")
    public double getRate() {
        return rate;
    }

    @JsonIgnore
    public Optional<String> getComment() {
        if (comment == null) {
            return Optional.empty();
        }
        return comment;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comment")
    private Optional<String> _getComment() {
        return comment;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LineItemClientCreate1 && equalTo((LineItemClientCreate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LineItemClientCreate1 other) {
        return schemaVersion == other.schemaVersion
                && item.equals(other.item)
                && quantity == other.quantity
                && rate == other.rate
                && comment.equals(other.comment);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.item, this.quantity, this.rate, this.comment);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        ItemStage schemaVersion(int schemaVersion);

        Builder from(LineItemClientCreate1 other);
    }

    public interface ItemStage {
        QuantityStage item(@NotNull LineItemEnum1 item);
    }

    public interface QuantityStage {
        RateStage quantity(double quantity);
    }

    public interface RateStage {
        _FinalStage rate(double rate);
    }

    public interface _FinalStage {
        LineItemClientCreate1 build();

        _FinalStage comment(Optional<String> comment);

        _FinalStage comment(String comment);

        _FinalStage comment(Nullable<String> comment);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SchemaVersionStage, ItemStage, QuantityStage, RateStage, _FinalStage {
        private int schemaVersion;

        private LineItemEnum1 item;

        private double quantity;

        private double rate;

        private Optional<String> comment = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LineItemClientCreate1 other) {
            schemaVersion(other.getSchemaVersion());
            item(other.getItem());
            quantity(other.getQuantity());
            rate(other.getRate());
            comment(other.getComment());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public ItemStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("item")
        public QuantityStage item(@NotNull LineItemEnum1 item) {
            this.item = Objects.requireNonNull(item, "item must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public RateStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("rate")
        public _FinalStage rate(double rate) {
            this.rate = rate;
            return this;
        }

        @java.lang.Override
        public _FinalStage comment(Nullable<String> comment) {
            if (comment.isNull()) {
                this.comment = null;
            } else if (comment.isEmpty()) {
                this.comment = Optional.empty();
            } else {
                this.comment = Optional.of(comment.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage comment(String comment) {
            this.comment = Optional.ofNullable(comment);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "comment", nulls = Nulls.SKIP)
        public _FinalStage comment(Optional<String> comment) {
            this.comment = comment;
            return this;
        }

        @java.lang.Override
        public LineItemClientCreate1 build() {
            return new LineItemClientCreate1(schemaVersion, item, quantity, rate, comment, additionalProperties);
        }
    }
}
