/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LocationProperties.Builder.class)
public final class LocationProperties {
    private final Optional<String> address;

    private final Optional<String> name;

    private final Map<String, Object> additionalProperties;

    private LocationProperties(
            Optional<String> address, Optional<String> name, Map<String, Object> additionalProperties) {
        this.address = address;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getAddress() {
        if (address == null) {
            return Optional.empty();
        }
        return address;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (name == null) {
            return Optional.empty();
        }
        return name;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("address")
    private Optional<String> _getAddress() {
        return address;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("name")
    private Optional<String> _getName() {
        return name;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LocationProperties && equalTo((LocationProperties) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LocationProperties other) {
        return address.equals(other.address) && name.equals(other.name);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.address, this.name);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> address = Optional.empty();

        private Optional<String> name = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(LocationProperties other) {
            address(other.getAddress());
            name(other.getName());
            return this;
        }

        @JsonSetter(value = "address", nulls = Nulls.SKIP)
        public Builder address(Optional<String> address) {
            this.address = address;
            return this;
        }

        public Builder address(String address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder address(Nullable<String> address) {
            if (address.isNull()) {
                this.address = null;
            } else if (address.isEmpty()) {
                this.address = Optional.empty();
            } else {
                this.address = Optional.of(address.get());
            }
            return this;
        }

        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            if (name.isNull()) {
                this.name = null;
            } else if (name.isEmpty()) {
                this.name = Optional.empty();
            } else {
                this.name = Optional.of(name.get());
            }
            return this;
        }

        public LocationProperties build() {
            return new LocationProperties(address, name, additionalProperties);
        }
    }
}
