/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = MultiPoint.Builder.class)
public final class MultiPoint {
    private final Optional<List<Object>> bbox;

    private final List<MultiPointCoordinatesItem> coordinates;

    private final Map<String, Object> additionalProperties;

    private MultiPoint(
            Optional<List<Object>> bbox,
            List<MultiPointCoordinatesItem> coordinates,
            Map<String, Object> additionalProperties) {
        this.bbox = bbox;
        this.coordinates = coordinates;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<Object>> getBbox() {
        if (bbox == null) {
            return Optional.empty();
        }
        return bbox;
    }

    @JsonProperty("coordinates")
    public List<MultiPointCoordinatesItem> getCoordinates() {
        return coordinates;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("bbox")
    private Optional<List<Object>> _getBbox() {
        return bbox;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof MultiPoint && equalTo((MultiPoint) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MultiPoint other) {
        return bbox.equals(other.bbox) && coordinates.equals(other.coordinates);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.bbox, this.coordinates);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<Object>> bbox = Optional.empty();

        private List<MultiPointCoordinatesItem> coordinates = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(MultiPoint other) {
            bbox(other.getBbox());
            coordinates(other.getCoordinates());
            return this;
        }

        @JsonSetter(value = "bbox", nulls = Nulls.SKIP)
        public Builder bbox(Optional<List<Object>> bbox) {
            this.bbox = bbox;
            return this;
        }

        public Builder bbox(List<Object> bbox) {
            this.bbox = Optional.ofNullable(bbox);
            return this;
        }

        public Builder bbox(Nullable<List<Object>> bbox) {
            if (bbox.isNull()) {
                this.bbox = null;
            } else if (bbox.isEmpty()) {
                this.bbox = Optional.empty();
            } else {
                this.bbox = Optional.of(bbox.get());
            }
            return this;
        }

        @JsonSetter(value = "coordinates", nulls = Nulls.SKIP)
        public Builder coordinates(List<MultiPointCoordinatesItem> coordinates) {
            this.coordinates.clear();
            if (coordinates != null) {
                this.coordinates.addAll(coordinates);
            }
            return this;
        }

        public Builder addCoordinates(MultiPointCoordinatesItem coordinates) {
            this.coordinates.add(coordinates);
            return this;
        }

        public Builder addAllCoordinates(List<MultiPointCoordinatesItem> coordinates) {
            if (coordinates != null) {
                this.coordinates.addAll(coordinates);
            }
            return this;
        }

        public MultiPoint build() {
            return new MultiPoint(bbox, coordinates, additionalProperties);
        }
    }
}
