/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Order1.Builder.class)
public final class Order1 {
    private final int schemaVersion;

    private final String id;

    private final String shortId;

    private final Optional<List<String>> taskGroupIds;

    private final OrgTypeEnum createdByOrgType;

    private final String createdByOrgId;

    private final String createdByUserId;

    private final Optional<String> forwarderOrgId;

    private final Optional<String> shipperOrgId;

    private final Optional<String> offChrtShipperOrgId;

    private final Optional<OrderStatusEnum1> status;

    private final OffsetDateTime draftStartedAtTimestamp;

    private final Optional<OffsetDateTime> stagedAtTimestamp;

    private final Optional<OffsetDateTime> inProgressAtTimestamp;

    private final Optional<OffsetDateTime> completedAtTimestamp;

    private final Optional<OffsetDateTime> exceptionAtTimestamp;

    private final Optional<Boolean> orderCancelled;

    private final Optional<OffsetDateTime> orderCancelledAtTimestamp;

    private final Map<String, Object> additionalProperties;

    private Order1(
            int schemaVersion,
            String id,
            String shortId,
            Optional<List<String>> taskGroupIds,
            OrgTypeEnum createdByOrgType,
            String createdByOrgId,
            String createdByUserId,
            Optional<String> forwarderOrgId,
            Optional<String> shipperOrgId,
            Optional<String> offChrtShipperOrgId,
            Optional<OrderStatusEnum1> status,
            OffsetDateTime draftStartedAtTimestamp,
            Optional<OffsetDateTime> stagedAtTimestamp,
            Optional<OffsetDateTime> inProgressAtTimestamp,
            Optional<OffsetDateTime> completedAtTimestamp,
            Optional<OffsetDateTime> exceptionAtTimestamp,
            Optional<Boolean> orderCancelled,
            Optional<OffsetDateTime> orderCancelledAtTimestamp,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.shortId = shortId;
        this.taskGroupIds = taskGroupIds;
        this.createdByOrgType = createdByOrgType;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.forwarderOrgId = forwarderOrgId;
        this.shipperOrgId = shipperOrgId;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.status = status;
        this.draftStartedAtTimestamp = draftStartedAtTimestamp;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.inProgressAtTimestamp = inProgressAtTimestamp;
        this.completedAtTimestamp = completedAtTimestamp;
        this.exceptionAtTimestamp = exceptionAtTimestamp;
        this.orderCancelled = orderCancelled;
        this.orderCancelledAtTimestamp = orderCancelledAtTimestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonProperty("short_id")
    public String getShortId() {
        return shortId;
    }

    @JsonProperty("task_group_ids")
    public Optional<List<String>> getTaskGroupIds() {
        return taskGroupIds;
    }

    @JsonProperty("created_by_org_type")
    public OrgTypeEnum getCreatedByOrgType() {
        return createdByOrgType;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("created_by_org_id")
    public String getCreatedByOrgId() {
        return createdByOrgId;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("created_by_user_id")
    public String getCreatedByUserId() {
        return createdByUserId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getForwarderOrgId() {
        if (forwarderOrgId == null) {
            return Optional.empty();
        }
        return forwarderOrgId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (shipperOrgId == null) {
            return Optional.empty();
        }
        return shipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return offChrtShipperOrgId;
    }

    @JsonProperty("status")
    public Optional<OrderStatusEnum1> getStatus() {
        return status;
    }

    @JsonProperty("draft_started_at_timestamp")
    public OffsetDateTime getDraftStartedAtTimestamp() {
        return draftStartedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getInProgressAtTimestamp() {
        if (inProgressAtTimestamp == null) {
            return Optional.empty();
        }
        return inProgressAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedAtTimestamp() {
        if (completedAtTimestamp == null) {
            return Optional.empty();
        }
        return completedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExceptionAtTimestamp() {
        if (exceptionAtTimestamp == null) {
            return Optional.empty();
        }
        return exceptionAtTimestamp;
    }

    @JsonProperty("order_cancelled")
    public Optional<Boolean> getOrderCancelled() {
        return orderCancelled;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getOrderCancelledAtTimestamp() {
        if (orderCancelledAtTimestamp == null) {
            return Optional.empty();
        }
        return orderCancelledAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("forwarder_org_id")
    private Optional<String> _getForwarderOrgId() {
        return forwarderOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return shipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return offChrtShipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return stagedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("in_progress_at_timestamp")
    private Optional<OffsetDateTime> _getInProgressAtTimestamp() {
        return inProgressAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("completed_at_timestamp")
    private Optional<OffsetDateTime> _getCompletedAtTimestamp() {
        return completedAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("exception_at_timestamp")
    private Optional<OffsetDateTime> _getExceptionAtTimestamp() {
        return exceptionAtTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("order_cancelled_at_timestamp")
    private Optional<OffsetDateTime> _getOrderCancelledAtTimestamp() {
        return orderCancelledAtTimestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Order1 && equalTo((Order1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Order1 other) {
        return schemaVersion == other.schemaVersion
                && id.equals(other.id)
                && shortId.equals(other.shortId)
                && taskGroupIds.equals(other.taskGroupIds)
                && createdByOrgType.equals(other.createdByOrgType)
                && createdByOrgId.equals(other.createdByOrgId)
                && createdByUserId.equals(other.createdByUserId)
                && forwarderOrgId.equals(other.forwarderOrgId)
                && shipperOrgId.equals(other.shipperOrgId)
                && offChrtShipperOrgId.equals(other.offChrtShipperOrgId)
                && status.equals(other.status)
                && draftStartedAtTimestamp.equals(other.draftStartedAtTimestamp)
                && stagedAtTimestamp.equals(other.stagedAtTimestamp)
                && inProgressAtTimestamp.equals(other.inProgressAtTimestamp)
                && completedAtTimestamp.equals(other.completedAtTimestamp)
                && exceptionAtTimestamp.equals(other.exceptionAtTimestamp)
                && orderCancelled.equals(other.orderCancelled)
                && orderCancelledAtTimestamp.equals(other.orderCancelledAtTimestamp);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.id,
                this.shortId,
                this.taskGroupIds,
                this.createdByOrgType,
                this.createdByOrgId,
                this.createdByUserId,
                this.forwarderOrgId,
                this.shipperOrgId,
                this.offChrtShipperOrgId,
                this.status,
                this.draftStartedAtTimestamp,
                this.stagedAtTimestamp,
                this.inProgressAtTimestamp,
                this.completedAtTimestamp,
                this.exceptionAtTimestamp,
                this.orderCancelled,
                this.orderCancelledAtTimestamp);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        IdStage schemaVersion(int schemaVersion);

        Builder from(Order1 other);
    }

    public interface IdStage {
        ShortIdStage id(@NotNull String id);
    }

    public interface ShortIdStage {
        CreatedByOrgTypeStage shortId(@NotNull String shortId);
    }

    public interface CreatedByOrgTypeStage {
        CreatedByOrgIdStage createdByOrgType(@NotNull OrgTypeEnum createdByOrgType);
    }

    public interface CreatedByOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId);
    }

    public interface CreatedByUserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId);
    }

    public interface DraftStartedAtTimestampStage {
        _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp);
    }

    public interface _FinalStage {
        Order1 build();

        _FinalStage taskGroupIds(Optional<List<String>> taskGroupIds);

        _FinalStage taskGroupIds(List<String> taskGroupIds);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage forwarderOrgId(Optional<String> forwarderOrgId);

        _FinalStage forwarderOrgId(String forwarderOrgId);

        _FinalStage forwarderOrgId(Nullable<String> forwarderOrgId);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage shipperOrgId(Optional<String> shipperOrgId);

        _FinalStage shipperOrgId(String shipperOrgId);

        _FinalStage shipperOrgId(Nullable<String> shipperOrgId);

        _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId);

        _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId);

        _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId);

        _FinalStage status(Optional<OrderStatusEnum1> status);

        _FinalStage status(OrderStatusEnum1 status);

        _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp);

        _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp);

        _FinalStage inProgressAtTimestamp(Optional<OffsetDateTime> inProgressAtTimestamp);

        _FinalStage inProgressAtTimestamp(OffsetDateTime inProgressAtTimestamp);

        _FinalStage inProgressAtTimestamp(Nullable<OffsetDateTime> inProgressAtTimestamp);

        _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp);

        _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp);

        _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp);

        _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp);

        _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp);

        _FinalStage orderCancelled(Optional<Boolean> orderCancelled);

        _FinalStage orderCancelled(Boolean orderCancelled);

        _FinalStage orderCancelledAtTimestamp(Optional<OffsetDateTime> orderCancelledAtTimestamp);

        _FinalStage orderCancelledAtTimestamp(OffsetDateTime orderCancelledAtTimestamp);

        _FinalStage orderCancelledAtTimestamp(Nullable<OffsetDateTime> orderCancelledAtTimestamp);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    IdStage,
                    ShortIdStage,
                    CreatedByOrgTypeStage,
                    CreatedByOrgIdStage,
                    CreatedByUserIdStage,
                    DraftStartedAtTimestampStage,
                    _FinalStage {
        private int schemaVersion;

        private String id;

        private String shortId;

        private OrgTypeEnum createdByOrgType;

        private String createdByOrgId;

        private String createdByUserId;

        private OffsetDateTime draftStartedAtTimestamp;

        private Optional<OffsetDateTime> orderCancelledAtTimestamp = Optional.empty();

        private Optional<Boolean> orderCancelled = Optional.empty();

        private Optional<OffsetDateTime> exceptionAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> completedAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> inProgressAtTimestamp = Optional.empty();

        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();

        private Optional<OrderStatusEnum1> status = Optional.empty();

        private Optional<String> offChrtShipperOrgId = Optional.empty();

        private Optional<String> shipperOrgId = Optional.empty();

        private Optional<String> forwarderOrgId = Optional.empty();

        private Optional<List<String>> taskGroupIds = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Order1 other) {
            schemaVersion(other.getSchemaVersion());
            id(other.getId());
            shortId(other.getShortId());
            taskGroupIds(other.getTaskGroupIds());
            createdByOrgType(other.getCreatedByOrgType());
            createdByOrgId(other.getCreatedByOrgId());
            createdByUserId(other.getCreatedByUserId());
            forwarderOrgId(other.getForwarderOrgId());
            shipperOrgId(other.getShipperOrgId());
            offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            status(other.getStatus());
            draftStartedAtTimestamp(other.getDraftStartedAtTimestamp());
            stagedAtTimestamp(other.getStagedAtTimestamp());
            inProgressAtTimestamp(other.getInProgressAtTimestamp());
            completedAtTimestamp(other.getCompletedAtTimestamp());
            exceptionAtTimestamp(other.getExceptionAtTimestamp());
            orderCancelled(other.getOrderCancelled());
            orderCancelledAtTimestamp(other.getOrderCancelledAtTimestamp());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public ShortIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("short_id")
        public CreatedByOrgTypeStage shortId(@NotNull String shortId) {
            this.shortId = Objects.requireNonNull(shortId, "shortId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_by_org_type")
        public CreatedByOrgIdStage createdByOrgType(@NotNull OrgTypeEnum createdByOrgType) {
            this.createdByOrgType = Objects.requireNonNull(createdByOrgType, "createdByOrgType must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_by_user_id")
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("draft_started_at_timestamp")
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp) {
            this.draftStartedAtTimestamp =
                    Objects.requireNonNull(draftStartedAtTimestamp, "draftStartedAtTimestamp must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage orderCancelledAtTimestamp(Nullable<OffsetDateTime> orderCancelledAtTimestamp) {
            if (orderCancelledAtTimestamp.isNull()) {
                this.orderCancelledAtTimestamp = null;
            } else if (orderCancelledAtTimestamp.isEmpty()) {
                this.orderCancelledAtTimestamp = Optional.empty();
            } else {
                this.orderCancelledAtTimestamp = Optional.of(orderCancelledAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage orderCancelledAtTimestamp(OffsetDateTime orderCancelledAtTimestamp) {
            this.orderCancelledAtTimestamp = Optional.ofNullable(orderCancelledAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "order_cancelled_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage orderCancelledAtTimestamp(Optional<OffsetDateTime> orderCancelledAtTimestamp) {
            this.orderCancelledAtTimestamp = orderCancelledAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage orderCancelled(Boolean orderCancelled) {
            this.orderCancelled = Optional.ofNullable(orderCancelled);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "order_cancelled", nulls = Nulls.SKIP)
        public _FinalStage orderCancelled(Optional<Boolean> orderCancelled) {
            this.orderCancelled = orderCancelled;
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp) {
            if (exceptionAtTimestamp.isNull()) {
                this.exceptionAtTimestamp = null;
            } else if (exceptionAtTimestamp.isEmpty()) {
                this.exceptionAtTimestamp = Optional.empty();
            } else {
                this.exceptionAtTimestamp = Optional.of(exceptionAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp) {
            this.exceptionAtTimestamp = Optional.ofNullable(exceptionAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "exception_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp) {
            if (completedAtTimestamp.isNull()) {
                this.completedAtTimestamp = null;
            } else if (completedAtTimestamp.isEmpty()) {
                this.completedAtTimestamp = Optional.empty();
            } else {
                this.completedAtTimestamp = Optional.of(completedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp) {
            this.completedAtTimestamp = Optional.ofNullable(completedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "completed_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage inProgressAtTimestamp(Nullable<OffsetDateTime> inProgressAtTimestamp) {
            if (inProgressAtTimestamp.isNull()) {
                this.inProgressAtTimestamp = null;
            } else if (inProgressAtTimestamp.isEmpty()) {
                this.inProgressAtTimestamp = Optional.empty();
            } else {
                this.inProgressAtTimestamp = Optional.of(inProgressAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage inProgressAtTimestamp(OffsetDateTime inProgressAtTimestamp) {
            this.inProgressAtTimestamp = Optional.ofNullable(inProgressAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "in_progress_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage inProgressAtTimestamp(Optional<OffsetDateTime> inProgressAtTimestamp) {
            this.inProgressAtTimestamp = inProgressAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            if (stagedAtTimestamp.isNull()) {
                this.stagedAtTimestamp = null;
            } else if (stagedAtTimestamp.isEmpty()) {
                this.stagedAtTimestamp = Optional.empty();
            } else {
                this.stagedAtTimestamp = Optional.of(stagedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "staged_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(OrderStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<OrderStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            if (offChrtShipperOrgId.isNull()) {
                this.offChrtShipperOrgId = null;
            } else if (offChrtShipperOrgId.isEmpty()) {
                this.offChrtShipperOrgId = Optional.empty();
            } else {
                this.offChrtShipperOrgId = Optional.of(offChrtShipperOrgId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "off_chrt_shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperOrgId(Nullable<String> shipperOrgId) {
            if (shipperOrgId.isNull()) {
                this.shipperOrgId = null;
            } else if (shipperOrgId.isEmpty()) {
                this.shipperOrgId = Optional.empty();
            } else {
                this.shipperOrgId = Optional.of(shipperOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage forwarderOrgId(Nullable<String> forwarderOrgId) {
            if (forwarderOrgId.isNull()) {
                this.forwarderOrgId = null;
            } else if (forwarderOrgId.isEmpty()) {
                this.forwarderOrgId = Optional.empty();
            } else {
                this.forwarderOrgId = Optional.of(forwarderOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage forwarderOrgId(String forwarderOrgId) {
            this.forwarderOrgId = Optional.ofNullable(forwarderOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "forwarder_org_id", nulls = Nulls.SKIP)
        public _FinalStage forwarderOrgId(Optional<String> forwarderOrgId) {
            this.forwarderOrgId = forwarderOrgId;
            return this;
        }

        @java.lang.Override
        public _FinalStage taskGroupIds(List<String> taskGroupIds) {
            this.taskGroupIds = Optional.ofNullable(taskGroupIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_group_ids", nulls = Nulls.SKIP)
        public _FinalStage taskGroupIds(Optional<List<String>> taskGroupIds) {
            this.taskGroupIds = taskGroupIds;
            return this;
        }

        @java.lang.Override
        public Order1 build() {
            return new Order1(
                    schemaVersion,
                    id,
                    shortId,
                    taskGroupIds,
                    createdByOrgType,
                    createdByOrgId,
                    createdByUserId,
                    forwarderOrgId,
                    shipperOrgId,
                    offChrtShipperOrgId,
                    status,
                    draftStartedAtTimestamp,
                    stagedAtTimestamp,
                    inProgressAtTimestamp,
                    completedAtTimestamp,
                    exceptionAtTimestamp,
                    orderCancelled,
                    orderCancelledAtTimestamp,
                    additionalProperties);
        }
    }
}
