/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrdersNewDraftRes.Builder.class)
public final class OrdersNewDraftRes {
    private final String orderId;

    private final String orderShortId;

    private final Map<String, Object> additionalProperties;

    private OrdersNewDraftRes(String orderId, String orderShortId, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.orderShortId = orderShortId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("order_id")
    public String getOrderId() {
        return orderId;
    }

    @JsonProperty("order_short_id")
    public String getOrderShortId() {
        return orderShortId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrdersNewDraftRes && equalTo((OrdersNewDraftRes) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrdersNewDraftRes other) {
        return orderId.equals(other.orderId) && orderShortId.equals(other.orderShortId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.orderId, this.orderShortId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    public interface OrderIdStage {
        OrderShortIdStage orderId(@NotNull String orderId);

        Builder from(OrdersNewDraftRes other);
    }

    public interface OrderShortIdStage {
        _FinalStage orderShortId(@NotNull String orderShortId);
    }

    public interface _FinalStage {
        OrdersNewDraftRes build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OrderIdStage, OrderShortIdStage, _FinalStage {
        private String orderId;

        private String orderShortId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrdersNewDraftRes other) {
            orderId(other.getOrderId());
            orderShortId(other.getOrderShortId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_id")
        public OrderShortIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_short_id")
        public _FinalStage orderShortId(@NotNull String orderShortId) {
            this.orderShortId = Objects.requireNonNull(orderShortId, "orderShortId must not be null");
            return this;
        }

        @java.lang.Override
        public OrdersNewDraftRes build() {
            return new OrdersNewDraftRes(orderId, orderShortId, additionalProperties);
        }
    }
}
