/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrgMembersAndDrivers.Builder.class)
public final class OrgMembersAndDrivers {
    private final OrgMemberDetails orgMember;

    private final Optional<Driver1> driver;

    private final Map<String, Object> additionalProperties;

    private OrgMembersAndDrivers(
            OrgMemberDetails orgMember, Optional<Driver1> driver, Map<String, Object> additionalProperties) {
        this.orgMember = orgMember;
        this.driver = driver;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("org_member")
    public OrgMemberDetails getOrgMember() {
        return orgMember;
    }

    @JsonIgnore
    public Optional<Driver1> getDriver() {
        if (driver == null) {
            return Optional.empty();
        }
        return driver;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("driver")
    private Optional<Driver1> _getDriver() {
        return driver;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrgMembersAndDrivers && equalTo((OrgMembersAndDrivers) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrgMembersAndDrivers other) {
        return orgMember.equals(other.orgMember) && driver.equals(other.driver);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.orgMember, this.driver);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrgMemberStage builder() {
        return new Builder();
    }

    public interface OrgMemberStage {
        _FinalStage orgMember(@NotNull OrgMemberDetails orgMember);

        Builder from(OrgMembersAndDrivers other);
    }

    public interface _FinalStage {
        OrgMembersAndDrivers build();

        _FinalStage driver(Optional<Driver1> driver);

        _FinalStage driver(Driver1 driver);

        _FinalStage driver(Nullable<Driver1> driver);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OrgMemberStage, _FinalStage {
        private OrgMemberDetails orgMember;

        private Optional<Driver1> driver = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrgMembersAndDrivers other) {
            orgMember(other.getOrgMember());
            driver(other.getDriver());
            return this;
        }

        @java.lang.Override
        @JsonSetter("org_member")
        public _FinalStage orgMember(@NotNull OrgMemberDetails orgMember) {
            this.orgMember = Objects.requireNonNull(orgMember, "orgMember must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage driver(Nullable<Driver1> driver) {
            if (driver.isNull()) {
                this.driver = null;
            } else if (driver.isEmpty()) {
                this.driver = Optional.empty();
            } else {
                this.driver = Optional.of(driver.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage driver(Driver1 driver) {
            this.driver = Optional.ofNullable(driver);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "driver", nulls = Nulls.SKIP)
        public _FinalStage driver(Optional<Driver1> driver) {
            this.driver = driver;
            return this;
        }

        @java.lang.Override
        public OrgMembersAndDrivers build() {
            return new OrgMembersAndDrivers(orgMember, driver, additionalProperties);
        }
    }
}
