/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Session1.Builder.class)
public final class Session1 {
    private final int schemaVersion;

    private final String deviceId;

    private final String deviceMacAddress;

    private final String orgId;

    private final Optional<String> comments;

    private final Optional<Boolean> recording;

    private final Optional<Boolean> terminated;

    private final OffsetDateTime sessionCreatedAtTimestamp;

    private final Optional<OffsetDateTime> recordingInitiatedAtTimestamp;

    private final Optional<Boolean> public_;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private Session1(
            int schemaVersion,
            String deviceId,
            String deviceMacAddress,
            String orgId,
            Optional<String> comments,
            Optional<Boolean> recording,
            Optional<Boolean> terminated,
            OffsetDateTime sessionCreatedAtTimestamp,
            Optional<OffsetDateTime> recordingInitiatedAtTimestamp,
            Optional<Boolean> public_,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.deviceId = deviceId;
        this.deviceMacAddress = deviceMacAddress;
        this.orgId = orgId;
        this.comments = comments;
        this.recording = recording;
        this.terminated = terminated;
        this.sessionCreatedAtTimestamp = sessionCreatedAtTimestamp;
        this.recordingInitiatedAtTimestamp = recordingInitiatedAtTimestamp;
        this.public_ = public_;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("device_id")
    public String getDeviceId() {
        return deviceId;
    }

    @JsonProperty("device_mac_address")
    public String getDeviceMacAddress() {
        return deviceMacAddress;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("org_id")
    public String getOrgId() {
        return orgId;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (comments == null) {
            return Optional.empty();
        }
        return comments;
    }

    @JsonProperty("recording")
    public Optional<Boolean> getRecording() {
        return recording;
    }

    @JsonProperty("terminated")
    public Optional<Boolean> getTerminated() {
        return terminated;
    }

    @JsonProperty("session_created_at_timestamp")
    public OffsetDateTime getSessionCreatedAtTimestamp() {
        return sessionCreatedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getRecordingInitiatedAtTimestamp() {
        if (recordingInitiatedAtTimestamp == null) {
            return Optional.empty();
        }
        return recordingInitiatedAtTimestamp;
    }

    @JsonProperty("public")
    public Optional<Boolean> getPublic() {
        return public_;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comments")
    private Optional<String> _getComments() {
        return comments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("recording_initiated_at_timestamp")
    private Optional<OffsetDateTime> _getRecordingInitiatedAtTimestamp() {
        return recordingInitiatedAtTimestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Session1 && equalTo((Session1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Session1 other) {
        return schemaVersion == other.schemaVersion
                && deviceId.equals(other.deviceId)
                && deviceMacAddress.equals(other.deviceMacAddress)
                && orgId.equals(other.orgId)
                && comments.equals(other.comments)
                && recording.equals(other.recording)
                && terminated.equals(other.terminated)
                && sessionCreatedAtTimestamp.equals(other.sessionCreatedAtTimestamp)
                && recordingInitiatedAtTimestamp.equals(other.recordingInitiatedAtTimestamp)
                && public_.equals(other.public_)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.deviceId,
                this.deviceMacAddress,
                this.orgId,
                this.comments,
                this.recording,
                this.terminated,
                this.sessionCreatedAtTimestamp,
                this.recordingInitiatedAtTimestamp,
                this.public_,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        DeviceIdStage schemaVersion(int schemaVersion);

        Builder from(Session1 other);
    }

    public interface DeviceIdStage {
        DeviceMacAddressStage deviceId(@NotNull String deviceId);
    }

    public interface DeviceMacAddressStage {
        OrgIdStage deviceMacAddress(@NotNull String deviceMacAddress);
    }

    public interface OrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        SessionCreatedAtTimestampStage orgId(@NotNull String orgId);
    }

    public interface SessionCreatedAtTimestampStage {
        IdStage sessionCreatedAtTimestamp(@NotNull OffsetDateTime sessionCreatedAtTimestamp);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        Session1 build();

        _FinalStage comments(Optional<String> comments);

        _FinalStage comments(String comments);

        _FinalStage comments(Nullable<String> comments);

        _FinalStage recording(Optional<Boolean> recording);

        _FinalStage recording(Boolean recording);

        _FinalStage terminated(Optional<Boolean> terminated);

        _FinalStage terminated(Boolean terminated);

        _FinalStage recordingInitiatedAtTimestamp(Optional<OffsetDateTime> recordingInitiatedAtTimestamp);

        _FinalStage recordingInitiatedAtTimestamp(OffsetDateTime recordingInitiatedAtTimestamp);

        _FinalStage recordingInitiatedAtTimestamp(Nullable<OffsetDateTime> recordingInitiatedAtTimestamp);

        _FinalStage public_(Optional<Boolean> public_);

        _FinalStage public_(Boolean public_);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    DeviceIdStage,
                    DeviceMacAddressStage,
                    OrgIdStage,
                    SessionCreatedAtTimestampStage,
                    IdStage,
                    _FinalStage {
        private int schemaVersion;

        private String deviceId;

        private String deviceMacAddress;

        private String orgId;

        private OffsetDateTime sessionCreatedAtTimestamp;

        private String id;

        private Optional<Boolean> public_ = Optional.empty();

        private Optional<OffsetDateTime> recordingInitiatedAtTimestamp = Optional.empty();

        private Optional<Boolean> terminated = Optional.empty();

        private Optional<Boolean> recording = Optional.empty();

        private Optional<String> comments = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Session1 other) {
            schemaVersion(other.getSchemaVersion());
            deviceId(other.getDeviceId());
            deviceMacAddress(other.getDeviceMacAddress());
            orgId(other.getOrgId());
            comments(other.getComments());
            recording(other.getRecording());
            terminated(other.getTerminated());
            sessionCreatedAtTimestamp(other.getSessionCreatedAtTimestamp());
            recordingInitiatedAtTimestamp(other.getRecordingInitiatedAtTimestamp());
            public_(other.getPublic());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public DeviceIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("device_id")
        public DeviceMacAddressStage deviceId(@NotNull String deviceId) {
            this.deviceId = Objects.requireNonNull(deviceId, "deviceId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("device_mac_address")
        public OrgIdStage deviceMacAddress(@NotNull String deviceMacAddress) {
            this.deviceMacAddress = Objects.requireNonNull(deviceMacAddress, "deviceMacAddress must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("org_id")
        public SessionCreatedAtTimestampStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("session_created_at_timestamp")
        public IdStage sessionCreatedAtTimestamp(@NotNull OffsetDateTime sessionCreatedAtTimestamp) {
            this.sessionCreatedAtTimestamp =
                    Objects.requireNonNull(sessionCreatedAtTimestamp, "sessionCreatedAtTimestamp must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage public_(Boolean public_) {
            this.public_ = Optional.ofNullable(public_);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "public", nulls = Nulls.SKIP)
        public _FinalStage public_(Optional<Boolean> public_) {
            this.public_ = public_;
            return this;
        }

        @java.lang.Override
        public _FinalStage recordingInitiatedAtTimestamp(Nullable<OffsetDateTime> recordingInitiatedAtTimestamp) {
            if (recordingInitiatedAtTimestamp.isNull()) {
                this.recordingInitiatedAtTimestamp = null;
            } else if (recordingInitiatedAtTimestamp.isEmpty()) {
                this.recordingInitiatedAtTimestamp = Optional.empty();
            } else {
                this.recordingInitiatedAtTimestamp = Optional.of(recordingInitiatedAtTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage recordingInitiatedAtTimestamp(OffsetDateTime recordingInitiatedAtTimestamp) {
            this.recordingInitiatedAtTimestamp = Optional.ofNullable(recordingInitiatedAtTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "recording_initiated_at_timestamp", nulls = Nulls.SKIP)
        public _FinalStage recordingInitiatedAtTimestamp(Optional<OffsetDateTime> recordingInitiatedAtTimestamp) {
            this.recordingInitiatedAtTimestamp = recordingInitiatedAtTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage terminated(Boolean terminated) {
            this.terminated = Optional.ofNullable(terminated);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "terminated", nulls = Nulls.SKIP)
        public _FinalStage terminated(Optional<Boolean> terminated) {
            this.terminated = terminated;
            return this;
        }

        @java.lang.Override
        public _FinalStage recording(Boolean recording) {
            this.recording = Optional.ofNullable(recording);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "recording", nulls = Nulls.SKIP)
        public _FinalStage recording(Optional<Boolean> recording) {
            this.recording = recording;
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(Nullable<String> comments) {
            if (comments.isNull()) {
                this.comments = null;
            } else if (comments.isEmpty()) {
                this.comments = Optional.empty();
            } else {
                this.comments = Optional.of(comments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "comments", nulls = Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @java.lang.Override
        public Session1 build() {
            return new Session1(
                    schemaVersion,
                    deviceId,
                    deviceMacAddress,
                    orgId,
                    comments,
                    recording,
                    terminated,
                    sessionCreatedAtTimestamp,
                    recordingInitiatedAtTimestamp,
                    public_,
                    id,
                    additionalProperties);
        }
    }
}
