/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ShipperForwarderConnection1.Builder.class)
public final class ShipperForwarderConnection1 {
    private final int schemaVersion;

    private final String shipperOrgId;

    private final String forwarderOrgId;

    private final Optional<Boolean> connected;

    private final Optional<String> shipperCustomerIdForForwarderStripeConnectAccount;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private ShipperForwarderConnection1(
            int schemaVersion,
            String shipperOrgId,
            String forwarderOrgId,
            Optional<Boolean> connected,
            Optional<String> shipperCustomerIdForForwarderStripeConnectAccount,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.shipperOrgId = shipperOrgId;
        this.forwarderOrgId = forwarderOrgId;
        this.connected = connected;
        this.shipperCustomerIdForForwarderStripeConnectAccount = shipperCustomerIdForForwarderStripeConnectAccount;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("shipper_org_id")
    public String getShipperOrgId() {
        return shipperOrgId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("forwarder_org_id")
    public String getForwarderOrgId() {
        return forwarderOrgId;
    }

    @JsonProperty("connected")
    public Optional<Boolean> getConnected() {
        return connected;
    }

    @JsonIgnore
    public Optional<String> getShipperCustomerIdForForwarderStripeConnectAccount() {
        if (shipperCustomerIdForForwarderStripeConnectAccount == null) {
            return Optional.empty();
        }
        return shipperCustomerIdForForwarderStripeConnectAccount;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_customer_id_for_forwarder_stripe_connect_account")
    private Optional<String> _getShipperCustomerIdForForwarderStripeConnectAccount() {
        return shipperCustomerIdForForwarderStripeConnectAccount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ShipperForwarderConnection1 && equalTo((ShipperForwarderConnection1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperForwarderConnection1 other) {
        return schemaVersion == other.schemaVersion
                && shipperOrgId.equals(other.shipperOrgId)
                && forwarderOrgId.equals(other.forwarderOrgId)
                && connected.equals(other.connected)
                && shipperCustomerIdForForwarderStripeConnectAccount.equals(
                        other.shipperCustomerIdForForwarderStripeConnectAccount)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.shipperOrgId,
                this.forwarderOrgId,
                this.connected,
                this.shipperCustomerIdForForwarderStripeConnectAccount,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        ShipperOrgIdStage schemaVersion(int schemaVersion);

        Builder from(ShipperForwarderConnection1 other);
    }

    public interface ShipperOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        ForwarderOrgIdStage shipperOrgId(@NotNull String shipperOrgId);
    }

    public interface ForwarderOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        IdStage forwarderOrgId(@NotNull String forwarderOrgId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        ShipperForwarderConnection1 build();

        _FinalStage connected(Optional<Boolean> connected);

        _FinalStage connected(Boolean connected);

        _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(
                Optional<String> shipperCustomerIdForForwarderStripeConnectAccount);

        _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(
                String shipperCustomerIdForForwarderStripeConnectAccount);

        _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(
                Nullable<String> shipperCustomerIdForForwarderStripeConnectAccount);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage, ShipperOrgIdStage, ForwarderOrgIdStage, IdStage, _FinalStage {
        private int schemaVersion;

        private String shipperOrgId;

        private String forwarderOrgId;

        private String id;

        private Optional<String> shipperCustomerIdForForwarderStripeConnectAccount = Optional.empty();

        private Optional<Boolean> connected = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ShipperForwarderConnection1 other) {
            schemaVersion(other.getSchemaVersion());
            shipperOrgId(other.getShipperOrgId());
            forwarderOrgId(other.getForwarderOrgId());
            connected(other.getConnected());
            shipperCustomerIdForForwarderStripeConnectAccount(
                    other.getShipperCustomerIdForForwarderStripeConnectAccount());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public ShipperOrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("shipper_org_id")
        public ForwarderOrgIdStage shipperOrgId(@NotNull String shipperOrgId) {
            this.shipperOrgId = Objects.requireNonNull(shipperOrgId, "shipperOrgId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("forwarder_org_id")
        public IdStage forwarderOrgId(@NotNull String forwarderOrgId) {
            this.forwarderOrgId = Objects.requireNonNull(forwarderOrgId, "forwarderOrgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(
                Nullable<String> shipperCustomerIdForForwarderStripeConnectAccount) {
            if (shipperCustomerIdForForwarderStripeConnectAccount.isNull()) {
                this.shipperCustomerIdForForwarderStripeConnectAccount = null;
            } else if (shipperCustomerIdForForwarderStripeConnectAccount.isEmpty()) {
                this.shipperCustomerIdForForwarderStripeConnectAccount = Optional.empty();
            } else {
                this.shipperCustomerIdForForwarderStripeConnectAccount =
                        Optional.of(shipperCustomerIdForForwarderStripeConnectAccount.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(
                String shipperCustomerIdForForwarderStripeConnectAccount) {
            this.shipperCustomerIdForForwarderStripeConnectAccount =
                    Optional.ofNullable(shipperCustomerIdForForwarderStripeConnectAccount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_customer_id_for_forwarder_stripe_connect_account", nulls = Nulls.SKIP)
        public _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(
                Optional<String> shipperCustomerIdForForwarderStripeConnectAccount) {
            this.shipperCustomerIdForForwarderStripeConnectAccount = shipperCustomerIdForForwarderStripeConnectAccount;
            return this;
        }

        @java.lang.Override
        public _FinalStage connected(Boolean connected) {
            this.connected = Optional.ofNullable(connected);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "connected", nulls = Nulls.SKIP)
        public _FinalStage connected(Optional<Boolean> connected) {
            this.connected = connected;
            return this;
        }

        @java.lang.Override
        public ShipperForwarderConnection1 build() {
            return new ShipperForwarderConnection1(
                    schemaVersion,
                    shipperOrgId,
                    forwarderOrgId,
                    connected,
                    shipperCustomerIdForForwarderStripeConnectAccount,
                    id,
                    additionalProperties);
        }
    }
}
