/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ShipperPayCourierLineItemGroup1.Builder.class)
public final class ShipperPayCourierLineItemGroup1 {
    private final int schemaVersion;

    private final String taskGroupId;

    private final String courierOrgId;

    private final Optional<String> shipperOrgId;

    private final Optional<String> offChrtShipperOrgId;

    private final Optional<Boolean> orderCancelled;

    private final String rateSheetId;

    private final List<LineItem1> lineItems;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private ShipperPayCourierLineItemGroup1(
            int schemaVersion,
            String taskGroupId,
            String courierOrgId,
            Optional<String> shipperOrgId,
            Optional<String> offChrtShipperOrgId,
            Optional<Boolean> orderCancelled,
            String rateSheetId,
            List<LineItem1> lineItems,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.taskGroupId = taskGroupId;
        this.courierOrgId = courierOrgId;
        this.shipperOrgId = shipperOrgId;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.orderCancelled = orderCancelled;
        this.rateSheetId = rateSheetId;
        this.lineItems = lineItems;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("courier_org_id")
    public String getCourierOrgId() {
        return courierOrgId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (shipperOrgId == null) {
            return Optional.empty();
        }
        return shipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return offChrtShipperOrgId;
    }

    @JsonProperty("order_cancelled")
    public Optional<Boolean> getOrderCancelled() {
        return orderCancelled;
    }

    @JsonProperty("rate_sheet_id")
    public String getRateSheetId() {
        return rateSheetId;
    }

    @JsonProperty("line_items")
    public List<LineItem1> getLineItems() {
        return lineItems;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return shipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return offChrtShipperOrgId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ShipperPayCourierLineItemGroup1 && equalTo((ShipperPayCourierLineItemGroup1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperPayCourierLineItemGroup1 other) {
        return schemaVersion == other.schemaVersion
                && taskGroupId.equals(other.taskGroupId)
                && courierOrgId.equals(other.courierOrgId)
                && shipperOrgId.equals(other.shipperOrgId)
                && offChrtShipperOrgId.equals(other.offChrtShipperOrgId)
                && orderCancelled.equals(other.orderCancelled)
                && rateSheetId.equals(other.rateSheetId)
                && lineItems.equals(other.lineItems)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.taskGroupId,
                this.courierOrgId,
                this.shipperOrgId,
                this.offChrtShipperOrgId,
                this.orderCancelled,
                this.rateSheetId,
                this.lineItems,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        TaskGroupIdStage schemaVersion(int schemaVersion);

        Builder from(ShipperPayCourierLineItemGroup1 other);
    }

    public interface TaskGroupIdStage {
        CourierOrgIdStage taskGroupId(@NotNull String taskGroupId);
    }

    public interface CourierOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        RateSheetIdStage courierOrgId(@NotNull String courierOrgId);
    }

    public interface RateSheetIdStage {
        IdStage rateSheetId(@NotNull String rateSheetId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        ShipperPayCourierLineItemGroup1 build();

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage shipperOrgId(Optional<String> shipperOrgId);

        _FinalStage shipperOrgId(String shipperOrgId);

        _FinalStage shipperOrgId(Nullable<String> shipperOrgId);

        _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId);

        _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId);

        _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId);

        _FinalStage orderCancelled(Optional<Boolean> orderCancelled);

        _FinalStage orderCancelled(Boolean orderCancelled);

        _FinalStage lineItems(List<LineItem1> lineItems);

        _FinalStage addLineItems(LineItem1 lineItems);

        _FinalStage addAllLineItems(List<LineItem1> lineItems);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage, TaskGroupIdStage, CourierOrgIdStage, RateSheetIdStage, IdStage, _FinalStage {
        private int schemaVersion;

        private String taskGroupId;

        private String courierOrgId;

        private String rateSheetId;

        private String id;

        private List<LineItem1> lineItems = new ArrayList<>();

        private Optional<Boolean> orderCancelled = Optional.empty();

        private Optional<String> offChrtShipperOrgId = Optional.empty();

        private Optional<String> shipperOrgId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ShipperPayCourierLineItemGroup1 other) {
            schemaVersion(other.getSchemaVersion());
            taskGroupId(other.getTaskGroupId());
            courierOrgId(other.getCourierOrgId());
            shipperOrgId(other.getShipperOrgId());
            offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            orderCancelled(other.getOrderCancelled());
            rateSheetId(other.getRateSheetId());
            lineItems(other.getLineItems());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public TaskGroupIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public CourierOrgIdStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("courier_org_id")
        public RateSheetIdStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("rate_sheet_id")
        public IdStage rateSheetId(@NotNull String rateSheetId) {
            this.rateSheetId = Objects.requireNonNull(rateSheetId, "rateSheetId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllLineItems(List<LineItem1> lineItems) {
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addLineItems(LineItem1 lineItems) {
            this.lineItems.add(lineItems);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "line_items", nulls = Nulls.SKIP)
        public _FinalStage lineItems(List<LineItem1> lineItems) {
            this.lineItems.clear();
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage orderCancelled(Boolean orderCancelled) {
            this.orderCancelled = Optional.ofNullable(orderCancelled);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "order_cancelled", nulls = Nulls.SKIP)
        public _FinalStage orderCancelled(Optional<Boolean> orderCancelled) {
            this.orderCancelled = orderCancelled;
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            if (offChrtShipperOrgId.isNull()) {
                this.offChrtShipperOrgId = null;
            } else if (offChrtShipperOrgId.isEmpty()) {
                this.offChrtShipperOrgId = Optional.empty();
            } else {
                this.offChrtShipperOrgId = Optional.of(offChrtShipperOrgId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "off_chrt_shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperOrgId(Nullable<String> shipperOrgId) {
            if (shipperOrgId.isNull()) {
                this.shipperOrgId = null;
            } else if (shipperOrgId.isEmpty()) {
                this.shipperOrgId = Optional.empty();
            } else {
                this.shipperOrgId = Optional.of(shipperOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        @java.lang.Override
        public ShipperPayCourierLineItemGroup1 build() {
            return new ShipperPayCourierLineItemGroup1(
                    schemaVersion,
                    taskGroupId,
                    courierOrgId,
                    shipperOrgId,
                    offChrtShipperOrgId,
                    orderCancelled,
                    rateSheetId,
                    lineItems,
                    id,
                    additionalProperties);
        }
    }
}
