/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ShipperPayCourierLineItemGroupCreateReq.Builder.class)
public final class ShipperPayCourierLineItemGroupCreateReq {
    private final String shipperPayCourierRateSheetId;

    private final String taskGroupId;

    private final Optional<Boolean> dangerousGoods;

    private final Optional<Boolean> holiday;

    private final Optional<Boolean> weekend;

    private final Optional<Boolean> afterHours;

    private final Map<String, Object> additionalProperties;

    private ShipperPayCourierLineItemGroupCreateReq(
            String shipperPayCourierRateSheetId,
            String taskGroupId,
            Optional<Boolean> dangerousGoods,
            Optional<Boolean> holiday,
            Optional<Boolean> weekend,
            Optional<Boolean> afterHours,
            Map<String, Object> additionalProperties) {
        this.shipperPayCourierRateSheetId = shipperPayCourierRateSheetId;
        this.taskGroupId = taskGroupId;
        this.dangerousGoods = dangerousGoods;
        this.holiday = holiday;
        this.weekend = weekend;
        this.afterHours = afterHours;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return ID of the shipper pay courier rate sheet
     */
    @JsonProperty("shipper_pay_courier_rate_sheet_id")
    public String getShipperPayCourierRateSheetId() {
        return shipperPayCourierRateSheetId;
    }

    /**
     * @return ID of the task group
     */
    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    /**
     * @return Whether the shipment contains dangerous goods
     */
    @JsonProperty("dangerous_goods")
    public Optional<Boolean> getDangerousGoods() {
        return dangerousGoods;
    }

    /**
     * @return Whether the delivery is on a holiday
     */
    @JsonProperty("holiday")
    public Optional<Boolean> getHoliday() {
        return holiday;
    }

    /**
     * @return Whether the delivery is on a weekend
     */
    @JsonProperty("weekend")
    public Optional<Boolean> getWeekend() {
        return weekend;
    }

    /**
     * @return Whether the delivery is after hours
     */
    @JsonProperty("after_hours")
    public Optional<Boolean> getAfterHours() {
        return afterHours;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ShipperPayCourierLineItemGroupCreateReq
                && equalTo((ShipperPayCourierLineItemGroupCreateReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperPayCourierLineItemGroupCreateReq other) {
        return shipperPayCourierRateSheetId.equals(other.shipperPayCourierRateSheetId)
                && taskGroupId.equals(other.taskGroupId)
                && dangerousGoods.equals(other.dangerousGoods)
                && holiday.equals(other.holiday)
                && weekend.equals(other.weekend)
                && afterHours.equals(other.afterHours);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.shipperPayCourierRateSheetId,
                this.taskGroupId,
                this.dangerousGoods,
                this.holiday,
                this.weekend,
                this.afterHours);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ShipperPayCourierRateSheetIdStage builder() {
        return new Builder();
    }

    public interface ShipperPayCourierRateSheetIdStage {
        /**
         * <p>ID of the shipper pay courier rate sheet</p>
         */
        TaskGroupIdStage shipperPayCourierRateSheetId(@NotNull String shipperPayCourierRateSheetId);

        Builder from(ShipperPayCourierLineItemGroupCreateReq other);
    }

    public interface TaskGroupIdStage {
        /**
         * <p>ID of the task group</p>
         */
        _FinalStage taskGroupId(@NotNull String taskGroupId);
    }

    public interface _FinalStage {
        ShipperPayCourierLineItemGroupCreateReq build();

        /**
         * <p>Whether the shipment contains dangerous goods</p>
         */
        _FinalStage dangerousGoods(Optional<Boolean> dangerousGoods);

        _FinalStage dangerousGoods(Boolean dangerousGoods);

        /**
         * <p>Whether the delivery is on a holiday</p>
         */
        _FinalStage holiday(Optional<Boolean> holiday);

        _FinalStage holiday(Boolean holiday);

        /**
         * <p>Whether the delivery is on a weekend</p>
         */
        _FinalStage weekend(Optional<Boolean> weekend);

        _FinalStage weekend(Boolean weekend);

        /**
         * <p>Whether the delivery is after hours</p>
         */
        _FinalStage afterHours(Optional<Boolean> afterHours);

        _FinalStage afterHours(Boolean afterHours);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ShipperPayCourierRateSheetIdStage, TaskGroupIdStage, _FinalStage {
        private String shipperPayCourierRateSheetId;

        private String taskGroupId;

        private Optional<Boolean> afterHours = Optional.empty();

        private Optional<Boolean> weekend = Optional.empty();

        private Optional<Boolean> holiday = Optional.empty();

        private Optional<Boolean> dangerousGoods = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ShipperPayCourierLineItemGroupCreateReq other) {
            shipperPayCourierRateSheetId(other.getShipperPayCourierRateSheetId());
            taskGroupId(other.getTaskGroupId());
            dangerousGoods(other.getDangerousGoods());
            holiday(other.getHoliday());
            weekend(other.getWeekend());
            afterHours(other.getAfterHours());
            return this;
        }

        /**
         * <p>ID of the shipper pay courier rate sheet</p>
         * <p>ID of the shipper pay courier rate sheet</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("shipper_pay_courier_rate_sheet_id")
        public TaskGroupIdStage shipperPayCourierRateSheetId(@NotNull String shipperPayCourierRateSheetId) {
            this.shipperPayCourierRateSheetId = Objects.requireNonNull(
                    shipperPayCourierRateSheetId, "shipperPayCourierRateSheetId must not be null");
            return this;
        }

        /**
         * <p>ID of the task group</p>
         * <p>ID of the task group</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("task_group_id")
        public _FinalStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        /**
         * <p>Whether the delivery is after hours</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage afterHours(Boolean afterHours) {
            this.afterHours = Optional.ofNullable(afterHours);
            return this;
        }

        /**
         * <p>Whether the delivery is after hours</p>
         */
        @java.lang.Override
        @JsonSetter(value = "after_hours", nulls = Nulls.SKIP)
        public _FinalStage afterHours(Optional<Boolean> afterHours) {
            this.afterHours = afterHours;
            return this;
        }

        /**
         * <p>Whether the delivery is on a weekend</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage weekend(Boolean weekend) {
            this.weekend = Optional.ofNullable(weekend);
            return this;
        }

        /**
         * <p>Whether the delivery is on a weekend</p>
         */
        @java.lang.Override
        @JsonSetter(value = "weekend", nulls = Nulls.SKIP)
        public _FinalStage weekend(Optional<Boolean> weekend) {
            this.weekend = weekend;
            return this;
        }

        /**
         * <p>Whether the delivery is on a holiday</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage holiday(Boolean holiday) {
            this.holiday = Optional.ofNullable(holiday);
            return this;
        }

        /**
         * <p>Whether the delivery is on a holiday</p>
         */
        @java.lang.Override
        @JsonSetter(value = "holiday", nulls = Nulls.SKIP)
        public _FinalStage holiday(Optional<Boolean> holiday) {
            this.holiday = holiday;
            return this;
        }

        /**
         * <p>Whether the shipment contains dangerous goods</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage dangerousGoods(Boolean dangerousGoods) {
            this.dangerousGoods = Optional.ofNullable(dangerousGoods);
            return this;
        }

        /**
         * <p>Whether the shipment contains dangerous goods</p>
         */
        @java.lang.Override
        @JsonSetter(value = "dangerous_goods", nulls = Nulls.SKIP)
        public _FinalStage dangerousGoods(Optional<Boolean> dangerousGoods) {
            this.dangerousGoods = dangerousGoods;
            return this;
        }

        @java.lang.Override
        public ShipperPayCourierLineItemGroupCreateReq build() {
            return new ShipperPayCourierLineItemGroupCreateReq(
                    shipperPayCourierRateSheetId,
                    taskGroupId,
                    dangerousGoods,
                    holiday,
                    weekend,
                    afterHours,
                    additionalProperties);
        }
    }
}
