/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ShipperPayCourierStatement1.Builder.class)
public final class ShipperPayCourierStatement1 {
    private final int schemaVersion;

    private final List<String> shipperPayCourierLineItemGroupIds;

    private final List<String> taskGroupIds;

    private final Optional<String> offChrtShipperOrgId;

    private final Optional<String> shipperOrgId;

    private final String courierOrgId;

    private final Optional<String> shipperCustomerIdForCourierStripeConnectAccount;

    private final Optional<String> stripeInvoiceId;

    private final Optional<String> stripeInvoiceUrl;

    private final Optional<OffsetDateTime> stripeInvoiceCreatedTimestamp;

    private final Optional<String> stripeInvoiceCreatedByUserId;

    private final double statementAmount;

    private final Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus;

    private final Optional<OffsetDateTime> stripeInvoiceCompletedTimestamp;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private ShipperPayCourierStatement1(
            int schemaVersion,
            List<String> shipperPayCourierLineItemGroupIds,
            List<String> taskGroupIds,
            Optional<String> offChrtShipperOrgId,
            Optional<String> shipperOrgId,
            String courierOrgId,
            Optional<String> shipperCustomerIdForCourierStripeConnectAccount,
            Optional<String> stripeInvoiceId,
            Optional<String> stripeInvoiceUrl,
            Optional<OffsetDateTime> stripeInvoiceCreatedTimestamp,
            Optional<String> stripeInvoiceCreatedByUserId,
            double statementAmount,
            Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus,
            Optional<OffsetDateTime> stripeInvoiceCompletedTimestamp,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.shipperPayCourierLineItemGroupIds = shipperPayCourierLineItemGroupIds;
        this.taskGroupIds = taskGroupIds;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.shipperOrgId = shipperOrgId;
        this.courierOrgId = courierOrgId;
        this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount;
        this.stripeInvoiceId = stripeInvoiceId;
        this.stripeInvoiceUrl = stripeInvoiceUrl;
        this.stripeInvoiceCreatedTimestamp = stripeInvoiceCreatedTimestamp;
        this.stripeInvoiceCreatedByUserId = stripeInvoiceCreatedByUserId;
        this.statementAmount = statementAmount;
        this.stripeInvoiceStatus = stripeInvoiceStatus;
        this.stripeInvoiceCompletedTimestamp = stripeInvoiceCompletedTimestamp;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("shipper_pay_courier_line_item_group_ids")
    public List<String> getShipperPayCourierLineItemGroupIds() {
        return shipperPayCourierLineItemGroupIds;
    }

    @JsonProperty("task_group_ids")
    public List<String> getTaskGroupIds() {
        return taskGroupIds;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return offChrtShipperOrgId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (shipperOrgId == null) {
            return Optional.empty();
        }
        return shipperOrgId;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("courier_org_id")
    public String getCourierOrgId() {
        return courierOrgId;
    }

    @JsonIgnore
    public Optional<String> getShipperCustomerIdForCourierStripeConnectAccount() {
        if (shipperCustomerIdForCourierStripeConnectAccount == null) {
            return Optional.empty();
        }
        return shipperCustomerIdForCourierStripeConnectAccount;
    }

    @JsonIgnore
    public Optional<String> getStripeInvoiceId() {
        if (stripeInvoiceId == null) {
            return Optional.empty();
        }
        return stripeInvoiceId;
    }

    @JsonIgnore
    public Optional<String> getStripeInvoiceUrl() {
        if (stripeInvoiceUrl == null) {
            return Optional.empty();
        }
        return stripeInvoiceUrl;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStripeInvoiceCreatedTimestamp() {
        if (stripeInvoiceCreatedTimestamp == null) {
            return Optional.empty();
        }
        return stripeInvoiceCreatedTimestamp;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonIgnore
    public Optional<String> getStripeInvoiceCreatedByUserId() {
        if (stripeInvoiceCreatedByUserId == null) {
            return Optional.empty();
        }
        return stripeInvoiceCreatedByUserId;
    }

    @JsonProperty("statement_amount")
    public double getStatementAmount() {
        return statementAmount;
    }

    @JsonProperty("stripe_invoice_status")
    public Optional<StripeConnectInvoiceStatusEnum> getStripeInvoiceStatus() {
        return stripeInvoiceStatus;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStripeInvoiceCompletedTimestamp() {
        if (stripeInvoiceCompletedTimestamp == null) {
            return Optional.empty();
        }
        return stripeInvoiceCompletedTimestamp;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return offChrtShipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return shipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_customer_id_for_courier_stripe_connect_account")
    private Optional<String> _getShipperCustomerIdForCourierStripeConnectAccount() {
        return shipperCustomerIdForCourierStripeConnectAccount;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("stripe_invoice_id")
    private Optional<String> _getStripeInvoiceId() {
        return stripeInvoiceId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("stripe_invoice_url")
    private Optional<String> _getStripeInvoiceUrl() {
        return stripeInvoiceUrl;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("stripe_invoice_created_timestamp")
    private Optional<OffsetDateTime> _getStripeInvoiceCreatedTimestamp() {
        return stripeInvoiceCreatedTimestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("stripe_invoice_created_by_user_id")
    private Optional<String> _getStripeInvoiceCreatedByUserId() {
        return stripeInvoiceCreatedByUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("stripe_invoice_completed_timestamp")
    private Optional<OffsetDateTime> _getStripeInvoiceCompletedTimestamp() {
        return stripeInvoiceCompletedTimestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ShipperPayCourierStatement1 && equalTo((ShipperPayCourierStatement1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperPayCourierStatement1 other) {
        return schemaVersion == other.schemaVersion
                && shipperPayCourierLineItemGroupIds.equals(other.shipperPayCourierLineItemGroupIds)
                && taskGroupIds.equals(other.taskGroupIds)
                && offChrtShipperOrgId.equals(other.offChrtShipperOrgId)
                && shipperOrgId.equals(other.shipperOrgId)
                && courierOrgId.equals(other.courierOrgId)
                && shipperCustomerIdForCourierStripeConnectAccount.equals(
                        other.shipperCustomerIdForCourierStripeConnectAccount)
                && stripeInvoiceId.equals(other.stripeInvoiceId)
                && stripeInvoiceUrl.equals(other.stripeInvoiceUrl)
                && stripeInvoiceCreatedTimestamp.equals(other.stripeInvoiceCreatedTimestamp)
                && stripeInvoiceCreatedByUserId.equals(other.stripeInvoiceCreatedByUserId)
                && statementAmount == other.statementAmount
                && stripeInvoiceStatus.equals(other.stripeInvoiceStatus)
                && stripeInvoiceCompletedTimestamp.equals(other.stripeInvoiceCompletedTimestamp)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.shipperPayCourierLineItemGroupIds,
                this.taskGroupIds,
                this.offChrtShipperOrgId,
                this.shipperOrgId,
                this.courierOrgId,
                this.shipperCustomerIdForCourierStripeConnectAccount,
                this.stripeInvoiceId,
                this.stripeInvoiceUrl,
                this.stripeInvoiceCreatedTimestamp,
                this.stripeInvoiceCreatedByUserId,
                this.statementAmount,
                this.stripeInvoiceStatus,
                this.stripeInvoiceCompletedTimestamp,
                this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        CourierOrgIdStage schemaVersion(int schemaVersion);

        Builder from(ShipperPayCourierStatement1 other);
    }

    public interface CourierOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        StatementAmountStage courierOrgId(@NotNull String courierOrgId);
    }

    public interface StatementAmountStage {
        IdStage statementAmount(double statementAmount);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        ShipperPayCourierStatement1 build();

        _FinalStage shipperPayCourierLineItemGroupIds(List<String> shipperPayCourierLineItemGroupIds);

        _FinalStage addShipperPayCourierLineItemGroupIds(String shipperPayCourierLineItemGroupIds);

        _FinalStage addAllShipperPayCourierLineItemGroupIds(List<String> shipperPayCourierLineItemGroupIds);

        _FinalStage taskGroupIds(List<String> taskGroupIds);

        _FinalStage addTaskGroupIds(String taskGroupIds);

        _FinalStage addAllTaskGroupIds(List<String> taskGroupIds);

        _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId);

        _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId);

        _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId);

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        _FinalStage shipperOrgId(Optional<String> shipperOrgId);

        _FinalStage shipperOrgId(String shipperOrgId);

        _FinalStage shipperOrgId(Nullable<String> shipperOrgId);

        _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Optional<String> shipperCustomerIdForCourierStripeConnectAccount);

        _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                String shipperCustomerIdForCourierStripeConnectAccount);

        _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Nullable<String> shipperCustomerIdForCourierStripeConnectAccount);

        _FinalStage stripeInvoiceId(Optional<String> stripeInvoiceId);

        _FinalStage stripeInvoiceId(String stripeInvoiceId);

        _FinalStage stripeInvoiceId(Nullable<String> stripeInvoiceId);

        _FinalStage stripeInvoiceUrl(Optional<String> stripeInvoiceUrl);

        _FinalStage stripeInvoiceUrl(String stripeInvoiceUrl);

        _FinalStage stripeInvoiceUrl(Nullable<String> stripeInvoiceUrl);

        _FinalStage stripeInvoiceCreatedTimestamp(Optional<OffsetDateTime> stripeInvoiceCreatedTimestamp);

        _FinalStage stripeInvoiceCreatedTimestamp(OffsetDateTime stripeInvoiceCreatedTimestamp);

        _FinalStage stripeInvoiceCreatedTimestamp(Nullable<OffsetDateTime> stripeInvoiceCreatedTimestamp);

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        _FinalStage stripeInvoiceCreatedByUserId(Optional<String> stripeInvoiceCreatedByUserId);

        _FinalStage stripeInvoiceCreatedByUserId(String stripeInvoiceCreatedByUserId);

        _FinalStage stripeInvoiceCreatedByUserId(Nullable<String> stripeInvoiceCreatedByUserId);

        _FinalStage stripeInvoiceStatus(Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus);

        _FinalStage stripeInvoiceStatus(StripeConnectInvoiceStatusEnum stripeInvoiceStatus);

        _FinalStage stripeInvoiceCompletedTimestamp(Optional<OffsetDateTime> stripeInvoiceCompletedTimestamp);

        _FinalStage stripeInvoiceCompletedTimestamp(OffsetDateTime stripeInvoiceCompletedTimestamp);

        _FinalStage stripeInvoiceCompletedTimestamp(Nullable<OffsetDateTime> stripeInvoiceCompletedTimestamp);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage, CourierOrgIdStage, StatementAmountStage, IdStage, _FinalStage {
        private int schemaVersion;

        private String courierOrgId;

        private double statementAmount;

        private String id;

        private Optional<OffsetDateTime> stripeInvoiceCompletedTimestamp = Optional.empty();

        private Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus = Optional.empty();

        private Optional<String> stripeInvoiceCreatedByUserId = Optional.empty();

        private Optional<OffsetDateTime> stripeInvoiceCreatedTimestamp = Optional.empty();

        private Optional<String> stripeInvoiceUrl = Optional.empty();

        private Optional<String> stripeInvoiceId = Optional.empty();

        private Optional<String> shipperCustomerIdForCourierStripeConnectAccount = Optional.empty();

        private Optional<String> shipperOrgId = Optional.empty();

        private Optional<String> offChrtShipperOrgId = Optional.empty();

        private List<String> taskGroupIds = new ArrayList<>();

        private List<String> shipperPayCourierLineItemGroupIds = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ShipperPayCourierStatement1 other) {
            schemaVersion(other.getSchemaVersion());
            shipperPayCourierLineItemGroupIds(other.getShipperPayCourierLineItemGroupIds());
            taskGroupIds(other.getTaskGroupIds());
            offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            shipperOrgId(other.getShipperOrgId());
            courierOrgId(other.getCourierOrgId());
            shipperCustomerIdForCourierStripeConnectAccount(other.getShipperCustomerIdForCourierStripeConnectAccount());
            stripeInvoiceId(other.getStripeInvoiceId());
            stripeInvoiceUrl(other.getStripeInvoiceUrl());
            stripeInvoiceCreatedTimestamp(other.getStripeInvoiceCreatedTimestamp());
            stripeInvoiceCreatedByUserId(other.getStripeInvoiceCreatedByUserId());
            statementAmount(other.getStatementAmount());
            stripeInvoiceStatus(other.getStripeInvoiceStatus());
            stripeInvoiceCompletedTimestamp(other.getStripeInvoiceCompletedTimestamp());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public CourierOrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("courier_org_id")
        public StatementAmountStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("statement_amount")
        public IdStage statementAmount(double statementAmount) {
            this.statementAmount = statementAmount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceCompletedTimestamp(Nullable<OffsetDateTime> stripeInvoiceCompletedTimestamp) {
            if (stripeInvoiceCompletedTimestamp.isNull()) {
                this.stripeInvoiceCompletedTimestamp = null;
            } else if (stripeInvoiceCompletedTimestamp.isEmpty()) {
                this.stripeInvoiceCompletedTimestamp = Optional.empty();
            } else {
                this.stripeInvoiceCompletedTimestamp = Optional.of(stripeInvoiceCompletedTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceCompletedTimestamp(OffsetDateTime stripeInvoiceCompletedTimestamp) {
            this.stripeInvoiceCompletedTimestamp = Optional.ofNullable(stripeInvoiceCompletedTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "stripe_invoice_completed_timestamp", nulls = Nulls.SKIP)
        public _FinalStage stripeInvoiceCompletedTimestamp(Optional<OffsetDateTime> stripeInvoiceCompletedTimestamp) {
            this.stripeInvoiceCompletedTimestamp = stripeInvoiceCompletedTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceStatus(StripeConnectInvoiceStatusEnum stripeInvoiceStatus) {
            this.stripeInvoiceStatus = Optional.ofNullable(stripeInvoiceStatus);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "stripe_invoice_status", nulls = Nulls.SKIP)
        public _FinalStage stripeInvoiceStatus(Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus) {
            this.stripeInvoiceStatus = stripeInvoiceStatus;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage stripeInvoiceCreatedByUserId(Nullable<String> stripeInvoiceCreatedByUserId) {
            if (stripeInvoiceCreatedByUserId.isNull()) {
                this.stripeInvoiceCreatedByUserId = null;
            } else if (stripeInvoiceCreatedByUserId.isEmpty()) {
                this.stripeInvoiceCreatedByUserId = Optional.empty();
            } else {
                this.stripeInvoiceCreatedByUserId = Optional.of(stripeInvoiceCreatedByUserId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage stripeInvoiceCreatedByUserId(String stripeInvoiceCreatedByUserId) {
            this.stripeInvoiceCreatedByUserId = Optional.ofNullable(stripeInvoiceCreatedByUserId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "stripe_invoice_created_by_user_id", nulls = Nulls.SKIP)
        public _FinalStage stripeInvoiceCreatedByUserId(Optional<String> stripeInvoiceCreatedByUserId) {
            this.stripeInvoiceCreatedByUserId = stripeInvoiceCreatedByUserId;
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceCreatedTimestamp(Nullable<OffsetDateTime> stripeInvoiceCreatedTimestamp) {
            if (stripeInvoiceCreatedTimestamp.isNull()) {
                this.stripeInvoiceCreatedTimestamp = null;
            } else if (stripeInvoiceCreatedTimestamp.isEmpty()) {
                this.stripeInvoiceCreatedTimestamp = Optional.empty();
            } else {
                this.stripeInvoiceCreatedTimestamp = Optional.of(stripeInvoiceCreatedTimestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceCreatedTimestamp(OffsetDateTime stripeInvoiceCreatedTimestamp) {
            this.stripeInvoiceCreatedTimestamp = Optional.ofNullable(stripeInvoiceCreatedTimestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "stripe_invoice_created_timestamp", nulls = Nulls.SKIP)
        public _FinalStage stripeInvoiceCreatedTimestamp(Optional<OffsetDateTime> stripeInvoiceCreatedTimestamp) {
            this.stripeInvoiceCreatedTimestamp = stripeInvoiceCreatedTimestamp;
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceUrl(Nullable<String> stripeInvoiceUrl) {
            if (stripeInvoiceUrl.isNull()) {
                this.stripeInvoiceUrl = null;
            } else if (stripeInvoiceUrl.isEmpty()) {
                this.stripeInvoiceUrl = Optional.empty();
            } else {
                this.stripeInvoiceUrl = Optional.of(stripeInvoiceUrl.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceUrl(String stripeInvoiceUrl) {
            this.stripeInvoiceUrl = Optional.ofNullable(stripeInvoiceUrl);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "stripe_invoice_url", nulls = Nulls.SKIP)
        public _FinalStage stripeInvoiceUrl(Optional<String> stripeInvoiceUrl) {
            this.stripeInvoiceUrl = stripeInvoiceUrl;
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceId(Nullable<String> stripeInvoiceId) {
            if (stripeInvoiceId.isNull()) {
                this.stripeInvoiceId = null;
            } else if (stripeInvoiceId.isEmpty()) {
                this.stripeInvoiceId = Optional.empty();
            } else {
                this.stripeInvoiceId = Optional.of(stripeInvoiceId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage stripeInvoiceId(String stripeInvoiceId) {
            this.stripeInvoiceId = Optional.ofNullable(stripeInvoiceId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "stripe_invoice_id", nulls = Nulls.SKIP)
        public _FinalStage stripeInvoiceId(Optional<String> stripeInvoiceId) {
            this.stripeInvoiceId = stripeInvoiceId;
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Nullable<String> shipperCustomerIdForCourierStripeConnectAccount) {
            if (shipperCustomerIdForCourierStripeConnectAccount.isNull()) {
                this.shipperCustomerIdForCourierStripeConnectAccount = null;
            } else if (shipperCustomerIdForCourierStripeConnectAccount.isEmpty()) {
                this.shipperCustomerIdForCourierStripeConnectAccount = Optional.empty();
            } else {
                this.shipperCustomerIdForCourierStripeConnectAccount =
                        Optional.of(shipperCustomerIdForCourierStripeConnectAccount.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                String shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount =
                    Optional.ofNullable(shipperCustomerIdForCourierStripeConnectAccount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_customer_id_for_courier_stripe_connect_account", nulls = Nulls.SKIP)
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(
                Optional<String> shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperOrgId(Nullable<String> shipperOrgId) {
            if (shipperOrgId.isNull()) {
                this.shipperOrgId = null;
            } else if (shipperOrgId.isEmpty()) {
                this.shipperOrgId = Optional.empty();
            } else {
                this.shipperOrgId = Optional.of(shipperOrgId.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @java.lang.Override
        @JsonSetter(value = "shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            if (offChrtShipperOrgId.isNull()) {
                this.offChrtShipperOrgId = null;
            } else if (offChrtShipperOrgId.isEmpty()) {
                this.offChrtShipperOrgId = Optional.empty();
            } else {
                this.offChrtShipperOrgId = Optional.of(offChrtShipperOrgId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "off_chrt_shipper_org_id", nulls = Nulls.SKIP)
        public _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllTaskGroupIds(List<String> taskGroupIds) {
            if (taskGroupIds != null) {
                this.taskGroupIds.addAll(taskGroupIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addTaskGroupIds(String taskGroupIds) {
            this.taskGroupIds.add(taskGroupIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_group_ids", nulls = Nulls.SKIP)
        public _FinalStage taskGroupIds(List<String> taskGroupIds) {
            this.taskGroupIds.clear();
            if (taskGroupIds != null) {
                this.taskGroupIds.addAll(taskGroupIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllShipperPayCourierLineItemGroupIds(List<String> shipperPayCourierLineItemGroupIds) {
            if (shipperPayCourierLineItemGroupIds != null) {
                this.shipperPayCourierLineItemGroupIds.addAll(shipperPayCourierLineItemGroupIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addShipperPayCourierLineItemGroupIds(String shipperPayCourierLineItemGroupIds) {
            this.shipperPayCourierLineItemGroupIds.add(shipperPayCourierLineItemGroupIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "shipper_pay_courier_line_item_group_ids", nulls = Nulls.SKIP)
        public _FinalStage shipperPayCourierLineItemGroupIds(List<String> shipperPayCourierLineItemGroupIds) {
            this.shipperPayCourierLineItemGroupIds.clear();
            if (shipperPayCourierLineItemGroupIds != null) {
                this.shipperPayCourierLineItemGroupIds.addAll(shipperPayCourierLineItemGroupIds);
            }
            return this;
        }

        @java.lang.Override
        public ShipperPayCourierStatement1 build() {
            return new ShipperPayCourierStatement1(
                    schemaVersion,
                    shipperPayCourierLineItemGroupIds,
                    taskGroupIds,
                    offChrtShipperOrgId,
                    shipperOrgId,
                    courierOrgId,
                    shipperCustomerIdForCourierStripeConnectAccount,
                    stripeInvoiceId,
                    stripeInvoiceUrl,
                    stripeInvoiceCreatedTimestamp,
                    stripeInvoiceCreatedByUserId,
                    statementAmount,
                    stripeInvoiceStatus,
                    stripeInvoiceCompletedTimestamp,
                    id,
                    additionalProperties);
        }
    }
}
