/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = StatementPreviewResponse.Builder.class)
public final class StatementPreviewResponse {
    private final List<TaskGroup1> taskGroups;

    private final List<ShipperPayCourierLineItemGroup1> lineItemGroups;

    private final double totalAmount;

    private final boolean statementReady;

    private final Map<String, Object> additionalProperties;

    private StatementPreviewResponse(
            List<TaskGroup1> taskGroups,
            List<ShipperPayCourierLineItemGroup1> lineItemGroups,
            double totalAmount,
            boolean statementReady,
            Map<String, Object> additionalProperties) {
        this.taskGroups = taskGroups;
        this.lineItemGroups = lineItemGroups;
        this.totalAmount = totalAmount;
        this.statementReady = statementReady;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task_groups")
    public List<TaskGroup1> getTaskGroups() {
        return taskGroups;
    }

    @JsonProperty("line_item_groups")
    public List<ShipperPayCourierLineItemGroup1> getLineItemGroups() {
        return lineItemGroups;
    }

    @JsonProperty("total_amount")
    public double getTotalAmount() {
        return totalAmount;
    }

    @JsonProperty("statement_ready")
    public boolean getStatementReady() {
        return statementReady;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof StatementPreviewResponse && equalTo((StatementPreviewResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StatementPreviewResponse other) {
        return taskGroups.equals(other.taskGroups)
                && lineItemGroups.equals(other.lineItemGroups)
                && totalAmount == other.totalAmount
                && statementReady == other.statementReady;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.taskGroups, this.lineItemGroups, this.totalAmount, this.statementReady);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalAmountStage builder() {
        return new Builder();
    }

    public interface TotalAmountStage {
        StatementReadyStage totalAmount(double totalAmount);

        Builder from(StatementPreviewResponse other);
    }

    public interface StatementReadyStage {
        _FinalStage statementReady(boolean statementReady);
    }

    public interface _FinalStage {
        StatementPreviewResponse build();

        _FinalStage taskGroups(List<TaskGroup1> taskGroups);

        _FinalStage addTaskGroups(TaskGroup1 taskGroups);

        _FinalStage addAllTaskGroups(List<TaskGroup1> taskGroups);

        _FinalStage lineItemGroups(List<ShipperPayCourierLineItemGroup1> lineItemGroups);

        _FinalStage addLineItemGroups(ShipperPayCourierLineItemGroup1 lineItemGroups);

        _FinalStage addAllLineItemGroups(List<ShipperPayCourierLineItemGroup1> lineItemGroups);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalAmountStage, StatementReadyStage, _FinalStage {
        private double totalAmount;

        private boolean statementReady;

        private List<ShipperPayCourierLineItemGroup1> lineItemGroups = new ArrayList<>();

        private List<TaskGroup1> taskGroups = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(StatementPreviewResponse other) {
            taskGroups(other.getTaskGroups());
            lineItemGroups(other.getLineItemGroups());
            totalAmount(other.getTotalAmount());
            statementReady(other.getStatementReady());
            return this;
        }

        @java.lang.Override
        @JsonSetter("total_amount")
        public StatementReadyStage totalAmount(double totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("statement_ready")
        public _FinalStage statementReady(boolean statementReady) {
            this.statementReady = statementReady;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllLineItemGroups(List<ShipperPayCourierLineItemGroup1> lineItemGroups) {
            if (lineItemGroups != null) {
                this.lineItemGroups.addAll(lineItemGroups);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addLineItemGroups(ShipperPayCourierLineItemGroup1 lineItemGroups) {
            this.lineItemGroups.add(lineItemGroups);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "line_item_groups", nulls = Nulls.SKIP)
        public _FinalStage lineItemGroups(List<ShipperPayCourierLineItemGroup1> lineItemGroups) {
            this.lineItemGroups.clear();
            if (lineItemGroups != null) {
                this.lineItemGroups.addAll(lineItemGroups);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllTaskGroups(List<TaskGroup1> taskGroups) {
            if (taskGroups != null) {
                this.taskGroups.addAll(taskGroups);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addTaskGroups(TaskGroup1 taskGroups) {
            this.taskGroups.add(taskGroups);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "task_groups", nulls = Nulls.SKIP)
        public _FinalStage taskGroups(List<TaskGroup1> taskGroups) {
            this.taskGroups.clear();
            if (taskGroups != null) {
                this.taskGroups.addAll(taskGroups);
            }
            return this;
        }

        @java.lang.Override
        public StatementPreviewResponse build() {
            return new StatementPreviewResponse(
                    taskGroups, lineItemGroups, totalAmount, statementReady, additionalProperties);
        }
    }
}
