/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TimezoneResponse.Builder.class)
public final class TimezoneResponse {
    private final String timezone;

    private final double lat;

    private final double lng;

    private final String method;

    private final Map<String, Object> additionalProperties;

    private TimezoneResponse(
            String timezone, double lat, double lng, String method, Map<String, Object> additionalProperties) {
        this.timezone = timezone;
        this.lat = lat;
        this.lng = lng;
        this.method = method;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("timezone")
    public String getTimezone() {
        return timezone;
    }

    @JsonProperty("lat")
    public double getLat() {
        return lat;
    }

    @JsonProperty("lng")
    public double getLng() {
        return lng;
    }

    @JsonProperty("method")
    public String getMethod() {
        return method;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TimezoneResponse && equalTo((TimezoneResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TimezoneResponse other) {
        return timezone.equals(other.timezone) && lat == other.lat && lng == other.lng && method.equals(other.method);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.timezone, this.lat, this.lng, this.method);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TimezoneStage builder() {
        return new Builder();
    }

    public interface TimezoneStage {
        LatStage timezone(@NotNull String timezone);

        Builder from(TimezoneResponse other);
    }

    public interface LatStage {
        LngStage lat(double lat);
    }

    public interface LngStage {
        MethodStage lng(double lng);
    }

    public interface MethodStage {
        _FinalStage method(@NotNull String method);
    }

    public interface _FinalStage {
        TimezoneResponse build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TimezoneStage, LatStage, LngStage, MethodStage, _FinalStage {
        private String timezone;

        private double lat;

        private double lng;

        private String method;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TimezoneResponse other) {
            timezone(other.getTimezone());
            lat(other.getLat());
            lng(other.getLng());
            method(other.getMethod());
            return this;
        }

        @java.lang.Override
        @JsonSetter("timezone")
        public LatStage timezone(@NotNull String timezone) {
            this.timezone = Objects.requireNonNull(timezone, "timezone must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("lat")
        public LngStage lat(double lat) {
            this.lat = lat;
            return this;
        }

        @java.lang.Override
        @JsonSetter("lng")
        public MethodStage lng(double lng) {
            this.lng = lng;
            return this;
        }

        @java.lang.Override
        @JsonSetter("method")
        public _FinalStage method(@NotNull String method) {
            this.method = Objects.requireNonNull(method, "method must not be null");
            return this;
        }

        @java.lang.Override
        public TimezoneResponse build() {
            return new TimezoneResponse(timezone, lat, lng, method, additionalProperties);
        }
    }
}
