/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TrackingSharingSettingsRes.Builder.class)
public final class TrackingSharingSettingsRes {
    private final String taskGroupId;

    private final TrackingSharingSettingsResSharingSettings sharingSettings;

    private final Map<String, Object> additionalProperties;

    private TrackingSharingSettingsRes(
            String taskGroupId,
            TrackingSharingSettingsResSharingSettings sharingSettings,
            Map<String, Object> additionalProperties) {
        this.taskGroupId = taskGroupId;
        this.sharingSettings = sharingSettings;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    @JsonProperty("sharing_settings")
    public TrackingSharingSettingsResSharingSettings getSharingSettings() {
        return sharingSettings;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TrackingSharingSettingsRes && equalTo((TrackingSharingSettingsRes) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TrackingSharingSettingsRes other) {
        return taskGroupId.equals(other.taskGroupId) && sharingSettings.equals(other.sharingSettings);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.taskGroupId, this.sharingSettings);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskGroupIdStage builder() {
        return new Builder();
    }

    public interface TaskGroupIdStage {
        SharingSettingsStage taskGroupId(@NotNull String taskGroupId);

        Builder from(TrackingSharingSettingsRes other);
    }

    public interface SharingSettingsStage {
        _FinalStage sharingSettings(@NotNull TrackingSharingSettingsResSharingSettings sharingSettings);
    }

    public interface _FinalStage {
        TrackingSharingSettingsRes build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TaskGroupIdStage, SharingSettingsStage, _FinalStage {
        private String taskGroupId;

        private TrackingSharingSettingsResSharingSettings sharingSettings;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TrackingSharingSettingsRes other) {
            taskGroupId(other.getTaskGroupId());
            sharingSettings(other.getSharingSettings());
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public SharingSettingsStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("sharing_settings")
        public _FinalStage sharingSettings(@NotNull TrackingSharingSettingsResSharingSettings sharingSettings) {
            this.sharingSettings = Objects.requireNonNull(sharingSettings, "sharingSettings must not be null");
            return this;
        }

        @java.lang.Override
        public TrackingSharingSettingsRes build() {
            return new TrackingSharingSettingsRes(taskGroupId, sharingSettings, additionalProperties);
        }
    }
}
