/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UserPublicData1.Builder.class)
public final class UserPublicData1 {
    private final int schemaVersion;

    private final OffsetDateTime createdAtTimestamp;

    private final Optional<String> primaryEmailAddress;

    private final String userId;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private UserPublicData1(
            int schemaVersion,
            OffsetDateTime createdAtTimestamp,
            Optional<String> primaryEmailAddress,
            String userId,
            String id,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.createdAtTimestamp = createdAtTimestamp;
        this.primaryEmailAddress = primaryEmailAddress;
        this.userId = userId;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonProperty("created_at_timestamp")
    public OffsetDateTime getCreatedAtTimestamp() {
        return createdAtTimestamp;
    }

    @JsonIgnore
    public Optional<String> getPrimaryEmailAddress() {
        if (primaryEmailAddress == null) {
            return Optional.empty();
        }
        return primaryEmailAddress;
    }

    /**
     * @return Must be a string starting with <code>user_</code>
     */
    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    @JsonProperty("_id")
    public String getId() {
        return id;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("primary_email_address")
    private Optional<String> _getPrimaryEmailAddress() {
        return primaryEmailAddress;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UserPublicData1 && equalTo((UserPublicData1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UserPublicData1 other) {
        return schemaVersion == other.schemaVersion
                && createdAtTimestamp.equals(other.createdAtTimestamp)
                && primaryEmailAddress.equals(other.primaryEmailAddress)
                && userId.equals(other.userId)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion, this.createdAtTimestamp, this.primaryEmailAddress, this.userId, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        CreatedAtTimestampStage schemaVersion(int schemaVersion);

        Builder from(UserPublicData1 other);
    }

    public interface CreatedAtTimestampStage {
        UserIdStage createdAtTimestamp(@NotNull OffsetDateTime createdAtTimestamp);
    }

    public interface UserIdStage {
        /**
         * <p>Must be a string starting with <code>user_</code></p>
         */
        IdStage userId(@NotNull String userId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        UserPublicData1 build();

        _FinalStage primaryEmailAddress(Optional<String> primaryEmailAddress);

        _FinalStage primaryEmailAddress(String primaryEmailAddress);

        _FinalStage primaryEmailAddress(Nullable<String> primaryEmailAddress);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage, CreatedAtTimestampStage, UserIdStage, IdStage, _FinalStage {
        private int schemaVersion;

        private OffsetDateTime createdAtTimestamp;

        private String userId;

        private String id;

        private Optional<String> primaryEmailAddress = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UserPublicData1 other) {
            schemaVersion(other.getSchemaVersion());
            createdAtTimestamp(other.getCreatedAtTimestamp());
            primaryEmailAddress(other.getPrimaryEmailAddress());
            userId(other.getUserId());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public CreatedAtTimestampStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at_timestamp")
        public UserIdStage createdAtTimestamp(@NotNull OffsetDateTime createdAtTimestamp) {
            this.createdAtTimestamp = Objects.requireNonNull(createdAtTimestamp, "createdAtTimestamp must not be null");
            return this;
        }

        /**
         * <p>Must be a string starting with <code>user_</code></p>
         * <p>Must be a string starting with <code>user_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user_id")
        public IdStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage primaryEmailAddress(Nullable<String> primaryEmailAddress) {
            if (primaryEmailAddress.isNull()) {
                this.primaryEmailAddress = null;
            } else if (primaryEmailAddress.isEmpty()) {
                this.primaryEmailAddress = Optional.empty();
            } else {
                this.primaryEmailAddress = Optional.of(primaryEmailAddress.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage primaryEmailAddress(String primaryEmailAddress) {
            this.primaryEmailAddress = Optional.ofNullable(primaryEmailAddress);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "primary_email_address", nulls = Nulls.SKIP)
        public _FinalStage primaryEmailAddress(Optional<String> primaryEmailAddress) {
            this.primaryEmailAddress = primaryEmailAddress;
            return this;
        }

        @java.lang.Override
        public UserPublicData1 build() {
            return new UserPublicData1(
                    schemaVersion, createdAtTimestamp, primaryEmailAddress, userId, id, additionalProperties);
        }
    }
}
