/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ValidationError.Builder.class)
public final class ValidationError {
    private final List<ValidationErrorLocItem> loc;

    private final String msg;

    private final String type;

    private final Map<String, Object> additionalProperties;

    private ValidationError(
            List<ValidationErrorLocItem> loc, String msg, String type, Map<String, Object> additionalProperties) {
        this.loc = loc;
        this.msg = msg;
        this.type = type;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("loc")
    public List<ValidationErrorLocItem> getLoc() {
        return loc;
    }

    @JsonProperty("msg")
    public String getMsg() {
        return msg;
    }

    @JsonProperty("type")
    public String getType() {
        return type;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ValidationError && equalTo((ValidationError) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ValidationError other) {
        return loc.equals(other.loc) && msg.equals(other.msg) && type.equals(other.type);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.loc, this.msg, this.type);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MsgStage builder() {
        return new Builder();
    }

    public interface MsgStage {
        TypeStage msg(@NotNull String msg);

        Builder from(ValidationError other);
    }

    public interface TypeStage {
        _FinalStage type(@NotNull String type);
    }

    public interface _FinalStage {
        ValidationError build();

        _FinalStage loc(List<ValidationErrorLocItem> loc);

        _FinalStage addLoc(ValidationErrorLocItem loc);

        _FinalStage addAllLoc(List<ValidationErrorLocItem> loc);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements MsgStage, TypeStage, _FinalStage {
        private String msg;

        private String type;

        private List<ValidationErrorLocItem> loc = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ValidationError other) {
            loc(other.getLoc());
            msg(other.getMsg());
            type(other.getType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("msg")
        public TypeStage msg(@NotNull String msg) {
            this.msg = Objects.requireNonNull(msg, "msg must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("type")
        public _FinalStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllLoc(List<ValidationErrorLocItem> loc) {
            if (loc != null) {
                this.loc.addAll(loc);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addLoc(ValidationErrorLocItem loc) {
            this.loc.add(loc);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "loc", nulls = Nulls.SKIP)
        public _FinalStage loc(List<ValidationErrorLocItem> loc) {
            this.loc.clear();
            if (loc != null) {
                this.loc.addAll(loc);
            }
            return this;
        }

        @java.lang.Override
        public ValidationError build() {
            return new ValidationError(loc, msg, type, additionalProperties);
        }
    }
}
