/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api;

import com.chrt.api.ChrtApiClientBuilder;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.cargos.CargosClient;
import com.chrt.api.resources.connections.ConnectionsClient;
import com.chrt.api.resources.courierpaydriverlineitemgroups.CourierPayDriverLineItemGroupsClient;
import com.chrt.api.resources.courierpaydriverpayouts.CourierPayDriverPayoutsClient;
import com.chrt.api.resources.courierpaydriverratesheets.CourierPayDriverRateSheetsClient;
import com.chrt.api.resources.courierpaydriverstatements.CourierPayDriverStatementsClient;
import com.chrt.api.resources.dev.DevClient;
import com.chrt.api.resources.drivers.DriversClient;
import com.chrt.api.resources.notifications.NotificationsClient;
import com.chrt.api.resources.offchrtshipperorg.OffChrtShipperOrgClient;
import com.chrt.api.resources.orderdrafts.OrderDraftsClient;
import com.chrt.api.resources.orders.OrdersClient;
import com.chrt.api.resources.orginfoforconnections.OrgInfoForConnectionsClient;
import com.chrt.api.resources.orgprofiles.OrgProfilesClient;
import com.chrt.api.resources.orgs.OrgsClient;
import com.chrt.api.resources.payments.PaymentsClient;
import com.chrt.api.resources.root.RootClient;
import com.chrt.api.resources.shippercontactinfo.ShipperContactInfoClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.ShipperPayCourierLineItemGroupsClient;
import com.chrt.api.resources.shipperpaycourierpayments.ShipperPayCourierPaymentsClient;
import com.chrt.api.resources.shipperpaycourierratesheets.ShipperPayCourierRateSheetsClient;
import com.chrt.api.resources.shipperpaycourierstatements.ShipperPayCourierStatementsClient;
import com.chrt.api.resources.taskartifactnotifications.TaskArtifactNotificationsClient;
import com.chrt.api.resources.taskartifacts.TaskArtifactsClient;
import com.chrt.api.resources.taskgroups.TaskGroupsClient;
import com.chrt.api.resources.tasks.TasksClient;
import com.chrt.api.resources.tracking.TrackingClient;
import com.chrt.api.resources.users.UsersClient;
import com.chrt.api.resources.utils.UtilsClient;
import java.util.function.Supplier;

public class ChrtApiClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<PaymentsClient> paymentsClient;
    protected final Supplier<CourierPayDriverLineItemGroupsClient> courierPayDriverLineItemGroupsClient;
    protected final Supplier<CourierPayDriverPayoutsClient> courierPayDriverPayoutsClient;
    protected final Supplier<CourierPayDriverRateSheetsClient> courierPayDriverRateSheetsClient;
    protected final Supplier<CourierPayDriverStatementsClient> courierPayDriverStatementsClient;
    protected final Supplier<ShipperPayCourierLineItemGroupsClient> shipperPayCourierLineItemGroupsClient;
    protected final Supplier<ShipperPayCourierPaymentsClient> shipperPayCourierPaymentsClient;
    protected final Supplier<ShipperPayCourierRateSheetsClient> shipperPayCourierRateSheetsClient;
    protected final Supplier<ShipperPayCourierStatementsClient> shipperPayCourierStatementsClient;
    protected final Supplier<ConnectionsClient> connectionsClient;
    protected final Supplier<OrgProfilesClient> orgProfilesClient;
    protected final Supplier<DevClient> devClient;
    protected final Supplier<TaskArtifactNotificationsClient> taskArtifactNotificationsClient;
    protected final Supplier<DriversClient> driversClient;
    protected final Supplier<CargosClient> cargosClient;
    protected final Supplier<TaskArtifactsClient> taskArtifactsClient;
    protected final Supplier<OffChrtShipperOrgClient> offChrtShipperOrgClient;
    protected final Supplier<OrdersClient> ordersClient;
    protected final Supplier<OrderDraftsClient> orderDraftsClient;
    protected final Supplier<TaskGroupsClient> taskGroupsClient;
    protected final Supplier<TasksClient> tasksClient;
    protected final Supplier<ShipperContactInfoClient> shipperContactInfoClient;
    protected final Supplier<OrgsClient> orgsClient;
    protected final Supplier<RootClient> rootClient;
    protected final Supplier<UsersClient> usersClient;
    protected final Supplier<UtilsClient> utilsClient;
    protected final Supplier<NotificationsClient> notificationsClient;
    protected final Supplier<OrgInfoForConnectionsClient> orgInfoForConnectionsClient;
    protected final Supplier<TrackingClient> trackingClient;

    public ChrtApiClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.paymentsClient = Suppliers.memoize(() -> new PaymentsClient(clientOptions));
        this.courierPayDriverLineItemGroupsClient = Suppliers.memoize(() -> new CourierPayDriverLineItemGroupsClient(clientOptions));
        this.courierPayDriverPayoutsClient = Suppliers.memoize(() -> new CourierPayDriverPayoutsClient(clientOptions));
        this.courierPayDriverRateSheetsClient = Suppliers.memoize(() -> new CourierPayDriverRateSheetsClient(clientOptions));
        this.courierPayDriverStatementsClient = Suppliers.memoize(() -> new CourierPayDriverStatementsClient(clientOptions));
        this.shipperPayCourierLineItemGroupsClient = Suppliers.memoize(() -> new ShipperPayCourierLineItemGroupsClient(clientOptions));
        this.shipperPayCourierPaymentsClient = Suppliers.memoize(() -> new ShipperPayCourierPaymentsClient(clientOptions));
        this.shipperPayCourierRateSheetsClient = Suppliers.memoize(() -> new ShipperPayCourierRateSheetsClient(clientOptions));
        this.shipperPayCourierStatementsClient = Suppliers.memoize(() -> new ShipperPayCourierStatementsClient(clientOptions));
        this.connectionsClient = Suppliers.memoize(() -> new ConnectionsClient(clientOptions));
        this.orgProfilesClient = Suppliers.memoize(() -> new OrgProfilesClient(clientOptions));
        this.devClient = Suppliers.memoize(() -> new DevClient(clientOptions));
        this.taskArtifactNotificationsClient = Suppliers.memoize(() -> new TaskArtifactNotificationsClient(clientOptions));
        this.driversClient = Suppliers.memoize(() -> new DriversClient(clientOptions));
        this.cargosClient = Suppliers.memoize(() -> new CargosClient(clientOptions));
        this.taskArtifactsClient = Suppliers.memoize(() -> new TaskArtifactsClient(clientOptions));
        this.offChrtShipperOrgClient = Suppliers.memoize(() -> new OffChrtShipperOrgClient(clientOptions));
        this.ordersClient = Suppliers.memoize(() -> new OrdersClient(clientOptions));
        this.orderDraftsClient = Suppliers.memoize(() -> new OrderDraftsClient(clientOptions));
        this.taskGroupsClient = Suppliers.memoize(() -> new TaskGroupsClient(clientOptions));
        this.tasksClient = Suppliers.memoize(() -> new TasksClient(clientOptions));
        this.shipperContactInfoClient = Suppliers.memoize(() -> new ShipperContactInfoClient(clientOptions));
        this.orgsClient = Suppliers.memoize(() -> new OrgsClient(clientOptions));
        this.rootClient = Suppliers.memoize(() -> new RootClient(clientOptions));
        this.usersClient = Suppliers.memoize(() -> new UsersClient(clientOptions));
        this.utilsClient = Suppliers.memoize(() -> new UtilsClient(clientOptions));
        this.notificationsClient = Suppliers.memoize(() -> new NotificationsClient(clientOptions));
        this.orgInfoForConnectionsClient = Suppliers.memoize(() -> new OrgInfoForConnectionsClient(clientOptions));
        this.trackingClient = Suppliers.memoize(() -> new TrackingClient(clientOptions));
    }

    public PaymentsClient payments() {
        return this.paymentsClient.get();
    }

    public CourierPayDriverLineItemGroupsClient courierPayDriverLineItemGroups() {
        return this.courierPayDriverLineItemGroupsClient.get();
    }

    public CourierPayDriverPayoutsClient courierPayDriverPayouts() {
        return this.courierPayDriverPayoutsClient.get();
    }

    public CourierPayDriverRateSheetsClient courierPayDriverRateSheets() {
        return this.courierPayDriverRateSheetsClient.get();
    }

    public CourierPayDriverStatementsClient courierPayDriverStatements() {
        return this.courierPayDriverStatementsClient.get();
    }

    public ShipperPayCourierLineItemGroupsClient shipperPayCourierLineItemGroups() {
        return this.shipperPayCourierLineItemGroupsClient.get();
    }

    public ShipperPayCourierPaymentsClient shipperPayCourierPayments() {
        return this.shipperPayCourierPaymentsClient.get();
    }

    public ShipperPayCourierRateSheetsClient shipperPayCourierRateSheets() {
        return this.shipperPayCourierRateSheetsClient.get();
    }

    public ShipperPayCourierStatementsClient shipperPayCourierStatements() {
        return this.shipperPayCourierStatementsClient.get();
    }

    public ConnectionsClient connections() {
        return this.connectionsClient.get();
    }

    public OrgProfilesClient orgProfiles() {
        return this.orgProfilesClient.get();
    }

    public DevClient dev() {
        return this.devClient.get();
    }

    public TaskArtifactNotificationsClient taskArtifactNotifications() {
        return this.taskArtifactNotificationsClient.get();
    }

    public DriversClient drivers() {
        return this.driversClient.get();
    }

    public CargosClient cargos() {
        return this.cargosClient.get();
    }

    public TaskArtifactsClient taskArtifacts() {
        return this.taskArtifactsClient.get();
    }

    public OffChrtShipperOrgClient offChrtShipperOrg() {
        return this.offChrtShipperOrgClient.get();
    }

    public OrdersClient orders() {
        return this.ordersClient.get();
    }

    public OrderDraftsClient orderDrafts() {
        return this.orderDraftsClient.get();
    }

    public TaskGroupsClient taskGroups() {
        return this.taskGroupsClient.get();
    }

    public TasksClient tasks() {
        return this.tasksClient.get();
    }

    public ShipperContactInfoClient shipperContactInfo() {
        return this.shipperContactInfoClient.get();
    }

    public OrgsClient orgs() {
        return this.orgsClient.get();
    }

    public RootClient root() {
        return this.rootClient.get();
    }

    public UsersClient users() {
        return this.usersClient.get();
    }

    public UtilsClient utils() {
        return this.utilsClient.get();
    }

    public NotificationsClient notifications() {
        return this.notificationsClient.get();
    }

    public OrgInfoForConnectionsClient orgInfoForConnections() {
        return this.orgInfoForConnectionsClient.get();
    }

    public TrackingClient tracking() {
        return this.trackingClient.get();
    }

    public static ChrtApiClientBuilder builder() {
        return new ChrtApiClientBuilder();
    }
}

