/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.core;

import com.chrt.api.core.ObjectMappers;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Scanner;

public final class Stream<T>
implements Iterable<T>,
Closeable {
    private static final String NEWLINE = "\n";
    private static final String DATA_PREFIX = "data:";
    private final Class<T> valueType;
    private final Scanner scanner;
    private final StreamType streamType;
    private final String messageTerminator;
    private final String streamTerminator;
    private final Reader sseReader;
    private boolean isClosed = false;

    public Stream(Class<T> valueType, Reader reader, String delimiter) {
        this.valueType = valueType;
        this.scanner = new Scanner(reader).useDelimiter(delimiter);
        this.streamType = StreamType.JSON;
        this.messageTerminator = delimiter;
        this.streamTerminator = null;
        this.sseReader = null;
    }

    private Stream(Class<T> valueType, StreamType type, Reader reader, String terminator) {
        this.valueType = valueType;
        this.streamType = type;
        if (type == StreamType.JSON) {
            this.scanner = new Scanner(reader).useDelimiter(terminator);
            this.messageTerminator = terminator;
            this.streamTerminator = null;
            this.sseReader = null;
        } else {
            this.scanner = null;
            this.messageTerminator = NEWLINE;
            this.streamTerminator = terminator;
            this.sseReader = reader;
        }
    }

    public static <T> Stream<T> fromJson(Class<T> valueType, Reader reader, String delimiter) {
        return new Stream<T>(valueType, reader, delimiter);
    }

    public static <T> Stream<T> fromJson(Class<T> valueType, Reader reader) {
        return new Stream<T>(valueType, reader, NEWLINE);
    }

    public static <T> Stream<T> fromSse(Class<T> valueType, Reader sseReader) {
        return new Stream<T>(valueType, StreamType.SSE, sseReader, null);
    }

    public static <T> Stream<T> fromSse(Class<T> valueType, Reader sseReader, String streamTerminator) {
        return new Stream<T>(valueType, StreamType.SSE, sseReader, streamTerminator);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.scanner != null) {
                this.scanner.close();
            }
            if (this.sseReader != null) {
                this.sseReader.close();
            }
        }
    }

    private boolean isStreamClosed() {
        return this.isClosed;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.streamType == StreamType.SSE) {
            return new SSEIterator();
        }
        return new JsonIterator();
    }

    private final class SSEIterator
    implements Iterator<T> {
        private Scanner sseScanner;
        private T nextItem;
        private boolean hasNextItem = false;
        private boolean endOfStream = false;
        private StringBuilder eventDataBuffer = new StringBuilder();
        private String currentEventType = null;

        private SSEIterator() {
            if (Stream.this.sseReader != null && !Stream.this.isStreamClosed()) {
                this.sseScanner = new Scanner(Stream.this.sseReader);
            } else {
                this.endOfStream = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (Stream.this.isStreamClosed() || this.endOfStream) {
                return false;
            }
            if (this.hasNextItem) {
                return true;
            }
            return this.readNextMessage();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in stream");
            }
            Object result = this.nextItem;
            this.nextItem = null;
            this.hasNextItem = false;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean readNextMessage() {
            if (this.sseScanner == null || Stream.this.isStreamClosed()) {
                this.endOfStream = true;
                return false;
            }
            try {
                while (this.sseScanner.hasNextLine()) {
                    String line = this.sseScanner.nextLine();
                    if (line.trim().isEmpty()) {
                        if (this.eventDataBuffer.length() <= 0) continue;
                        try {
                            this.nextItem = ObjectMappers.JSON_MAPPER.readValue(this.eventDataBuffer.toString(), Stream.this.valueType);
                            this.hasNextItem = true;
                            this.eventDataBuffer.setLength(0);
                            this.currentEventType = null;
                            return true;
                        }
                        catch (Exception parseEx) {
                            System.err.println("Failed to parse SSE event: " + parseEx.getMessage());
                            this.eventDataBuffer.setLength(0);
                            this.currentEventType = null;
                            continue;
                        }
                    }
                    if (line.startsWith(Stream.DATA_PREFIX)) {
                        String dataContent = line.substring(Stream.DATA_PREFIX.length());
                        if (dataContent.startsWith(" ")) {
                            dataContent = dataContent.substring(1);
                        }
                        if (this.eventDataBuffer.length() == 0 && Stream.this.streamTerminator != null && dataContent.trim().equals(Stream.this.streamTerminator)) {
                            this.endOfStream = true;
                            return false;
                        }
                        if (this.eventDataBuffer.length() > 0) {
                            this.eventDataBuffer.append('\n');
                        }
                        this.eventDataBuffer.append(dataContent);
                        continue;
                    }
                    if (line.startsWith("event:")) {
                        String eventValue;
                        String string = eventValue = line.length() > 6 ? line.substring(6) : "";
                        if (eventValue.startsWith(" ")) {
                            eventValue = eventValue.substring(1);
                        }
                        this.currentEventType = eventValue;
                        continue;
                    }
                    if (!line.startsWith("id:") && !line.startsWith("retry:") && !line.startsWith(":")) continue;
                }
                if (this.eventDataBuffer.length() > 0) {
                    try {
                        this.nextItem = ObjectMappers.JSON_MAPPER.readValue(this.eventDataBuffer.toString(), Stream.this.valueType);
                        this.hasNextItem = true;
                        this.eventDataBuffer.setLength(0);
                        this.currentEventType = null;
                        return true;
                    }
                    catch (Exception parseEx) {
                        System.err.println("Failed to parse final SSE event: " + parseEx.getMessage());
                        this.eventDataBuffer.setLength(0);
                        this.currentEventType = null;
                    }
                }
                this.endOfStream = true;
                return false;
            }
            catch (Exception e) {
                System.err.println("Failed to parse SSE stream: " + e.getMessage());
                this.endOfStream = true;
                return false;
            }
        }
    }

    private final class JsonIterator
    implements Iterator<T> {
        private JsonIterator() {
        }

        @Override
        public boolean hasNext() {
            if (Stream.this.isStreamClosed()) {
                return false;
            }
            return Stream.this.scanner.hasNext();
        }

        @Override
        public T next() {
            if (Stream.this.isStreamClosed()) {
                throw new NoSuchElementException("Stream is closed");
            }
            if (!Stream.this.scanner.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object parsedResponse = ObjectMappers.JSON_MAPPER.readValue(Stream.this.scanner.next().trim(), Stream.this.valueType);
                return parsedResponse;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum StreamType {
        JSON,
        SSE;

    }
}

