/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.connections;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.connections.RawConnectionsClient;
import com.chrt.api.resources.connections.connectiontocourier.ConnectionToCourierClient;
import com.chrt.api.resources.connections.connectiontoforwarder.ConnectionToForwarderClient;
import com.chrt.api.resources.connections.connectiontoshipper.ConnectionToShipperClient;
import com.chrt.api.resources.connections.types.ConnectionsGetByHandleV1Response;
import com.chrt.api.types.CourierConnectionRes;
import com.chrt.api.types.ForwarderConnectionRes;
import com.chrt.api.types.ShipperConnectionRes;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class ConnectionsClient {
    protected final ClientOptions clientOptions;
    private final RawConnectionsClient rawClient;
    protected final Supplier<ConnectionToCourierClient> connectionToCourierClient;
    protected final Supplier<ConnectionToShipperClient> connectionToShipperClient;
    protected final Supplier<ConnectionToForwarderClient> connectionToForwarderClient;

    public ConnectionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawConnectionsClient(clientOptions);
        this.connectionToCourierClient = Suppliers.memoize(() -> new ConnectionToCourierClient(clientOptions));
        this.connectionToShipperClient = Suppliers.memoize(() -> new ConnectionToShipperClient(clientOptions));
        this.connectionToForwarderClient = Suppliers.memoize(() -> new ConnectionToForwarderClient(clientOptions));
    }

    public RawConnectionsClient withRawResponse() {
        return this.rawClient;
    }

    public List<ShipperConnectionRes> listShippersV1() {
        return this.rawClient.listShippersV1().body();
    }

    public List<ShipperConnectionRes> listShippersV1(RequestOptions requestOptions) {
        return this.rawClient.listShippersV1(requestOptions).body();
    }

    public List<CourierConnectionRes> listCouriersV1() {
        return this.rawClient.listCouriersV1().body();
    }

    public List<CourierConnectionRes> listCouriersV1(RequestOptions requestOptions) {
        return this.rawClient.listCouriersV1(requestOptions).body();
    }

    public List<ForwarderConnectionRes> listForwardersV1() {
        return this.rawClient.listForwardersV1().body();
    }

    public List<ForwarderConnectionRes> listForwardersV1(RequestOptions requestOptions) {
        return this.rawClient.listForwardersV1(requestOptions).body();
    }

    public Optional<ConnectionsGetByHandleV1Response> getByHandleV1(String handle) {
        return this.rawClient.getByHandleV1(handle).body();
    }

    public Optional<ConnectionsGetByHandleV1Response> getByHandleV1(String handle, RequestOptions requestOptions) {
        return this.rawClient.getByHandleV1(handle, requestOptions).body();
    }

    public ConnectionToCourierClient connectionToCourier() {
        return this.connectionToCourierClient.get();
    }

    public ConnectionToShipperClient connectionToShipper() {
        return this.connectionToShipperClient.get();
    }

    public ConnectionToForwarderClient connectionToForwarder() {
        return this.connectionToForwarderClient.get();
    }
}

