/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.courierpaydriverlineitemgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.courierpaydriverlineitemgroups.AsyncRawCourierPayDriverLineItemGroupsClient;
import com.chrt.api.resources.courierpaydriverlineitemgroups.addlineitems.AsyncAddLineItemsClient;
import com.chrt.api.resources.courierpaydriverlineitemgroups.removelineitems.AsyncRemoveLineItemsClient;
import com.chrt.api.types.CourierPayDriverLineItemGroup1;
import com.chrt.api.types.CourierPayDriverLineItemGroupCreateReq;
import com.chrt.api.types.CourierPayDriverLineItemGroupServerCreate1;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncCourierPayDriverLineItemGroupsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCourierPayDriverLineItemGroupsClient rawClient;
    protected final Supplier<AsyncAddLineItemsClient> addLineItemsClient;
    protected final Supplier<AsyncRemoveLineItemsClient> removeLineItemsClient;

    public AsyncCourierPayDriverLineItemGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCourierPayDriverLineItemGroupsClient(clientOptions);
        this.addLineItemsClient = Suppliers.memoize(() -> new AsyncAddLineItemsClient(clientOptions));
        this.removeLineItemsClient = Suppliers.memoize(() -> new AsyncRemoveLineItemsClient(clientOptions));
    }

    public AsyncRawCourierPayDriverLineItemGroupsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CourierPayDriverLineItemGroup1> getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).thenApply(response -> (CourierPayDriverLineItemGroup1)response.body());
    }

    public CompletableFuture<CourierPayDriverLineItemGroup1> getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).thenApply(response -> (CourierPayDriverLineItemGroup1)response.body());
    }

    public CompletableFuture<CourierPayDriverLineItemGroup1> byTaskGroupIdV1(String taskGroupId) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId).thenApply(response -> (CourierPayDriverLineItemGroup1)response.body());
    }

    public CompletableFuture<CourierPayDriverLineItemGroup1> byTaskGroupIdV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId, requestOptions).thenApply(response -> (CourierPayDriverLineItemGroup1)response.body());
    }

    public CompletableFuture<CourierPayDriverLineItemGroupServerCreate1> previewV1(String driverId, CourierPayDriverLineItemGroupCreateReq request) {
        return this.rawClient.previewV1(driverId, request).thenApply(response -> (CourierPayDriverLineItemGroupServerCreate1)response.body());
    }

    public CompletableFuture<CourierPayDriverLineItemGroupServerCreate1> previewV1(String driverId, CourierPayDriverLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.previewV1(driverId, request, requestOptions).thenApply(response -> (CourierPayDriverLineItemGroupServerCreate1)response.body());
    }

    public CompletableFuture<String> createV1(CourierPayDriverLineItemGroupCreateReq request) {
        return this.rawClient.createV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createV1(CourierPayDriverLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public AsyncAddLineItemsClient addLineItems() {
        return this.addLineItemsClient.get();
    }

    public AsyncRemoveLineItemsClient removeLineItems() {
        return this.removeLineItemsClient.get();
    }
}

