/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.courierpaydriverstatements;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.courierpaydriverstatements.AsyncRawCourierPayDriverStatementsClient;
import com.chrt.api.types.CourierPayDriverStatement1;
import com.chrt.api.types.CourierPayDriverStatementClientCreate1;
import com.chrt.api.types.CourierPayDriverStatementClientUpdate1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncCourierPayDriverStatementsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCourierPayDriverStatementsClient rawClient;

    public AsyncCourierPayDriverStatementsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCourierPayDriverStatementsClient(clientOptions);
    }

    public AsyncRawCourierPayDriverStatementsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CourierPayDriverStatement1> getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).thenApply(response -> (CourierPayDriverStatement1)response.body());
    }

    public CompletableFuture<CourierPayDriverStatement1> getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).thenApply(response -> (CourierPayDriverStatement1)response.body());
    }

    public CompletableFuture<List<CourierPayDriverStatement1>> listByDriverIdV1(String driverId) {
        return this.rawClient.listByDriverIdV1(driverId).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<CourierPayDriverStatement1>> listByDriverIdV1(String driverId, RequestOptions requestOptions) {
        return this.rawClient.listByDriverIdV1(driverId, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<String> createV1(CourierPayDriverStatementClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createV1(CourierPayDriverStatementClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<CourierPayDriverStatement1> updateStatusV1(String id) {
        return this.rawClient.updateStatusV1(id).thenApply(response -> (CourierPayDriverStatement1)response.body());
    }

    public CompletableFuture<CourierPayDriverStatement1> updateStatusV1(String id, CourierPayDriverStatementClientUpdate1 request) {
        return this.rawClient.updateStatusV1(id, request).thenApply(response -> (CourierPayDriverStatement1)response.body());
    }

    public CompletableFuture<CourierPayDriverStatement1> updateStatusV1(String id, CourierPayDriverStatementClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateStatusV1(id, request, requestOptions).thenApply(response -> (CourierPayDriverStatement1)response.body());
    }
}

