/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.drivers;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.drivers.AsyncRawDriversClient;
import com.chrt.api.resources.drivers.requests.DriverClientCreate1;
import com.chrt.api.resources.drivers.requests.DriverClientUpdate1;
import com.chrt.api.resources.drivers.requests.DriverLastSeenReq;
import com.chrt.api.resources.drivers.requests.DriversListOrgMembersAndDriversV1Request;
import com.chrt.api.resources.drivers.requests.DriversListV1Request;
import com.chrt.api.types.Driver1;
import com.chrt.api.types.DriverUpdateAvailabilityReq;
import com.chrt.api.types.OrgMembersAndDrivers;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncDriversClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDriversClient rawClient;

    public AsyncDriversClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDriversClient(clientOptions);
    }

    public AsyncRawDriversClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Driver1> getForCallerV1() {
        return this.rawClient.getForCallerV1().thenApply(response -> (Driver1)response.body());
    }

    public CompletableFuture<Driver1> getForCallerV1(RequestOptions requestOptions) {
        return this.rawClient.getForCallerV1(requestOptions).thenApply(response -> (Driver1)response.body());
    }

    public CompletableFuture<Driver1> getByDriverIdV1(String driverId) {
        return this.rawClient.getByDriverIdV1(driverId).thenApply(response -> (Driver1)response.body());
    }

    public CompletableFuture<Driver1> getByDriverIdV1(String driverId, RequestOptions requestOptions) {
        return this.rawClient.getByDriverIdV1(driverId, requestOptions).thenApply(response -> (Driver1)response.body());
    }

    public CompletableFuture<List<OrgMembersAndDrivers>> listOrgMembersAndDriversV1() {
        return this.rawClient.listOrgMembersAndDriversV1().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<OrgMembersAndDrivers>> listOrgMembersAndDriversV1(DriversListOrgMembersAndDriversV1Request request) {
        return this.rawClient.listOrgMembersAndDriversV1(request).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<OrgMembersAndDrivers>> listOrgMembersAndDriversV1(DriversListOrgMembersAndDriversV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listOrgMembersAndDriversV1(request, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<Driver1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<Driver1>> listV1(DriversListV1Request request) {
        return this.rawClient.listV1(request).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<Driver1>> listV1(DriversListV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listV1(request, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<String> createV1(DriverClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> createV1(DriverClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> updateV1(String driverId) {
        return this.rawClient.updateV1(driverId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateV1(String driverId, DriverClientUpdate1 request) {
        return this.rawClient.updateV1(driverId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateV1(String driverId, DriverClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(driverId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateLastSeenV1(DriverLastSeenReq request) {
        return this.rawClient.updateLastSeenV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateLastSeenV1(DriverLastSeenReq request, RequestOptions requestOptions) {
        return this.rawClient.updateLastSeenV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> clearLastSeenV1() {
        return this.rawClient.clearLastSeenV1().thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> clearLastSeenV1(RequestOptions requestOptions) {
        return this.rawClient.clearLastSeenV1(requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateAvailabilityAccordingToDriverV1(DriverUpdateAvailabilityReq request) {
        return this.rawClient.updateAvailabilityAccordingToDriverV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateAvailabilityAccordingToDriverV1(DriverUpdateAvailabilityReq request, RequestOptions requestOptions) {
        return this.rawClient.updateAvailabilityAccordingToDriverV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateAvailabilityAccordingToOperatorsV1(String driverId, DriverUpdateAvailabilityReq request) {
        return this.rawClient.updateAvailabilityAccordingToOperatorsV1(driverId, request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> updateAvailabilityAccordingToOperatorsV1(String driverId, DriverUpdateAvailabilityReq request, RequestOptions requestOptions) {
        return this.rawClient.updateAvailabilityAccordingToOperatorsV1(driverId, request, requestOptions).thenApply(response -> (Boolean)response.body());
    }
}

