/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.drivers.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LocationFeature;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DriverLastSeenReq {
    private final LocationFeature location;
    private final Optional<OffsetDateTime> timestamp;
    private final Map<String, Object> additionalProperties;

    private DriverLastSeenReq(LocationFeature location, Optional<OffsetDateTime> timestamp, Map<String, Object> additionalProperties) {
        this.location = location;
        this.timestamp = timestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location")
    public LocationFeature getLocation() {
        return this.location;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getTimestamp() {
        if (this.timestamp == null) {
            return Optional.empty();
        }
        return this.timestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="timestamp")
    private Optional<OffsetDateTime> _getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DriverLastSeenReq && this.equalTo((DriverLastSeenReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DriverLastSeenReq other) {
        return this.location.equals(other.location) && this.timestamp.equals(other.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.timestamp);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationStage,
    _FinalStage {
        private LocationFeature location;
        private Optional<OffsetDateTime> timestamp = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DriverLastSeenReq other) {
            this.location(other.getLocation());
            this.timestamp(other.getTimestamp());
            return this;
        }

        @Override
        @JsonSetter(value="location")
        public _FinalStage location(@NotNull LocationFeature location) {
            this.location = Objects.requireNonNull(location, "location must not be null");
            return this;
        }

        @Override
        public _FinalStage timestamp(Nullable<OffsetDateTime> timestamp) {
            this.timestamp = timestamp.isNull() ? null : (timestamp.isEmpty() ? Optional.empty() : Optional.of(timestamp.get()));
            return this;
        }

        @Override
        public _FinalStage timestamp(OffsetDateTime timestamp) {
            this.timestamp = Optional.ofNullable(timestamp);
            return this;
        }

        @Override
        @JsonSetter(value="timestamp", nulls=Nulls.SKIP)
        public _FinalStage timestamp(Optional<OffsetDateTime> timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public DriverLastSeenReq build() {
            return new DriverLastSeenReq(this.location, this.timestamp, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DriverLastSeenReq build();

        public _FinalStage timestamp(Optional<OffsetDateTime> var1);

        public _FinalStage timestamp(OffsetDateTime var1);

        public _FinalStage timestamp(Nullable<OffsetDateTime> var1);
    }

    public static interface LocationStage {
        public _FinalStage location(@NotNull LocationFeature var1);

        public Builder from(DriverLastSeenReq var1);
    }
}

