/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.notifications.courier;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.notifications.courier.AsyncRawCourierClient;
import com.chrt.api.resources.notifications.courier.requests.CourierNotificationPreferencesClientCreate1;
import com.chrt.api.types.CourierNotificationPreferences1;
import java.util.concurrent.CompletableFuture;

public class AsyncCourierClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCourierClient rawClient;

    public AsyncCourierClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCourierClient(clientOptions);
    }

    public AsyncRawCourierClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CourierNotificationPreferences1> getPreferencesV1() {
        return this.rawClient.getPreferencesV1().thenApply(response -> (CourierNotificationPreferences1)response.body());
    }

    public CompletableFuture<CourierNotificationPreferences1> getPreferencesV1(RequestOptions requestOptions) {
        return this.rawClient.getPreferencesV1(requestOptions).thenApply(response -> (CourierNotificationPreferences1)response.body());
    }

    public CompletableFuture<String> upsertPreferencesV1(CourierNotificationPreferencesClientCreate1 request) {
        return this.rawClient.upsertPreferencesV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> upsertPreferencesV1(CourierNotificationPreferencesClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.upsertPreferencesV1(request, requestOptions).thenApply(response -> (String)response.body());
    }
}

