/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.notifications.shipper;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.notifications.shipper.AsyncRawShipperClient;
import com.chrt.api.resources.notifications.shipper.requests.ShipperNotificationPreferencesClientCreate1;
import com.chrt.api.types.ShipperNotificationPreferences1;
import java.util.concurrent.CompletableFuture;

public class AsyncShipperClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawShipperClient rawClient;

    public AsyncShipperClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperClient(clientOptions);
    }

    public AsyncRawShipperClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ShipperNotificationPreferences1> getPreferencesV1() {
        return this.rawClient.getPreferencesV1().thenApply(response -> (ShipperNotificationPreferences1)response.body());
    }

    public CompletableFuture<ShipperNotificationPreferences1> getPreferencesV1(RequestOptions requestOptions) {
        return this.rawClient.getPreferencesV1(requestOptions).thenApply(response -> (ShipperNotificationPreferences1)response.body());
    }

    public CompletableFuture<String> upsertPreferencesV1(ShipperNotificationPreferencesClientCreate1 request) {
        return this.rawClient.upsertPreferencesV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> upsertPreferencesV1(ShipperNotificationPreferencesClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.upsertPreferencesV1(request, requestOptions).thenApply(response -> (String)response.body());
    }
}

