/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orderdrafts;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.orderdrafts.requests.OrdersDraftUpdateReq;
import com.chrt.api.resources.orderdrafts.requests.OrdersNewDraftReq;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderDraftExpanded;
import com.chrt.api.types.OrdersDraftUpdateRes;
import com.chrt.api.types.OrdersNewDraftRes;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawOrderDraftsClient {
    protected final ClientOptions clientOptions;

    public RawOrderDraftsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ChrtApiHttpResponse<OrdersNewDraftRes> newV1() {
        return this.newV1(OrdersNewDraftReq.builder().build());
    }

    public ChrtApiHttpResponse<OrdersNewDraftRes> newV1(OrdersNewDraftReq request) {
        return this.newV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<OrdersNewDraftRes> newV1(OrdersNewDraftReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/order_drafts/new/v1").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<OrdersNewDraftRes> chrtApiHttpResponse = new ChrtApiHttpResponse<OrdersNewDraftRes>((OrdersNewDraftRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrdersNewDraftRes.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<OrdersDraftUpdateRes> updateV1(OrdersDraftUpdateReq request) {
        return this.updateV1(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<OrdersDraftUpdateRes> updateV1(OrdersDraftUpdateReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/order_drafts/update/v1").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<OrdersDraftUpdateRes> chrtApiHttpResponse = new ChrtApiHttpResponse<OrdersDraftUpdateRes>((OrdersDraftUpdateRes)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrdersDraftUpdateRes.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<Boolean> deleteV1(String orderId) {
        return this.deleteV1(orderId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<Boolean> deleteV1(String orderId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/order_drafts/delete/v1").addPathSegment(orderId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<Boolean> chrtApiHttpResponse = new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<OrderDraftExpanded> expandedV1(String orderIdOrShortId) {
        return this.expandedV1(orderIdOrShortId, OrderAndTaskGroupExpandedReq.builder().build());
    }

    public ChrtApiHttpResponse<OrderDraftExpanded> expandedV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.expandedV1(orderIdOrShortId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<OrderDraftExpanded> expandedV1(String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/order_drafts/expanded/v1").addPathSegment(orderIdOrShortId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<OrderDraftExpanded> chrtApiHttpResponse = new ChrtApiHttpResponse<OrderDraftExpanded>((OrderDraftExpanded)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrderDraftExpanded.class), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    public ChrtApiHttpResponse<Boolean> validateV1(String orderId) {
        return this.validateV1(orderId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChrtApiHttpResponse<Boolean> validateV1(String orderId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("oort/order_drafts/validate/v1").addPathSegment(orderId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                ChrtApiHttpResponse<Boolean> chrtApiHttpResponse = new ChrtApiHttpResponse<Boolean>((Boolean)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Boolean.TYPE), response);
                return chrtApiHttpResponse;
            }
            try {
                if (response.code() != 422) throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnprocessableEntityError((HttpValidationError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new ChrtApiApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}

