/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orderdrafts.cargo;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.cargo.AsyncRawCargoClient;
import com.chrt.api.resources.orderdrafts.cargo.requests.OrderDraftAddCargoReq;
import com.chrt.api.resources.orderdrafts.cargo.requests.OrderDraftAssociateCargoWithTaskReq;
import com.chrt.api.resources.orderdrafts.cargo.requests.OrderDraftUpdateCargoReq;
import java.util.concurrent.CompletableFuture;

public class AsyncCargoClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCargoClient rawClient;

    public AsyncCargoClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCargoClient(clientOptions);
    }

    public AsyncRawCargoClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<String> addV1(OrderDraftAddCargoReq request) {
        return this.rawClient.addV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> addV1(OrderDraftAddCargoReq request, RequestOptions requestOptions) {
        return this.rawClient.addV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> associateWithTaskV1(OrderDraftAssociateCargoWithTaskReq request) {
        return this.rawClient.associateWithTaskV1(request).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> associateWithTaskV1(OrderDraftAssociateCargoWithTaskReq request, RequestOptions requestOptions) {
        return this.rawClient.associateWithTaskV1(request, requestOptions).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<String> updateV1(OrderDraftUpdateCargoReq request) {
        return this.rawClient.updateV1(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> updateV1(OrderDraftUpdateCargoReq request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String cargoId) {
        return this.rawClient.deleteV1(cargoId).thenApply(response -> (Boolean)response.body());
    }

    public CompletableFuture<Boolean> deleteV1(String cargoId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(cargoId, requestOptions).thenApply(response -> (Boolean)response.body());
    }
}

