/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.orderdrafts.cargo.requests;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.CargoClientCreate1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderDraftAddCargoReq {
    private final String orderId;
    private final CargoClientCreate1 cargo;
    private final Map<String, Object> additionalProperties;

    private OrderDraftAddCargoReq(String orderId, CargoClientCreate1 cargo, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.cargo = cargo;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="cargo")
    public CargoClientCreate1 getCargo() {
        return this.cargo;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderDraftAddCargoReq && this.equalTo((OrderDraftAddCargoReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderDraftAddCargoReq other) {
        return this.orderId.equals(other.orderId) && this.cargo.equals(other.cargo);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.cargo);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderIdStage,
    CargoStage,
    _FinalStage {
        private String orderId;
        private CargoClientCreate1 cargo;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrderDraftAddCargoReq other) {
            this.orderId(other.getOrderId());
            this.cargo(other.getCargo());
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public CargoStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="cargo")
        public _FinalStage cargo(@NotNull CargoClientCreate1 cargo) {
            this.cargo = Objects.requireNonNull(cargo, "cargo must not be null");
            return this;
        }

        @Override
        public OrderDraftAddCargoReq build() {
            return new OrderDraftAddCargoReq(this.orderId, this.cargo, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrderDraftAddCargoReq build();
    }

    public static interface CargoStage {
        public _FinalStage cargo(@NotNull CargoClientCreate1 var1);
    }

    public static interface OrderIdStage {
        public CargoStage orderId(@NotNull String var1);

        public Builder from(OrderDraftAddCargoReq var1);
    }
}

